/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\t"}, d2={"resolvePath", "Ljava/nio/file/Path;", "root", "", "path", "resolveAndValidateFile", "formatFileSize", "bytes", "", "embabel-agent-api"})
public final class FileUtilsKt {
    @NotNull
    public static final Path resolvePath(@NotNull String root, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path basePath = Paths.get(root, new String[0]).toAbsolutePath().normalize();
        Path resolvedPath = basePath.resolve(path).normalize().toAbsolutePath();
        if (!resolvedPath.startsWith(basePath)) {
            throw new SecurityException("Path traversal attempt detected: " + path + ", root=" + root + ", resolved='" + resolvedPath + "', base=$'basePath'");
        }
        Intrinsics.checkNotNull((Object)resolvedPath);
        return resolvedPath;
    }

    @NotNull
    public static final Path resolveAndValidateFile(@NotNull String root, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path resolvedPath = FileUtilsKt.resolvePath(root, path);
        if (!Files.exists(resolvedPath, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + path + ", root=" + root);
        }
        if (!Files.isRegularFile(resolvedPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Path is not a regular file: " + path + ", root=" + root);
        }
        return resolvedPath;
    }

    @NotNull
    public static final String formatFileSize(long bytes) {
        Object object;
        if (bytes < 1024L) {
            object = bytes + " bytes";
        } else if (bytes < 0x100000L) {
            String string = "%.2f KB";
            Object[] objectArray = new Object[]{(double)bytes / 1024.0};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else if (bytes < 0x40000000L) {
            String string = "%.2f MB";
            Object[] objectArray = new Object[]{(double)bytes / 1048576.0};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            String string = "%.2f GB";
            Object[] objectArray = new Object[]{(double)bytes / 1.073741824E9};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            object = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        }
        return object;
    }
}

