/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.guardrails;

import com.embabel.agent.api.validation.guardrails.AssistantMessageGuardRail;
import com.embabel.agent.api.validation.guardrails.GuardRailViolationException;
import com.embabel.agent.api.validation.guardrails.UserInputGuardRail;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.support.InMemoryBlackboard;
import com.embabel.agent.core.support.LlmInteraction;
import com.embabel.chat.AssistantMessage;
import com.embabel.chat.UserMessage;
import com.embabel.common.core.thinking.ThinkingResponse;
import com.embabel.common.core.validation.ValidationError;
import com.embabel.common.core.validation.ValidationResult;
import com.embabel.common.core.validation.ValidationSeverity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a4\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u001a\"\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a(\u0010\f\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\"\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\"\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a&\u0010\u0012\u001a\u00020\u00032\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"logger", "Lorg/slf4j/Logger;", "validateUserInputInternal", "", "interaction", "Lcom/embabel/agent/core/support/LlmInteraction;", "blackboard", "Lcom/embabel/agent/core/Blackboard;", "validator", "Lkotlin/Function2;", "Lcom/embabel/agent/api/validation/guardrails/UserInputGuardRail;", "Lcom/embabel/common/core/validation/ValidationResult;", "validateUserInput", "promptAsString", "", "userMessages", "", "Lcom/embabel/chat/UserMessage;", "validateAssistantResponse", "response", "Lcom/embabel/chat/AssistantMessage;", "Lcom/embabel/common/core/thinking/ThinkingResponse;", "handleValidationResult", "guardName", "result", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nllmOperationGuardRails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 llmOperationGuardRails.kt\ncom/embabel/agent/spi/support/guardrails/LlmOperationGuardRailsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,177:1\n808#2,11:178\n1863#2,2:189\n808#2,11:191\n1863#2,2:202\n808#2,11:204\n1863#2,2:215\n808#2,11:217\n1863#2,2:228\n1971#2,14:230\n27#3:244\n*S KotlinDebug\n*F\n+ 1 llmOperationGuardRails.kt\ncom/embabel/agent/spi/support/guardrails/LlmOperationGuardRailsKt\n*L\n43#1:178,11\n48#1:189,2\n89#1:191,11\n94#1:202,2\n109#1:204,11\n114#1:215,2\n129#1:217,11\n134#1:228,2\n150#1:230,14\n32#1:244\n*E\n"})
public final class LlmOperationGuardRailsKt {
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    private static final void validateUserInputInternal(LlmInteraction interaction, Blackboard blackboard, Function2<? super UserInputGuardRail, ? super Blackboard, ValidationResult> validator) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Iterable iterable = interaction.getGuardRails();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserInputGuardRail)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List userInputGuards = (List)destination$iv$iv;
        if (userInputGuards.isEmpty()) {
            return;
        }
        Blackboard blackboard2 = blackboard;
        if (blackboard2 == null) {
            blackboard2 = new InMemoryBlackboard(null, 1, null);
        }
        Blackboard effectiveBlackboard = blackboard2;
        Iterable $this$forEach$iv = userInputGuards;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserInputGuardRail guard = (UserInputGuardRail)element$iv;
            boolean bl = false;
            ValidationResult result = (ValidationResult)validator.invoke((Object)guard, (Object)effectiveBlackboard);
            LlmOperationGuardRailsKt.handleValidationResult(guard.getName(), result);
        }
    }

    public static final void validateUserInput(@NotNull String promptAsString, @NotNull LlmInteraction interaction, @Nullable Blackboard blackboard) {
        Intrinsics.checkNotNullParameter((Object)promptAsString, (String)"promptAsString");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        LlmOperationGuardRailsKt.validateUserInputInternal(interaction, blackboard, (Function2<? super UserInputGuardRail, ? super Blackboard, ValidationResult>)((Function2)(arg_0, arg_1) -> LlmOperationGuardRailsKt.validateUserInput$lambda$1(promptAsString, arg_0, arg_1)));
    }

    public static final void validateUserInput(@NotNull List<UserMessage> userMessages, @NotNull LlmInteraction interaction, @Nullable Blackboard blackboard) {
        Intrinsics.checkNotNullParameter(userMessages, (String)"userMessages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        LlmOperationGuardRailsKt.validateUserInputInternal(interaction, blackboard, (Function2<? super UserInputGuardRail, ? super Blackboard, ValidationResult>)((Function2)(arg_0, arg_1) -> LlmOperationGuardRailsKt.validateUserInput$lambda$2(userMessages, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateAssistantResponse(@NotNull String response, @NotNull LlmInteraction interaction, @Nullable Blackboard blackboard) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Iterable iterable = interaction.getGuardRails();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AssistantMessageGuardRail)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List assistantGuards = (List)destination$iv$iv;
        if (assistantGuards.isEmpty()) {
            return;
        }
        Blackboard blackboard2 = blackboard;
        if (blackboard2 == null) {
            blackboard2 = new InMemoryBlackboard(null, 1, null);
        }
        Blackboard effectiveBlackboard = blackboard2;
        Iterable $this$forEach$iv = assistantGuards;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AssistantMessageGuardRail guard = (AssistantMessageGuardRail)element$iv;
            boolean bl = false;
            ValidationResult result = guard.validate(response, effectiveBlackboard);
            LlmOperationGuardRailsKt.handleValidationResult(guard.getName(), result);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateAssistantResponse(@NotNull AssistantMessage response, @NotNull LlmInteraction interaction, @Nullable Blackboard blackboard) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Iterable iterable = interaction.getGuardRails();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AssistantMessageGuardRail)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List assistantGuards = (List)destination$iv$iv;
        if (assistantGuards.isEmpty()) {
            return;
        }
        Blackboard blackboard2 = blackboard;
        if (blackboard2 == null) {
            blackboard2 = new InMemoryBlackboard(null, 1, null);
        }
        Blackboard effectiveBlackboard = blackboard2;
        Iterable $this$forEach$iv = assistantGuards;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AssistantMessageGuardRail guard = (AssistantMessageGuardRail)element$iv;
            boolean bl = false;
            ValidationResult result = guard.validate(response, effectiveBlackboard);
            LlmOperationGuardRailsKt.handleValidationResult(guard.getName(), result);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateAssistantResponse(@NotNull ThinkingResponse<?> response, @NotNull LlmInteraction interaction, @Nullable Blackboard blackboard) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Iterable iterable = interaction.getGuardRails();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AssistantMessageGuardRail)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List assistantGuards = (List)destination$iv$iv;
        if (assistantGuards.isEmpty()) {
            return;
        }
        Blackboard blackboard2 = blackboard;
        if (blackboard2 == null) {
            blackboard2 = new InMemoryBlackboard(null, 1, null);
        }
        Blackboard effectiveBlackboard = blackboard2;
        Iterable $this$forEach$iv = assistantGuards;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AssistantMessageGuardRail guard = (AssistantMessageGuardRail)element$iv;
            boolean bl = false;
            ValidationResult result = guard.validate(response, effectiveBlackboard);
            LlmOperationGuardRailsKt.handleValidationResult(guard.getName(), result);
        }
    }

    private static final void handleValidationResult(String guardName, ValidationResult result) {
        Object object;
        Object v0;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)ValidationSeverity.INFO), (Object)1), TuplesKt.to((Object)((Object)ValidationSeverity.WARNING), (Object)2), TuplesKt.to((Object)((Object)ValidationSeverity.ERROR), (Object)3), TuplesKt.to((Object)((Object)ValidationSeverity.CRITICAL), (Object)4)};
        Map severityPriority = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$maxByOrNull$iv = result.getErrors();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ValidationError it = (ValidationError)maxElem$iv;
                boolean bl = false;
                Integer n = (Integer)severityPriority.get((Object)it.getSeverity());
                int maxValue$iv = n != null ? n : 0;
                do {
                    int v$iv;
                    Object e$iv = iterator$iv.next();
                    ValidationError it2 = (ValidationError)e$iv;
                    $i$a$-maxByOrNull-LlmOperationGuardRailsKt$handleValidationResult$highestSeverity$1 = false;
                    Integer n2 = (Integer)severityPriority.get((Object)it2.getSeverity());
                    int n3 = v$iv = n2 != null ? n2 : 0;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        if ((object = (ValidationError)v0) == null || (object = ((ValidationError)object).getSeverity()) == null) {
            object = ValidationSeverity.INFO;
        }
        Object highestSeverity = object;
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)highestSeverity).ordinal()]) {
            case 1: {
                if (!(!((Collection)result.getErrors()).isEmpty())) break;
                logger.info("GuardRail '{}' info: {}", (Object)guardName, (Object)CollectionsKt.joinToString$default((Iterable)result.getErrors(), (CharSequence)"; ", null, null, (int)0, null, LlmOperationGuardRailsKt::handleValidationResult$lambda$7, (int)30, null));
                break;
            }
            case 2: {
                logger.warn("GuardRail '{}' warning: {}", (Object)guardName, (Object)CollectionsKt.joinToString$default((Iterable)result.getErrors(), (CharSequence)"; ", null, null, (int)0, null, LlmOperationGuardRailsKt::handleValidationResult$lambda$8, (int)30, null));
                break;
            }
            case 3: {
                logger.error("GuardRail '{}' error: {}", (Object)guardName, (Object)CollectionsKt.joinToString$default((Iterable)result.getErrors(), (CharSequence)"; ", null, null, (int)0, null, LlmOperationGuardRailsKt::handleValidationResult$lambda$9, (int)30, null));
                break;
            }
            case 4: {
                throw new GuardRailViolationException(guardName, CollectionsKt.joinToString$default((Iterable)result.getErrors(), (CharSequence)"; ", null, null, (int)0, null, LlmOperationGuardRailsKt::handleValidationResult$lambda$10, (int)30, null), (ValidationSeverity)((Object)highestSeverity));
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final ValidationResult validateUserInput$lambda$1(String $promptAsString, UserInputGuardRail guard, Blackboard bb) {
        Intrinsics.checkNotNullParameter((Object)guard, (String)"guard");
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        return guard.validate($promptAsString, bb);
    }

    private static final ValidationResult validateUserInput$lambda$2(List $userMessages, UserInputGuardRail guard, Blackboard bb) {
        Intrinsics.checkNotNullParameter((Object)guard, (String)"guard");
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        return guard.validate($userMessages, bb);
    }

    private static final CharSequence handleValidationResult$lambda$7(ValidationError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    private static final CharSequence handleValidationResult$lambda$8(ValidationError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    private static final CharSequence handleValidationResult$lambda$9(ValidationError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    private static final CharSequence handleValidationResult$lambda$10(ValidationError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    static {
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LlmOperationGuardRailsKt.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationSeverity.values().length];
            try {
                nArray[ValidationSeverity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationSeverity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationSeverity.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationSeverity.CRITICAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

