/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/embabel/agent/spi/support/ObservabilityToolCallback;", "Lorg/springframework/ai/tool/ToolCallback;", "delegate", "observationRegistry", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Lorg/springframework/ai/tool/ToolCallback;Lio/micrometer/observation/ObservationRegistry;)V", "getToolDefinition", "Lorg/springframework/ai/tool/definition/ToolDefinition;", "call", "", "toolInput", "toString", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nObservabilityToolCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObservabilityToolCallback.kt\ncom/embabel/agent/spi/support/ObservabilityToolCallback\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,73:1\n27#2:74\n*S KotlinDebug\n*F\n+ 1 ObservabilityToolCallback.kt\ncom/embabel/agent/spi/support/ObservabilityToolCallback\n*L\n40#1:74\n*E\n"})
public final class ObservabilityToolCallback
implements ToolCallback {
    @NotNull
    private final ToolCallback delegate;
    @Nullable
    private final ObservationRegistry observationRegistry;

    public ObservabilityToolCallback(@NotNull ToolCallback delegate, @Nullable ObservationRegistry observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.observationRegistry = observationRegistry;
    }

    public /* synthetic */ ObservabilityToolCallback(ToolCallback toolCallback, ObservationRegistry observationRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            observationRegistry = null;
        }
        this(toolCallback, observationRegistry);
    }

    @NotNull
    public ToolDefinition getToolDefinition() {
        ToolDefinition toolDefinition = this.delegate.getToolDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)toolDefinition, (String)"getToolDefinition(...)");
        return toolDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String call(@NotNull String toolInput) {
        String string;
        Intrinsics.checkNotNullParameter((Object)toolInput, (String)"toolInput");
        if (this.observationRegistry == null) {
            String string2 = this.delegate.call(toolInput);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"call(...)");
            return string2;
        }
        Observation currentObservation = this.observationRegistry.getCurrentObservation();
        if (currentObservation == null) {
            boolean $i$f$loggerFor22 = false;
            Logger logger = LoggerFactory.getLogger(ObservabilityToolCallback.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            Object[] $i$f$loggerFor22 = new Object[]{this.delegate.getToolDefinition().name(), toolInput, this.observationRegistry};
            logger.warn("No parent observation for tool call {} with input: {}, observation registry: {}", $i$f$loggerFor22);
        }
        Observation observation = Observation.createNotStarted((String)"tool call", (ObservationRegistry)this.observationRegistry).lowCardinalityKeyValue("toolName", this.delegate.getToolDefinition().name()).highCardinalityKeyValue("payload", toolInput).parentObservation(currentObservation).start();
        Intrinsics.checkNotNullExpressionValue((Object)observation, (String)"start(...)");
        Observation observation2 = observation;
        try {
            String string3 = this.delegate.call(toolInput);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"call(...)");
            String result = string3;
            observation2.lowCardinalityKeyValue("status", "success");
            observation2.highCardinalityKeyValue("result", result);
            string = result;
        }
        catch (Exception ex) {
            observation2.lowCardinalityKeyValue("status", "error");
            String string4 = Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName();
            if (string4 == null) {
                string4 = "Unknown";
            }
            observation2.highCardinalityKeyValue("error_type", string4);
            String string5 = ex.getMessage();
            if (string5 == null) {
                string5 = "No message";
            }
            observation2.highCardinalityKeyValue("error_message", string5);
            observation2.error((Throwable)ex);
            throw ex;
        }
        finally {
            observation2.stop();
        }
        return string;
    }

    @NotNull
    public String toString() {
        return "ObservabilityToolCallback(delegate=" + this.delegate.getToolDefinition().name() + ")";
    }
}

