/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.loop.support;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.ToolControlFlowSignal;
import com.embabel.agent.api.tool.config.ToolLoopConfiguration;
import com.embabel.agent.core.BlackboardUpdater;
import com.embabel.agent.core.ReplanRequestedException;
import com.embabel.agent.spi.loop.LlmMessageSender;
import com.embabel.agent.spi.loop.ToolInjectionStrategy;
import com.embabel.agent.spi.loop.ToolNotFoundException;
import com.embabel.agent.spi.loop.support.DefaultToolLoop;
import com.embabel.chat.ToolCall;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0001\"BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/embabel/agent/spi/loop/support/ParallelToolLoop;", "Lcom/embabel/agent/spi/loop/support/DefaultToolLoop;", "llmMessageSender", "Lcom/embabel/agent/spi/loop/LlmMessageSender;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "injectionStrategy", "Lcom/embabel/agent/spi/loop/ToolInjectionStrategy;", "maxIterations", "", "toolDecorator", "Lkotlin/Function1;", "Lcom/embabel/agent/api/tool/Tool;", "executor", "Ljava/util/concurrent/ExecutorService;", "parallelConfig", "Lcom/embabel/agent/api/tool/config/ToolLoopConfiguration$ParallelModeProperties;", "<init>", "(Lcom/embabel/agent/spi/loop/LlmMessageSender;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/embabel/agent/spi/loop/ToolInjectionStrategy;ILkotlin/jvm/functions/Function1;Ljava/util/concurrent/ExecutorService;Lcom/embabel/agent/api/tool/config/ToolLoopConfiguration$ParallelModeProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "processToolCalls", "", "toolCalls", "", "Lcom/embabel/chat/ToolCall;", "state", "Lcom/embabel/agent/spi/loop/support/DefaultToolLoop$LoopState;", "executeSingleToolCall", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult;", "toolCall", "availableTools", "ParallelToolResult", "embabel-agent-api"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nParallelToolLoop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelToolLoop.kt\ncom/embabel/agent/spi/loop/support/ParallelToolLoop\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,223:1\n1557#2:224\n1628#2,3:225\n1557#2:232\n1628#2,3:233\n808#2,11:236\n808#2,11:247\n1557#2:258\n1628#2,3:259\n1557#2:262\n1628#2,3:263\n37#3:228\n36#3,3:229\n*S KotlinDebug\n*F\n+ 1 ParallelToolLoop.kt\ncom/embabel/agent/spi/loop/support/ParallelToolLoop\n*L\n99#1:224\n99#1:225,3\n127#1:232\n127#1:233,3\n134#1:236,11\n162#1:247,11\n177#1:258\n177#1:259,3\n123#1:262\n123#1:263,3\n121#1:228\n121#1:229,3\n*E\n"})
public final class ParallelToolLoop
extends DefaultToolLoop {
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final ToolLoopConfiguration.ParallelModeProperties parallelConfig;
    private final Logger logger;

    public ParallelToolLoop(@NotNull LlmMessageSender llmMessageSender, @NotNull ObjectMapper objectMapper, @NotNull ToolInjectionStrategy injectionStrategy, int maxIterations, @Nullable Function1<? super Tool, ? extends Tool> toolDecorator, @NotNull ExecutorService executor, @NotNull ToolLoopConfiguration.ParallelModeProperties parallelConfig) {
        Intrinsics.checkNotNullParameter((Object)llmMessageSender, (String)"llmMessageSender");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)injectionStrategy, (String)"injectionStrategy");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)parallelConfig, (String)"parallelConfig");
        super(llmMessageSender, objectMapper, injectionStrategy, maxIterations, toolDecorator);
        this.executor = executor;
        this.parallelConfig = parallelConfig;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean processToolCalls(@NotNull List<ToolCall> toolCalls, @NotNull DefaultToolLoop.LoopState state) {
        void $this$filterIsInstanceTo$iv$iv;
        ParallelToolResult $this$filterIsInstanceTo$iv$iv2;
        Object item$iv$iv3;
        Iterable destination$iv$iv;
        Object $i$f$map2;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(toolCalls, (String)"toolCalls");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (toolCalls.size() == 1) {
            return super.processToolCalls(toolCalls, state);
        }
        this.logger.debug("Executing {} tools in parallel", (Object)toolCalls.size());
        long startTime = System.currentTimeMillis();
        List availableToolsSnapshot = CollectionsKt.toList((Iterable)state.getAvailableTools());
        long perToolTimeoutMs = this.parallelConfig.getPerToolTimeout().toMillis();
        Iterable $this$map$iv = toolCalls;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void toolCall;
            ToolCall toolCall2 = (ToolCall)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(CompletableFuture.supplyAsync(() -> ParallelToolLoop.processToolCalls$lambda$2$lambda$0(this, (ToolCall)toolCall, availableToolsSnapshot), this.executor).orTimeout(perToolTimeoutMs, TimeUnit.MILLISECONDS).exceptionally(arg_0 -> ParallelToolLoop.processToolCalls$lambda$2$lambda$1(this, (ToolCall)toolCall, perToolTimeoutMs, arg_0)));
        }
        List futures = (List)destination$iv$iv2;
        try {
            Collection $this$toTypedArray$iv = futures;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $i$f$map2 = thisCollection$iv.toArray(new CompletableFuture[0]);
            $i$f$map2 = (List)((CompletableFuture)CompletableFuture.allOf(Arrays.copyOf($i$f$map2, ((CompletableFuture[])$i$f$map2).length)).orTimeout(this.parallelConfig.getBatchTimeout().toMillis(), TimeUnit.MILLISECONDS).thenApply(arg_0 -> ParallelToolLoop.processToolCalls$lambda$5(arg_0 -> ParallelToolLoop.processToolCalls$lambda$4(futures, arg_0), arg_0))).join();
        }
        catch (Exception e) {
            void $this$mapTo$iv$iv2;
            this.logger.warn("Batch timeout exceeded, collecting available results");
            Iterable $this$map$iv2 = futures;
            boolean $i$f$map3 = false;
            Iterable iterable2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                void f;
                CompletableFuture completableFuture = (CompletableFuture)item$iv$iv3;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((ParallelToolResult)f.getNow(new ParallelToolResult.Timeout(toolCalls.get(futures.indexOf(f)))));
            }
            $i$f$map2 = (List)destination$iv$iv;
        }
        Object results = $i$f$map2;
        long duration = System.currentTimeMillis() - startTime;
        this.logger.debug("All {} tools completed in {}ms", (Object)toolCalls.size(), (Object)duration);
        Intrinsics.checkNotNull((Object)results);
        Object $this$filterIsInstance$iv = (Iterable)results;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        item$iv$iv3 = $this$filterIsInstanceTo$iv$iv2.iterator();
        while (item$iv$iv3.hasNext()) {
            Object element$iv$iv = item$iv$iv3.next();
            if (!(element$iv$iv instanceof ParallelToolResult.ReplanRequest)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        ParallelToolResult.ReplanRequest replanRequest = (ParallelToolResult.ReplanRequest)CollectionsKt.firstOrNull((List)((List)destination$iv$iv3));
        if (replanRequest != null) {
            this.logger.debug("Tool '{}' requested replan: {}", (Object)replanRequest.getToolCall().getName(), (Object)replanRequest.getReason());
            state.setReplanRequested(true);
            state.setReplanReason(replanRequest.getReason());
            state.setBlackboardUpdater(replanRequest.getBlackboardUpdater());
            return false;
        }
        $this$filterIsInstance$iv = results.iterator();
        while ($this$filterIsInstance$iv.hasNext()) {
            ParallelToolResult result = (ParallelToolResult)$this$filterIsInstance$iv.next();
            $this$filterIsInstanceTo$iv$iv2 = result;
            if ($this$filterIsInstanceTo$iv$iv2 instanceof ParallelToolResult.Success) {
                this.addToolResultToHistory(((ParallelToolResult.Success)result).getToolCall(), ((ParallelToolResult.Success)result).getResult(), state);
                continue;
            }
            if ($this$filterIsInstanceTo$iv$iv2 instanceof ParallelToolResult.Error) {
                this.addToolResultToHistory(((ParallelToolResult.Error)result).getToolCall(), "Error: " + ((ParallelToolResult.Error)result).getMessage(), state);
                continue;
            }
            if ($this$filterIsInstanceTo$iv$iv2 instanceof ParallelToolResult.Timeout) {
                this.addToolResultToHistory(((ParallelToolResult.Timeout)result).getToolCall(), "Error: Tool execution timed out", state);
                continue;
            }
            if ($this$filterIsInstanceTo$iv$iv2 instanceof ParallelToolResult.ReplanRequest) continue;
            throw new NoWhenBranchMatchedException();
        }
        Iterable $this$filterIsInstance$iv2 = (Iterable)results;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv3 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ParallelToolResult.Success)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        ParallelToolResult.Success lastSuccess = (ParallelToolResult.Success)CollectionsKt.lastOrNull((List)((List)destination$iv$iv4));
        if (lastSuccess != null) {
            this.applyInjectionStrategy(lastSuccess.getToolCall(), lastSuccess.getResult(), state);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final ParallelToolResult executeSingleToolCall(ToolCall toolCall, List<? extends Tool> availableTools) {
        ParallelToolResult parallelToolResult;
        Tool tool = this.findTool(availableTools, toolCall.getName());
        if (tool == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = availableTools;
            String string = toolCall.getName();
            ToolCall toolCall2 = toolCall;
            boolean $i$f$map = false;
            void var8_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tool tool2 = (Tool)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getDefinition().getName());
            }
            String string2 = string;
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            Object object = new ToolNotFoundException(string2, (List<String>)collection2).getMessage();
            if (object == null) {
                object = "Tool not found: " + toolCall.getName();
            }
            String string3 = object;
            ToolCall toolCall3 = toolCall2;
            return new ParallelToolResult.Error(toolCall3, string3);
        }
        Tool tool3 = tool;
        try {
            String result = this.executeToolCall(tool3, toolCall);
            parallelToolResult = new ParallelToolResult.Success(toolCall, result);
        }
        catch (ReplanRequestedException e) {
            parallelToolResult = new ParallelToolResult.ReplanRequest(toolCall, e.getReason(), e.getBlackboardUpdater());
        }
        catch (Exception e) {
            if (e instanceof ToolControlFlowSignal) {
                throw e;
            }
            this.logger.error("Tool '{}' execution failed", (Object)toolCall.getName(), (Object)e);
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            parallelToolResult = new ParallelToolResult.Error(toolCall, string);
        }
        return parallelToolResult;
    }

    private static final ParallelToolResult processToolCalls$lambda$2$lambda$0(ParallelToolLoop this$0, ToolCall $toolCall, List $availableToolsSnapshot) {
        return this$0.executeSingleToolCall($toolCall, $availableToolsSnapshot);
    }

    private static final ParallelToolResult processToolCalls$lambda$2$lambda$1(ParallelToolLoop this$0, ToolCall $toolCall, long $perToolTimeoutMs, Throwable e) {
        ParallelToolResult parallelToolResult;
        Throwable throwable = e.getCause();
        if (throwable == null) {
            throwable = e;
        }
        if (throwable instanceof TimeoutException) {
            this$0.logger.warn("Tool '{}' timed out after {}ms", (Object)$toolCall.getName(), (Object)$perToolTimeoutMs);
            parallelToolResult = new ParallelToolResult.Timeout($toolCall);
        } else {
            this$0.logger.error("Unexpected error for tool '{}'", (Object)$toolCall.getName(), (Object)e);
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            parallelToolResult = new ParallelToolResult.Error($toolCall, string);
        }
        return parallelToolResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final List processToolCalls$lambda$4(List $futures, Void it) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $futures;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void f;
            CompletableFuture completableFuture = (CompletableFuture)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ParallelToolResult)f.join());
        }
        return (List)destination$iv$iv;
    }

    private static final List processToolCalls$lambda$5(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\b\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult;", "", "<init>", "()V", "toolCall", "Lcom/embabel/chat/ToolCall;", "getToolCall", "()Lcom/embabel/chat/ToolCall;", "Success", "ReplanRequest", "Error", "Timeout", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult$Error;", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult$ReplanRequest;", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult$Success;", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult$Timeout;", "embabel-agent-api"})
    private static abstract sealed class ParallelToolResult {
        private ParallelToolResult() {
        }

        @NotNull
        public abstract ToolCall getToolCall();

        public /* synthetic */ ParallelToolResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult$Error;", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult;", "toolCall", "Lcom/embabel/chat/ToolCall;", "message", "", "<init>", "(Lcom/embabel/chat/ToolCall;Ljava/lang/String;)V", "getToolCall", "()Lcom/embabel/chat/ToolCall;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "embabel-agent-api"})
        public static final class Error
        extends ParallelToolResult {
            @NotNull
            private final ToolCall toolCall;
            @NotNull
            private final String message;

            public Error(@NotNull ToolCall toolCall, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.toolCall = toolCall;
                this.message = message;
            }

            @Override
            @NotNull
            public ToolCall getToolCall() {
                return this.toolCall;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final ToolCall component1() {
                return this.toolCall;
            }

            @NotNull
            public final String component2() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull ToolCall toolCall, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(toolCall, message);
            }

            public static /* synthetic */ Error copy$default(Error error, ToolCall toolCall, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    toolCall = error.toolCall;
                }
                if ((n & 2) != 0) {
                    string = error.message;
                }
                return error.copy(toolCall, string);
            }

            @NotNull
            public String toString() {
                return "Error(toolCall=" + this.toolCall + ", message=" + this.message + ")";
            }

            public int hashCode() {
                int result = this.toolCall.hashCode();
                result = result * 31 + this.message.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                if (!Intrinsics.areEqual((Object)this.toolCall, (Object)error.toolCall)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.message, (Object)error.message);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult$ReplanRequest;", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult;", "toolCall", "Lcom/embabel/chat/ToolCall;", "reason", "", "blackboardUpdater", "Lcom/embabel/agent/core/BlackboardUpdater;", "<init>", "(Lcom/embabel/chat/ToolCall;Ljava/lang/String;Lcom/embabel/agent/core/BlackboardUpdater;)V", "getToolCall", "()Lcom/embabel/chat/ToolCall;", "getReason", "()Ljava/lang/String;", "getBlackboardUpdater", "()Lcom/embabel/agent/core/BlackboardUpdater;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "embabel-agent-api"})
        public static final class ReplanRequest
        extends ParallelToolResult {
            @NotNull
            private final ToolCall toolCall;
            @NotNull
            private final String reason;
            @NotNull
            private final BlackboardUpdater blackboardUpdater;

            public ReplanRequest(@NotNull ToolCall toolCall, @NotNull String reason, @NotNull BlackboardUpdater blackboardUpdater) {
                Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Intrinsics.checkNotNullParameter((Object)blackboardUpdater, (String)"blackboardUpdater");
                super(null);
                this.toolCall = toolCall;
                this.reason = reason;
                this.blackboardUpdater = blackboardUpdater;
            }

            @Override
            @NotNull
            public ToolCall getToolCall() {
                return this.toolCall;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final BlackboardUpdater getBlackboardUpdater() {
                return this.blackboardUpdater;
            }

            @NotNull
            public final ToolCall component1() {
                return this.toolCall;
            }

            @NotNull
            public final String component2() {
                return this.reason;
            }

            @NotNull
            public final BlackboardUpdater component3() {
                return this.blackboardUpdater;
            }

            @NotNull
            public final ReplanRequest copy(@NotNull ToolCall toolCall, @NotNull String reason, @NotNull BlackboardUpdater blackboardUpdater) {
                Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Intrinsics.checkNotNullParameter((Object)blackboardUpdater, (String)"blackboardUpdater");
                return new ReplanRequest(toolCall, reason, blackboardUpdater);
            }

            public static /* synthetic */ ReplanRequest copy$default(ReplanRequest replanRequest, ToolCall toolCall, String string, BlackboardUpdater blackboardUpdater, int n, Object object) {
                if ((n & 1) != 0) {
                    toolCall = replanRequest.toolCall;
                }
                if ((n & 2) != 0) {
                    string = replanRequest.reason;
                }
                if ((n & 4) != 0) {
                    blackboardUpdater = replanRequest.blackboardUpdater;
                }
                return replanRequest.copy(toolCall, string, blackboardUpdater);
            }

            @NotNull
            public String toString() {
                return "ReplanRequest(toolCall=" + this.toolCall + ", reason=" + this.reason + ", blackboardUpdater=" + this.blackboardUpdater + ")";
            }

            public int hashCode() {
                int result = this.toolCall.hashCode();
                result = result * 31 + this.reason.hashCode();
                result = result * 31 + this.blackboardUpdater.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReplanRequest)) {
                    return false;
                }
                ReplanRequest replanRequest = (ReplanRequest)other;
                if (!Intrinsics.areEqual((Object)this.toolCall, (Object)replanRequest.toolCall)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.reason, (Object)replanRequest.reason)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.blackboardUpdater, (Object)replanRequest.blackboardUpdater);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult$Success;", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult;", "toolCall", "Lcom/embabel/chat/ToolCall;", "result", "", "<init>", "(Lcom/embabel/chat/ToolCall;Ljava/lang/String;)V", "getToolCall", "()Lcom/embabel/chat/ToolCall;", "getResult", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "embabel-agent-api"})
        public static final class Success
        extends ParallelToolResult {
            @NotNull
            private final ToolCall toolCall;
            @NotNull
            private final String result;

            public Success(@NotNull ToolCall toolCall, @NotNull String result) {
                Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                super(null);
                this.toolCall = toolCall;
                this.result = result;
            }

            @Override
            @NotNull
            public ToolCall getToolCall() {
                return this.toolCall;
            }

            @NotNull
            public final String getResult() {
                return this.result;
            }

            @NotNull
            public final ToolCall component1() {
                return this.toolCall;
            }

            @NotNull
            public final String component2() {
                return this.result;
            }

            @NotNull
            public final Success copy(@NotNull ToolCall toolCall, @NotNull String result) {
                Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                return new Success(toolCall, result);
            }

            public static /* synthetic */ Success copy$default(Success success, ToolCall toolCall, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    toolCall = success.toolCall;
                }
                if ((n & 2) != 0) {
                    string = success.result;
                }
                return success.copy(toolCall, string);
            }

            @NotNull
            public String toString() {
                return "Success(toolCall=" + this.toolCall + ", result=" + this.result + ")";
            }

            public int hashCode() {
                int result = this.toolCall.hashCode();
                result = result * 31 + this.result.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                if (!Intrinsics.areEqual((Object)this.toolCall, (Object)success.toolCall)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.result, (Object)success.result);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult$Timeout;", "Lcom/embabel/agent/spi/loop/support/ParallelToolLoop$ParallelToolResult;", "toolCall", "Lcom/embabel/chat/ToolCall;", "<init>", "(Lcom/embabel/chat/ToolCall;)V", "getToolCall", "()Lcom/embabel/chat/ToolCall;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "embabel-agent-api"})
        public static final class Timeout
        extends ParallelToolResult {
            @NotNull
            private final ToolCall toolCall;

            public Timeout(@NotNull ToolCall toolCall) {
                Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
                super(null);
                this.toolCall = toolCall;
            }

            @Override
            @NotNull
            public ToolCall getToolCall() {
                return this.toolCall;
            }

            @NotNull
            public final ToolCall component1() {
                return this.toolCall;
            }

            @NotNull
            public final Timeout copy(@NotNull ToolCall toolCall) {
                Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
                return new Timeout(toolCall);
            }

            public static /* synthetic */ Timeout copy$default(Timeout timeout, ToolCall toolCall, int n, Object object) {
                if ((n & 1) != 0) {
                    toolCall = timeout.toolCall;
                }
                return timeout.copy(toolCall);
            }

            @NotNull
            public String toString() {
                return "Timeout(toolCall=" + this.toolCall + ")";
            }

            public int hashCode() {
                return this.toolCall.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Timeout)) {
                    return false;
                }
                Timeout timeout = (Timeout)other;
                return Intrinsics.areEqual((Object)this.toolCall, (Object)timeout.toolCall);
            }
        }
    }
}

