/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool;

import com.embabel.agent.api.annotation.support.AgenticInfo;
import com.embabel.agent.api.channel.OutputChannel;
import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.api.common.autonomy.Autonomy;
import com.embabel.agent.api.common.autonomy.ProcessWaitingException;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.TypeBasedInputSchema;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.core.Verbosity;
import com.embabel.agent.tools.agent.PromptedTextCommunicator;
import com.embabel.agent.tools.agent.TextCommunicator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0003%&'B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/embabel/agent/api/tool/Subagent;", "Lcom/embabel/agent/api/tool/Tool;", "agentRef", "Lcom/embabel/agent/api/tool/Subagent$AgentRef;", "textCommunicator", "Lcom/embabel/agent/tools/agent/TextCommunicator;", "<init>", "(Lcom/embabel/agent/api/tool/Subagent$AgentRef;Lcom/embabel/agent/tools/agent/TextCommunicator;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "definition$delegate", "Lkotlin/Lazy;", "createDefinition", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "", "resolveAgent", "Lcom/embabel/agent/core/Agent;", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "resolveAgent$embabel_agent_api", "createProcessOptions", "Lcom/embabel/agent/core/ProcessOptions;", "parentAgentProcess", "Lcom/embabel/agent/core/AgentProcess;", "toString", "AgentRef", "Builder", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nSubagent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Subagent.kt\ncom/embabel/agent/api/tool/Subagent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,387:1\n1#2:388\n1557#3:389\n1628#3,3:390\n1557#3:393\n1628#3,3:394\n1557#3:397\n1628#3,3:398\n*S KotlinDebug\n*F\n+ 1 Subagent.kt\ncom/embabel/agent/api/tool/Subagent\n*L\n207#1:389\n207#1:390,3\n220#1:393\n220#1:394,3\n233#1:397\n233#1:398,3\n*E\n"})
public final class Subagent
implements Tool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AgentRef agentRef;
    @NotNull
    private final TextCommunicator textCommunicator;
    private final Logger logger;
    @NotNull
    private final Lazy definition$delegate;
    @NotNull
    private final Tool.Metadata metadata;

    private Subagent(AgentRef agentRef, TextCommunicator textCommunicator) {
        this.agentRef = agentRef;
        this.textCommunicator = textCommunicator;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.definition$delegate = LazyKt.lazy(() -> Subagent.definition_delegate$lambda$0(this));
        this.metadata = Tool.Metadata.DEFAULT;
    }

    /* synthetic */ Subagent(AgentRef agentRef, TextCommunicator textCommunicator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textCommunicator = PromptedTextCommunicator.INSTANCE;
        }
        this(agentRef, textCommunicator);
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        Lazy lazy = this.definition$delegate;
        return (Tool.Definition)lazy.getValue();
    }

    private final Tool.Definition createDefinition() {
        Tool.Definition definition2;
        AgentRef ref = this.agentRef;
        if (ref instanceof AgentRef.FromAgent) {
            definition2 = new Tool.Definition(ref){
                private final String name;
                private final String description;
                private final Tool.InputSchema inputSchema;
                {
                    this.name = ((AgentRef.FromAgent)$ref).getAgent().getName();
                    this.description = ((AgentRef.FromAgent)$ref).getAgent().getDescription();
                    this.inputSchema = TypeBasedInputSchema.Companion.of(((AgentRef.FromAgent)$ref).getInputClass());
                }

                public String getName() {
                    return this.name;
                }

                public String getDescription() {
                    return this.description;
                }

                public Tool.InputSchema getInputSchema() {
                    return this.inputSchema;
                }
            };
        } else if (ref instanceof AgentRef.FromClass) {
            AgenticInfo agenticInfo = new AgenticInfo(((AgentRef.FromClass)ref).getClazz());
            definition2 = new Tool.Definition(agenticInfo, ref){
                private final String name;
                private final String description;
                private final Tool.InputSchema inputSchema;
                {
                    this.name = $agenticInfo.agentName();
                    Object object = $agenticInfo.getAgentAnnotation();
                    if (object == null || (object = object.description()) == null) {
                        object = "";
                    }
                    this.description = object;
                    this.inputSchema = TypeBasedInputSchema.Companion.of(((AgentRef.FromClass)$ref).getInputClass());
                }

                public String getName() {
                    return this.name;
                }

                public String getDescription() {
                    return this.description;
                }

                public Tool.InputSchema getInputSchema() {
                    return this.inputSchema;
                }
            };
        } else if (ref instanceof AgentRef.FromAnnotatedInstance) {
            AgenticInfo agenticInfo = new AgenticInfo(((AgentRef.FromAnnotatedInstance)ref).getInstance().getClass());
            definition2 = new Tool.Definition(agenticInfo, ref){
                private final String name;
                private final String description;
                private final Tool.InputSchema inputSchema;
                {
                    this.name = $agenticInfo.agentName();
                    Object object = $agenticInfo.getAgentAnnotation();
                    if (object == null || (object = object.description()) == null) {
                        object = "";
                    }
                    this.description = object;
                    this.inputSchema = TypeBasedInputSchema.Companion.of(((AgentRef.FromAnnotatedInstance)$ref).getInputClass());
                }

                public String getName() {
                    return this.name;
                }

                public String getDescription() {
                    return this.description;
                }

                public Tool.InputSchema getInputSchema() {
                    return this.inputSchema;
                }
            };
        } else if (ref instanceof AgentRef.FromName) {
            definition2 = new Tool.Definition(ref){
                private final String name;
                private final String description;
                private final Tool.InputSchema inputSchema;
                {
                    this.name = ((AgentRef.FromName)$ref).getName();
                    this.description = "Delegate to agent '" + ((AgentRef.FromName)$ref).getName() + "'";
                    this.inputSchema = TypeBasedInputSchema.Companion.of(((AgentRef.FromName)$ref).getInputClass());
                }

                public String getName() {
                    return this.name;
                }

                public String getDescription() {
                    return this.description;
                }

                public Tool.InputSchema getInputSchema() {
                    return this.inputSchema;
                }
            };
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return definition2;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Tool.Result result;
        Object o;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        AgentProcess agentProcess = AgentProcess.Companion.get();
        if (agentProcess == null) {
            throw new IllegalStateException("No parent agent process found. Subagent must be called within an agent context.");
        }
        AgentProcess parentAgentProcess = agentProcess;
        AgentPlatform agentPlatform = parentAgentProcess.getProcessContext().getPlatformServices$embabel_agent_api().getAgentPlatform();
        Agent agent = this.resolveAgent$embabel_agent_api(agentPlatform);
        Class<?> inputType = this.agentRef.getInputClass();
        this.logger.info("Subagent {} invoked with input: {}", (Object)agent.getName(), (Object)input);
        ObjectMapper objectMapper = parentAgentProcess.getProcessContext().getPlatformServices$embabel_agent_api().getObjectMapper();
        try {
            o = objectMapper.readValue(input, inputType);
            this.logger.info("Parsed subagent input to {}: {}", (Object)inputType.getSimpleName(), o);
        }
        catch (Exception e) {
            String errorMessage = "Error parsing subagent input: " + e.getMessage();
            this.logger.warn(errorMessage, (Throwable)e);
            return Tool.Result.Companion.error(errorMessage, e);
        }
        Object inputObject = o;
        ProcessOptions processOptions = this.createProcessOptions(parentAgentProcess);
        Autonomy autonomy = parentAgentProcess.getProcessContext().getPlatformServices$embabel_agent_api().autonomy();
        try {
            Intrinsics.checkNotNull((Object)inputObject);
            AgentProcessExecution execution = autonomy.runAgent(inputObject, processOptions, agent);
            this.logger.info("Subagent {} completed: {}", (Object)agent.getName(), (Object)execution);
            result = Tool.Result.Companion.withArtifact(this.textCommunicator.communicateResult(execution), execution.getOutput());
        }
        catch (ProcessWaitingException pwe) {
            String response = this.textCommunicator.communicateAwaitable(agent, pwe);
            this.logger.info("Subagent {} awaiting: {}", (Object)agent.getName(), (Object)response);
            result = Tool.Result.Companion.text(response);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Agent resolveAgent$embabel_agent_api(@NotNull AgentPlatform agentPlatform) {
        Agent agent;
        Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
        AgentRef ref = this.agentRef;
        if (ref instanceof AgentRef.FromAgent) {
            agent = ((AgentRef.FromAgent)ref).getAgent();
        } else if (ref instanceof AgentRef.FromName) {
            Object v1;
            block19: {
                Iterable iterable = agentPlatform.agents();
                for (Object t : iterable) {
                    Agent it = (Agent)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)((AgentRef.FromName)ref).getName())) continue;
                    v1 = t;
                    break block19;
                }
                v1 = null;
            }
            if ((agent = (Agent)v1) == null) {
                Collection<String> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                Iterable iterable = agentPlatform.agents();
                String string = agentPlatform.getName();
                String string2 = ((AgentRef.FromName)ref).getName();
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Agent agent2 = (Agent)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                collection = (List)destination$iv$iv;
                String string3 = "Subagent '" + string2 + "' not found in platform " + string + ". Available agents: " + (List)collection;
                throw new IllegalArgumentException(string3);
            }
        } else if (ref instanceof AgentRef.FromClass) {
            Object v2;
            String agentName;
            block20: {
                AgenticInfo agenticInfo = new AgenticInfo(((AgentRef.FromClass)ref).getClazz());
                if (!agenticInfo.agentic()) {
                    boolean $i$a$-require-Subagent$resolveAgent$42 = false;
                    String $i$a$-require-Subagent$resolveAgent$42 = "Class " + ((AgentRef.FromClass)ref).getClazz().getName() + " must be annotated with @Agent";
                    throw new IllegalArgumentException($i$a$-require-Subagent$resolveAgent$42.toString());
                }
                agentName = agenticInfo.agentName();
                Iterable destination$iv$iv = agentPlatform.agents();
                for (Object bl : destination$iv$iv) {
                    Agent it = (Agent)bl;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)agentName)) continue;
                    v2 = bl;
                    break block20;
                }
                v2 = null;
            }
            if ((agent = (Agent)v2) == null) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable $this$mapTo$iv$iv2 = agentPlatform.agents();
                String string = agentPlatform.getName();
                String string4 = ((AgentRef.FromClass)ref).getClazz().getSimpleName();
                String string5 = agentName;
                boolean $i$f$map = false;
                Iterator $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Agent agent3 = (Agent)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                collection = (List)destination$iv$iv;
                String string6 = "Subagent '" + string5 + "' (from class " + string4 + ") not found in platform " + string + ". Available agents: " + (List)collection;
                throw new IllegalArgumentException(string6);
            }
        } else if (ref instanceof AgentRef.FromAnnotatedInstance) {
            Object v3;
            String agentName;
            block21: {
                AgenticInfo agenticInfo = new AgenticInfo(((AgentRef.FromAnnotatedInstance)ref).getInstance().getClass());
                if (!agenticInfo.agentic()) {
                    boolean bl = false;
                    String string = "Instance of " + ((AgentRef.FromAnnotatedInstance)ref).getInstance().getClass().getName() + " must be annotated with @Agent";
                    throw new IllegalArgumentException(string.toString());
                }
                agentName = agenticInfo.agentName();
                Iterable $i$f$map = agentPlatform.agents();
                for (Object destination$iv$iv : $i$f$map) {
                    Agent it = (Agent)destination$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)agentName)) continue;
                    v3 = destination$iv$iv;
                    break block21;
                }
                v3 = null;
            }
            if ((agent = (Agent)v3) == null) {
                Collection<Object> collection;
                Object destination$iv$iv;
                Iterable $this$map$iv = agentPlatform.agents();
                String string = agentPlatform.getName();
                String string7 = ((AgentRef.FromAnnotatedInstance)ref).getInstance().getClass().getSimpleName();
                String string8 = agentName;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv = iterator.next();
                    Agent it = (Agent)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                collection = (List)destination$iv$iv;
                String string9 = "Subagent '" + string8 + "' (from instance of " + string7 + ") not found in platform " + string + ". Available agents: " + (List)collection;
                throw new IllegalArgumentException(string9);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return agent;
    }

    private final ProcessOptions createProcessOptions(AgentProcess parentAgentProcess) {
        Blackboard blackboard = parentAgentProcess.getProcessContext().getBlackboard().spawn();
        OutputChannel parentOutputChannel = parentAgentProcess.getProcessContext().getOutputChannel();
        this.logger.info("Creating subagent process with spawned blackboard from parent {}", (Object)parentAgentProcess.getId());
        Verbosity verbosity = new Verbosity(true, false, false, false, 14, null);
        return new ProcessOptions(null, null, blackboard, verbosity, null, null, false, null, parentOutputChannel, null, 755, null);
    }

    @NotNull
    public String toString() {
        String string;
        AgentRef ref = this.agentRef;
        if (ref instanceof AgentRef.FromAgent) {
            string = "Subagent(agent=" + ((AgentRef.FromAgent)ref).getAgent().getName() + ")";
        } else if (ref instanceof AgentRef.FromName) {
            string = "Subagent(name=" + ((AgentRef.FromName)ref).getName() + ")";
        } else if (ref instanceof AgentRef.FromClass) {
            string = "Subagent(class=" + ((AgentRef.FromClass)ref).getClazz().getSimpleName() + ")";
        } else if (ref instanceof AgentRef.FromAnnotatedInstance) {
            string = "Subagent(instance=" + ((AgentRef.FromAnnotatedInstance)ref).getInstance().getClass().getSimpleName() + ")";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final Tool.Definition definition_delegate$lambda$0(Subagent this$0) {
        return this$0.createDefinition();
    }

    @JvmStatic
    @NotNull
    public static final Builder ofClass(@NotNull Class<?> agentClass) {
        return Companion.ofClass(agentClass);
    }

    @JvmStatic
    @NotNull
    public static final Builder byName(@NotNull String name) {
        return Companion.byName(name);
    }

    @JvmStatic
    @NotNull
    public static final Builder ofInstance(@NotNull Agent agent) {
        return Companion.ofInstance(agent);
    }

    @JvmStatic
    @NotNull
    public static final Builder ofAnnotatedInstance(@NotNull Object annotatedInstance) {
        return Companion.ofAnnotatedInstance(annotatedInstance);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0004\u0006\u0007\b\tR\u0016\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0004\n\u000b\f\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/api/tool/Subagent$AgentRef;", "", "inputClass", "Ljava/lang/Class;", "getInputClass", "()Ljava/lang/Class;", "FromAgent", "FromName", "FromClass", "FromAnnotatedInstance", "Lcom/embabel/agent/api/tool/Subagent$AgentRef$FromAgent;", "Lcom/embabel/agent/api/tool/Subagent$AgentRef$FromAnnotatedInstance;", "Lcom/embabel/agent/api/tool/Subagent$AgentRef$FromClass;", "Lcom/embabel/agent/api/tool/Subagent$AgentRef$FromName;", "embabel-agent-api"})
    private static sealed interface AgentRef {
        @NotNull
        public Class<?> getInputClass();

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/embabel/agent/api/tool/Subagent$AgentRef$FromAgent;", "Lcom/embabel/agent/api/tool/Subagent$AgentRef;", "agent", "Lcom/embabel/agent/core/Agent;", "inputClass", "Ljava/lang/Class;", "<init>", "(Lcom/embabel/agent/core/Agent;Ljava/lang/Class;)V", "getAgent", "()Lcom/embabel/agent/core/Agent;", "getInputClass", "()Ljava/lang/Class;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "embabel-agent-api"})
        public static final class FromAgent
        implements AgentRef {
            @NotNull
            private final Agent agent;
            @NotNull
            private final Class<?> inputClass;

            public FromAgent(@NotNull Agent agent, @NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                this.agent = agent;
                this.inputClass = inputClass;
            }

            @NotNull
            public final Agent getAgent() {
                return this.agent;
            }

            @Override
            @NotNull
            public Class<?> getInputClass() {
                return this.inputClass;
            }

            @NotNull
            public final Agent component1() {
                return this.agent;
            }

            @NotNull
            public final Class<?> component2() {
                return this.inputClass;
            }

            @NotNull
            public final FromAgent copy(@NotNull Agent agent, @NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                return new FromAgent(agent, inputClass);
            }

            public static /* synthetic */ FromAgent copy$default(FromAgent fromAgent, Agent agent, Class clazz, int n, Object object) {
                if ((n & 1) != 0) {
                    agent = fromAgent.agent;
                }
                if ((n & 2) != 0) {
                    clazz = fromAgent.inputClass;
                }
                return fromAgent.copy(agent, clazz);
            }

            @NotNull
            public String toString() {
                return "FromAgent(agent=" + this.agent + ", inputClass=" + this.inputClass + ")";
            }

            public int hashCode() {
                int result = this.agent.hashCode();
                result = result * 31 + this.inputClass.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FromAgent)) {
                    return false;
                }
                FromAgent fromAgent = (FromAgent)other;
                if (!Intrinsics.areEqual((Object)this.agent, (Object)fromAgent.agent)) {
                    return false;
                }
                return Intrinsics.areEqual(this.inputClass, fromAgent.inputClass);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/api/tool/Subagent$AgentRef$FromAnnotatedInstance;", "Lcom/embabel/agent/api/tool/Subagent$AgentRef;", "instance", "", "inputClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Object;Ljava/lang/Class;)V", "getInstance", "()Ljava/lang/Object;", "getInputClass", "()Ljava/lang/Class;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "embabel-agent-api"})
        public static final class FromAnnotatedInstance
        implements AgentRef {
            @NotNull
            private final Object instance;
            @NotNull
            private final Class<?> inputClass;

            public FromAnnotatedInstance(@NotNull Object instance, @NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                this.instance = instance;
                this.inputClass = inputClass;
            }

            @NotNull
            public final Object getInstance() {
                return this.instance;
            }

            @Override
            @NotNull
            public Class<?> getInputClass() {
                return this.inputClass;
            }

            @NotNull
            public final Object component1() {
                return this.instance;
            }

            @NotNull
            public final Class<?> component2() {
                return this.inputClass;
            }

            @NotNull
            public final FromAnnotatedInstance copy(@NotNull Object instance, @NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                return new FromAnnotatedInstance(instance, inputClass);
            }

            public static /* synthetic */ FromAnnotatedInstance copy$default(FromAnnotatedInstance fromAnnotatedInstance, Object object, Class clazz, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = fromAnnotatedInstance.instance;
                }
                if ((n & 2) != 0) {
                    clazz = fromAnnotatedInstance.inputClass;
                }
                return fromAnnotatedInstance.copy(object, clazz);
            }

            @NotNull
            public String toString() {
                return "FromAnnotatedInstance(instance=" + this.instance + ", inputClass=" + this.inputClass + ")";
            }

            public int hashCode() {
                int result = this.instance.hashCode();
                result = result * 31 + this.inputClass.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FromAnnotatedInstance)) {
                    return false;
                }
                FromAnnotatedInstance fromAnnotatedInstance = (FromAnnotatedInstance)other;
                if (!Intrinsics.areEqual((Object)this.instance, (Object)fromAnnotatedInstance.instance)) {
                    return false;
                }
                return Intrinsics.areEqual(this.inputClass, fromAnnotatedInstance.inputClass);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J%\u0010\f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/api/tool/Subagent$AgentRef$FromClass;", "Lcom/embabel/agent/api/tool/Subagent$AgentRef;", "clazz", "Ljava/lang/Class;", "inputClass", "<init>", "(Ljava/lang/Class;Ljava/lang/Class;)V", "getClazz", "()Ljava/lang/Class;", "getInputClass", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "embabel-agent-api"})
        public static final class FromClass
        implements AgentRef {
            @NotNull
            private final Class<?> clazz;
            @NotNull
            private final Class<?> inputClass;

            public FromClass(@NotNull Class<?> clazz, @NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                this.clazz = clazz;
                this.inputClass = inputClass;
            }

            @NotNull
            public final Class<?> getClazz() {
                return this.clazz;
            }

            @Override
            @NotNull
            public Class<?> getInputClass() {
                return this.inputClass;
            }

            @NotNull
            public final Class<?> component1() {
                return this.clazz;
            }

            @NotNull
            public final Class<?> component2() {
                return this.inputClass;
            }

            @NotNull
            public final FromClass copy(@NotNull Class<?> clazz, @NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                return new FromClass(clazz, inputClass);
            }

            public static /* synthetic */ FromClass copy$default(FromClass fromClass, Class clazz, Class clazz2, int n, Object object) {
                if ((n & 1) != 0) {
                    clazz = fromClass.clazz;
                }
                if ((n & 2) != 0) {
                    clazz2 = fromClass.inputClass;
                }
                return fromClass.copy(clazz, clazz2);
            }

            @NotNull
            public String toString() {
                return "FromClass(clazz=" + this.clazz + ", inputClass=" + this.inputClass + ")";
            }

            public int hashCode() {
                int result = this.clazz.hashCode();
                result = result * 31 + this.inputClass.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FromClass)) {
                    return false;
                }
                FromClass fromClass = (FromClass)other;
                if (!Intrinsics.areEqual(this.clazz, fromClass.clazz)) {
                    return false;
                }
                return Intrinsics.areEqual(this.inputClass, fromClass.inputClass);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/api/tool/Subagent$AgentRef$FromName;", "Lcom/embabel/agent/api/tool/Subagent$AgentRef;", "name", "", "inputClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;)V", "getName", "()Ljava/lang/String;", "getInputClass", "()Ljava/lang/Class;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "embabel-agent-api"})
        public static final class FromName
        implements AgentRef {
            @NotNull
            private final String name;
            @NotNull
            private final Class<?> inputClass;

            public FromName(@NotNull String name, @NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                this.name = name;
                this.inputClass = inputClass;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            @NotNull
            public Class<?> getInputClass() {
                return this.inputClass;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Class<?> component2() {
                return this.inputClass;
            }

            @NotNull
            public final FromName copy(@NotNull String name, @NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                return new FromName(name, inputClass);
            }

            public static /* synthetic */ FromName copy$default(FromName fromName, String string, Class clazz, int n, Object object) {
                if ((n & 1) != 0) {
                    string = fromName.name;
                }
                if ((n & 2) != 0) {
                    clazz = fromName.inputClass;
                }
                return fromName.copy(string, clazz);
            }

            @NotNull
            public String toString() {
                return "FromName(name=" + this.name + ", inputClass=" + this.inputClass + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + this.inputClass.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FromName)) {
                    return false;
                }
                FromName fromName = (FromName)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)fromName.name)) {
                    return false;
                }
                return Intrinsics.areEqual(this.inputClass, fromName.inputClass);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H&J\u0011\u0010\u0004\u001a\u00020\u0005\"\u0006\b\u0000\u0010\b\u0018\u0001H\u0086\bJ\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\t\u0082\u0001\u0004\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/api/tool/Subagent$Builder;", "", "<init>", "()V", "consuming", "Lcom/embabel/agent/api/tool/Subagent;", "inputClass", "Ljava/lang/Class;", "I", "Lkotlin/reflect/KClass;", "FromClassBuilder", "FromNameBuilder", "FromAgentBuilder", "FromAnnotatedInstanceBuilder", "Lcom/embabel/agent/api/tool/Subagent$Builder$FromAgentBuilder;", "Lcom/embabel/agent/api/tool/Subagent$Builder$FromAnnotatedInstanceBuilder;", "Lcom/embabel/agent/api/tool/Subagent$Builder$FromClassBuilder;", "Lcom/embabel/agent/api/tool/Subagent$Builder$FromNameBuilder;", "embabel-agent-api"})
    public static abstract sealed class Builder {
        private Builder() {
        }

        @NotNull
        public abstract Subagent consuming(@NotNull Class<?> var1);

        public final /* synthetic */ <I> Subagent consuming() {
            boolean $i$f$consuming = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"I");
            return this.consuming(Object.class);
        }

        @NotNull
        public final Subagent consuming(@NotNull KClass<?> inputClass) {
            Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
            return this.consuming(JvmClassMappingKt.getJavaClass(inputClass));
        }

        public /* synthetic */ Builder(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/embabel/agent/api/tool/Subagent$Builder$FromAgentBuilder;", "Lcom/embabel/agent/api/tool/Subagent$Builder;", "agent", "Lcom/embabel/agent/core/Agent;", "<init>", "(Lcom/embabel/agent/core/Agent;)V", "consuming", "Lcom/embabel/agent/api/tool/Subagent;", "inputClass", "Ljava/lang/Class;", "embabel-agent-api"})
        public static final class FromAgentBuilder
        extends Builder {
            @NotNull
            private final Agent agent;

            public FromAgentBuilder(@NotNull Agent agent) {
                Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
                super(null);
                this.agent = agent;
            }

            @Override
            @NotNull
            public Subagent consuming(@NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                return new Subagent(new AgentRef.FromAgent(this.agent, inputClass), null, 2, null);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/embabel/agent/api/tool/Subagent$Builder$FromAnnotatedInstanceBuilder;", "Lcom/embabel/agent/api/tool/Subagent$Builder;", "instance", "", "<init>", "(Ljava/lang/Object;)V", "consuming", "Lcom/embabel/agent/api/tool/Subagent;", "inputClass", "Ljava/lang/Class;", "embabel-agent-api"})
        public static final class FromAnnotatedInstanceBuilder
        extends Builder {
            @NotNull
            private final Object instance;

            public FromAnnotatedInstanceBuilder(@NotNull Object instance) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                super(null);
                this.instance = instance;
            }

            @Override
            @NotNull
            public Subagent consuming(@NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                return new Subagent(new AgentRef.FromAnnotatedInstance(this.instance, inputClass), null, 2, null);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/embabel/agent/api/tool/Subagent$Builder$FromClassBuilder;", "Lcom/embabel/agent/api/tool/Subagent$Builder;", "agentClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "consuming", "Lcom/embabel/agent/api/tool/Subagent;", "inputClass", "embabel-agent-api"})
        public static final class FromClassBuilder
        extends Builder {
            @NotNull
            private final Class<?> agentClass;

            public FromClassBuilder(@NotNull Class<?> agentClass) {
                Intrinsics.checkNotNullParameter(agentClass, (String)"agentClass");
                super(null);
                this.agentClass = agentClass;
            }

            @Override
            @NotNull
            public Subagent consuming(@NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                return new Subagent(new AgentRef.FromClass(this.agentClass, inputClass), null, 2, null);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/embabel/agent/api/tool/Subagent$Builder$FromNameBuilder;", "Lcom/embabel/agent/api/tool/Subagent$Builder;", "name", "", "<init>", "(Ljava/lang/String;)V", "consuming", "Lcom/embabel/agent/api/tool/Subagent;", "inputClass", "Ljava/lang/Class;", "embabel-agent-api"})
        public static final class FromNameBuilder
        extends Builder {
            @NotNull
            private final String name;

            public FromNameBuilder(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(null);
                this.name = name;
            }

            @Override
            @NotNull
            public Subagent consuming(@NotNull Class<?> inputClass) {
                Intrinsics.checkNotNullParameter(inputClass, (String)"inputClass");
                return new Subagent(new AgentRef.FromName(this.name, inputClass), null, 2, null);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007J\u0011\u0010\u0004\u001a\u00020\u0005\"\u0006\b\u0000\u0010\b\u0018\u0001H\u0086\bJ\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0001H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/api/tool/Subagent$Companion;", "", "<init>", "()V", "ofClass", "Lcom/embabel/agent/api/tool/Subagent$Builder;", "agentClass", "Ljava/lang/Class;", "T", "Lkotlin/reflect/KClass;", "byName", "name", "", "ofInstance", "agent", "Lcom/embabel/agent/core/Agent;", "ofAnnotatedInstance", "annotatedInstance", "embabel-agent-api"})
    @SourceDebugExtension(value={"SMAP\nSubagent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Subagent.kt\ncom/embabel/agent/api/tool/Subagent$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1#2:388\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder ofClass(@NotNull Class<?> agentClass) {
            Intrinsics.checkNotNullParameter(agentClass, (String)"agentClass");
            AgenticInfo agenticInfo = new AgenticInfo(agentClass);
            if (!agenticInfo.agentic()) {
                boolean bl = false;
                String string = "Class " + agentClass.getName() + " must be annotated with @Agent";
                throw new IllegalArgumentException(string.toString());
            }
            return new Builder.FromClassBuilder(agentClass);
        }

        public final /* synthetic */ <T> Builder ofClass() {
            boolean $i$f$ofClass = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this.ofClass(Object.class);
        }

        @NotNull
        public final Builder ofClass(@NotNull KClass<?> agentClass) {
            Intrinsics.checkNotNullParameter(agentClass, (String)"agentClass");
            return this.ofClass(JvmClassMappingKt.getJavaClass(agentClass));
        }

        @JvmStatic
        @NotNull
        public final Builder byName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (!(!StringsKt.isBlank((CharSequence)name))) {
                boolean bl = false;
                String string = "Agent name must not be blank";
                throw new IllegalArgumentException(string.toString());
            }
            return new Builder.FromNameBuilder(name);
        }

        @JvmStatic
        @NotNull
        public final Builder ofInstance(@NotNull Agent agent) {
            Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
            return new Builder.FromAgentBuilder(agent);
        }

        @JvmStatic
        @NotNull
        public final Builder ofAnnotatedInstance(@NotNull Object annotatedInstance) {
            Intrinsics.checkNotNullParameter((Object)annotatedInstance, (String)"annotatedInstance");
            AgenticInfo agenticInfo = new AgenticInfo(annotatedInstance.getClass());
            if (!agenticInfo.agentic()) {
                boolean bl = false;
                String string = "Instance of " + annotatedInstance.getClass().getName() + " must be annotated with @Agent";
                throw new IllegalArgumentException(string.toString());
            }
            return new Builder.FromAnnotatedInstanceBuilder(annotatedInstance);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

