/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.support.streaming;

import com.embabel.agent.api.common.InteractionId;
import com.embabel.agent.core.internal.LlmOperations;
import com.embabel.agent.core.support.LlmInteraction;
import com.embabel.agent.spi.LlmService;
import com.embabel.agent.spi.support.springai.ChatClientLlmOperations;
import com.embabel.agent.spi.support.springai.SpringAiLlmService;
import com.embabel.common.ai.model.LlmOptions;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.Prompt;
import reactor.core.publisher.Flux;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/api/common/support/streaming/StreamingCapabilityDetector;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "capabilityCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "", "CACHE_MISS_LOG_MESSAGE", "", "TEST_PROMPT_MESSAGE", "supportsStreaming", "model", "Lorg/springframework/ai/chat/model/ChatModel;", "llmOperations", "Lcom/embabel/agent/core/internal/LlmOperations;", "llmOptions", "Lcom/embabel/common/ai/model/LlmOptions;", "testStreamingCapability", "canConsumeStream", "stream", "Lreactor/core/publisher/Flux;", "Lorg/springframework/ai/chat/model/ChatResponse;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nStreamingCapabilityDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingCapabilityDetector.kt\ncom/embabel/agent/api/common/support/streaming/StreamingCapabilityDetector\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,120:1\n27#2:121\n*S KotlinDebug\n*F\n+ 1 StreamingCapabilityDetector.kt\ncom/embabel/agent/api/common/support/streaming/StreamingCapabilityDetector\n*L\n45#1:121\n*E\n"})
public final class StreamingCapabilityDetector {
    @NotNull
    public static final StreamingCapabilityDetector INSTANCE = new StreamingCapabilityDetector();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ConcurrentHashMap<Class<?>, Boolean> capabilityCache;
    @NotNull
    private static final String CACHE_MISS_LOG_MESSAGE = "Cache miss for {}, testing streaming capability...";
    @NotNull
    private static final String TEST_PROMPT_MESSAGE = "Say 'test' to confirm streaming works";

    private StreamingCapabilityDetector() {
    }

    public final boolean supportsStreaming(@NotNull ChatModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Boolean bl = capabilityCache.computeIfAbsent(model.getClass(), arg_0 -> StreamingCapabilityDetector.supportsStreaming$lambda$1(arg_0 -> StreamingCapabilityDetector.supportsStreaming$lambda$0(model, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    public final boolean supportsStreaming(@NotNull LlmOperations llmOperations, @NotNull LlmOptions llmOptions) {
        Intrinsics.checkNotNullParameter((Object)llmOperations, (String)"llmOperations");
        Intrinsics.checkNotNullParameter((Object)llmOptions, (String)"llmOptions");
        if (!(llmOperations instanceof ChatClientLlmOperations)) {
            return false;
        }
        LlmService<?> llm = ((ChatClientLlmOperations)llmOperations).getLlm$embabel_agent_api(new LlmInteraction(InteractionId.constructor-impl("capability-check"), llmOptions, null, null, null, null, null, null, false, false, 0, null, null, 8188, null));
        SpringAiLlmService springAiLlmService = llm instanceof SpringAiLlmService ? (SpringAiLlmService)llm : null;
        if (springAiLlmService == null) {
            return false;
        }
        SpringAiLlmService springAiLlm = springAiLlmService;
        return this.supportsStreaming(springAiLlm.getChatModel());
    }

    private final boolean testStreamingCapability(ChatModel model) {
        boolean bl;
        try {
            Prompt testRequest = new Prompt(CollectionsKt.listOf((Object)new UserMessage(TEST_PROMPT_MESSAGE)));
            Flux flux = model.stream(testRequest);
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"stream(...)");
            Flux stream = flux;
            this.canConsumeStream((Flux<ChatResponse>)stream);
            bl = true;
        }
        catch (UnsupportedOperationException e) {
            bl = false;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final boolean canConsumeStream(Flux<ChatResponse> stream) {
        boolean bl;
        try {
            stream.hasElements().timeout(Duration.ofMillis(100L)).block();
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private static final Boolean supportsStreaming$lambda$0(ChatModel $model, Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        logger.debug(CACHE_MISS_LOG_MESSAGE, (Object)$model.getClass().getSimpleName());
        return INSTANCE.testStreamingCapability($model);
    }

    private static final Boolean supportsStreaming$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(StreamingCapabilityDetector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        StreamingCapabilityDetector.logger = logger;
        capabilityCache = new ConcurrentHashMap();
    }
}

