/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.ranking;

import com.embabel.common.core.types.Described;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.core.types.Named;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.util.FormatUtilsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u001b\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0019\u001a\u00060\bj\u0002`\tH\u00c6\u0003J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00002\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0016H\u00d6\u0001J\t\u0010 \u001a\u00020\u0012H\u00d6\u0001R\u0016\u0010\u0006\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0018\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/embabel/agent/api/common/ranking/Ranking;", "T", "Lcom/embabel/common/core/types/Named;", "Lcom/embabel/common/core/types/Described;", "Lcom/embabel/common/core/types/HasInfoString;", "Lcom/embabel/common/core/types/SimilarityResult;", "match", "score", "", "Lcom/embabel/common/core/types/ZeroToOne;", "<init>", "(Lcom/embabel/common/core/types/Named;D)V", "getMatch", "()Lcom/embabel/common/core/types/Named;", "Lcom/embabel/common/core/types/Named;", "getScore", "()D", "infoString", "", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "component1", "component2", "copy", "(Lcom/embabel/common/core/types/Named;D)Lcom/embabel/agent/api/common/ranking/Ranking;", "equals", "other", "", "hashCode", "toString", "embabel-agent-api"})
public final class Ranking<T extends Named & Described>
implements HasInfoString,
SimilarityResult<T> {
    @NotNull
    private final T match;
    private final double score;

    public Ranking(@NotNull T match, double score) {
        Intrinsics.checkNotNullParameter(match, (String)"match");
        this.match = match;
        this.score = score;
    }

    @NotNull
    public T getMatch() {
        return this.match;
    }

    public double getScore() {
        return this.score;
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        String string = this.getMatch().getName();
        String string2 = "%.2f";
        Object[] objectArray = new Object[]{this.getScore()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String s = string + ": " + string3;
        if (Intrinsics.areEqual((Object)verbose, (Object)true)) {
            s = s + " - " + ((Described)this.getMatch()).getDescription();
        }
        return Intrinsics.areEqual((Object)verbose, (Object)true) ? FormatUtilsKt.indent$default((String)s, (int)indent, null, (int)2, null) : s;
    }

    @NotNull
    public final T component1() {
        return this.match;
    }

    public final double component2() {
        return this.score;
    }

    @NotNull
    public final Ranking<T> copy(@NotNull T match, double score) {
        Intrinsics.checkNotNullParameter(match, (String)"match");
        return new Ranking<T>(match, score);
    }

    public static /* synthetic */ Ranking copy$default(Ranking ranking, Named object, double d, int n, Object object2) {
        if ((n & 1) != 0) {
            object = ranking.match;
        }
        if ((n & 2) != 0) {
            d = ranking.score;
        }
        return ranking.copy(object, d);
    }

    @NotNull
    public String toString() {
        return "Ranking(match=" + this.match + ", score=" + this.score + ")";
    }

    public int hashCode() {
        int result = this.match.hashCode();
        result = result * 31 + Double.hashCode(this.score);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ranking)) {
            return false;
        }
        Ranking ranking = (Ranking)other;
        if (!Intrinsics.areEqual(this.match, ranking.match)) {
            return false;
        }
        return Double.compare(this.score, ranking.score) == 0;
    }
}

