/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/api/common/AgentImage;", "", "mimeType", "", "data", "", "<init>", "(Ljava/lang/String;[B)V", "getMimeType", "()Ljava/lang/String;", "getData", "()[B", "equals", "", "other", "hashCode", "", "component1", "component2", "copy", "toString", "Companion", "embabel-agent-api"})
public final class AgentImage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mimeType;
    @NotNull
    private final byte[] data;

    public AgentImage(@NotNull String mimeType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.mimeType = mimeType;
        this.data = data;
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AgentImage)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mimeType, (Object)((AgentImage)other).mimeType) && Arrays.equals(this.data, ((AgentImage)other).data);
    }

    public int hashCode() {
        return this.mimeType.hashCode() * 31 + Arrays.hashCode(this.data);
    }

    @NotNull
    public final String component1() {
        return this.mimeType;
    }

    @NotNull
    public final byte[] component2() {
        return this.data;
    }

    @NotNull
    public final AgentImage copy(@NotNull String mimeType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new AgentImage(mimeType, data);
    }

    public static /* synthetic */ AgentImage copy$default(AgentImage agentImage, String string, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = agentImage.mimeType;
        }
        if ((n & 2) != 0) {
            byArray = agentImage.data;
        }
        return agentImage.copy(string, byArray);
    }

    @NotNull
    public String toString() {
        return "AgentImage(mimeType=" + this.mimeType + ", data=" + Arrays.toString(this.data) + ")";
    }

    @JvmStatic
    @NotNull
    public static final AgentImage fromFile(@NotNull File file) {
        return Companion.fromFile(file);
    }

    @JvmStatic
    @NotNull
    public static final AgentImage fromPath(@NotNull Path path) {
        return Companion.fromPath(path);
    }

    @JvmStatic
    @NotNull
    public static final AgentImage create(@NotNull String mimeType, @NotNull byte[] data) {
        return Companion.create(mimeType, data);
    }

    @JvmStatic
    @NotNull
    public static final AgentImage fromBytes(@NotNull String filename, @NotNull byte[] data) {
        return Companion.fromBytes(filename, data);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/api/common/AgentImage$Companion;", "", "<init>", "()V", "fromFile", "Lcom/embabel/agent/api/common/AgentImage;", "file", "Ljava/io/File;", "fromPath", "path", "Ljava/nio/file/Path;", "create", "mimeType", "", "data", "", "fromBytes", "filename", "detectMimeType", "extension", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AgentImage fromFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String mimeType = this.detectMimeType(FilesKt.getExtension((File)file));
            return new AgentImage(mimeType, FilesKt.readBytes((File)file));
        }

        @JvmStatic
        @NotNull
        public final AgentImage fromPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return this.fromFile(file);
        }

        @JvmStatic
        @NotNull
        public final AgentImage create(@NotNull String mimeType, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new AgentImage(mimeType, data);
        }

        @JvmStatic
        @NotNull
        public final AgentImage fromBytes(@NotNull String filename, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String extension = StringsKt.substringAfterLast((String)filename, (char)'.', (String)"");
            String mimeType = this.detectMimeType(extension);
            return new AgentImage(mimeType, data);
        }

        private final String detectMimeType(String extension) {
            String string = extension.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return switch (string) {
                case "jpg", "jpeg" -> "image/jpeg";
                case "png" -> "image/png";
                case "gif" -> "image/gif";
                case "webp" -> "image/webp";
                case "bmp" -> "image/bmp";
                default -> throw new IllegalArgumentException("Unknown image format: ." + extension + ". Supported formats: jpg, jpeg, png, gif, webp, bmp. For other formats, use AgentImage.create(mimeType, data) with an explicit MIME type.");
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

