/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.annotation.support;

import com.embabel.agent.api.annotation.Action;
import com.embabel.agent.api.annotation.State;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0000\u001a(\u0010\n\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0012"}, d2={"findTriggerType", "Ljava/lang/Class;", "method", "Ljava/lang/reflect/Method;", "triggerPrecondition", "", "triggerType", "isStateType", "", "clazz", "isStateTypeRecursive", "visited", "", "computeClearBlackboard", "actionAnnotation", "Lcom/embabel/agent/api/annotation/Action;", "computeTriggerPreconditions", "", "embabel-agent-api"})
public final class ActionMethodManagerKt {
    @Nullable
    public static final Class<?> findTriggerType(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Action actionAnnotation = method.getAnnotation(Action.class);
        if (actionAnnotation != null && !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(actionAnnotation.trigger()), (Object)Reflection.getOrCreateKotlinClass(Unit.class))) {
            return actionAnnotation.trigger();
        }
        return null;
    }

    @NotNull
    public static final String triggerPrecondition(@NotNull Class<?> triggerType) {
        Intrinsics.checkNotNullParameter(triggerType, (String)"triggerType");
        return "lastResult:" + triggerType.getName();
    }

    public static final boolean isStateType(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Set visited = new LinkedHashSet();
        return ActionMethodManagerKt.isStateTypeRecursive(clazz, visited);
    }

    private static final boolean isStateTypeRecursive(Class<?> clazz, Set<Class<?>> visited) {
        if (clazz == null || Intrinsics.areEqual(clazz, Object.class) || !visited.add(clazz)) {
            return false;
        }
        if (clazz.isAnnotationPresent(State.class)) {
            return true;
        }
        if (ActionMethodManagerKt.isStateTypeRecursive(clazz.getSuperclass(), visited)) {
            return true;
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])clazz.getInterfaces());
        while (iterator.hasNext()) {
            Class iface = (Class)iterator.next();
            if (!ActionMethodManagerKt.isStateTypeRecursive(iface, visited)) continue;
            return true;
        }
        return false;
    }

    public static final boolean computeClearBlackboard(@NotNull Method method, @NotNull Action actionAnnotation) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)actionAnnotation, (String)"actionAnnotation");
        return actionAnnotation.clearBlackboard();
    }

    @NotNull
    public static final List<String> computeTriggerPreconditions(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Class<?> triggerType = ActionMethodManagerKt.findTriggerType(method);
        return triggerType != null ? CollectionsKt.listOf((Object)ActionMethodManagerKt.triggerPrecondition(triggerType)) : CollectionsKt.emptyList();
    }
}

