/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.ux.form;

import com.embabel.ux.form.ControlValue;
import com.embabel.ux.form.FormBinder;
import com.embabel.ux.form.FormField;
import com.embabel.ux.form.FormSubmissionResult;
import com.embabel.ux.form.NoFormField;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.lang.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u001c\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00162\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/embabel/ux/form/JavaFormBinder;", "T", "", "Lcom/embabel/ux/form/FormBinder;", "javaClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "bind", "submissionResult", "Lcom/embabel/ux/form/FormSubmissionResult;", "(Lcom/embabel/ux/form/FormSubmissionResult;)Ljava/lang/Object;", "bindJavaRecord", "bindJavaConstructor", "convertToJavaType", "controlValue", "Lcom/embabel/ux/form/ControlValue;", "targetType", "convertJavaTextValue", "value", "", "convertJavaNumberValue", "", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nFormBinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormBinder.kt\ncom/embabel/ux/form/JavaFormBinder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,402:1\n13402#2,2:403\n6560#2:409\n13402#2,2:410\n37#3:405\n36#3,3:406\n37#3:412\n36#3,3:413\n37#3:416\n36#3,3:417\n*S KotlinDebug\n*F\n+ 1 FormBinder.kt\ncom/embabel/ux/form/JavaFormBinder\n*L\n113#1:403,2\n146#1:409\n154#1:410,2\n138#1:405\n138#1:406,3\n181#1:412\n181#1:413,3\n228#1:416\n228#1:417,3\n*E\n"})
public class JavaFormBinder<T>
implements FormBinder<T> {
    @NotNull
    private final Class<T> javaClass;

    public JavaFormBinder(@NotNull Class<T> javaClass) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        this.javaClass = javaClass;
    }

    @Override
    @NotNull
    public T bind(@NotNull FormSubmissionResult submissionResult) {
        Intrinsics.checkNotNullParameter((Object)submissionResult, (String)"submissionResult");
        if (!submissionResult.getValid()) {
            throw new FormBinder.ValidationException(submissionResult.getValidationErrors());
        }
        return this.javaClass.isRecord() ? this.bindJavaRecord(submissionResult) : this.bindJavaConstructor(submissionResult);
    }

    private final T bindJavaRecord(FormSubmissionResult submissionResult) {
        Object t;
        RecordComponent[] recordComponentArray = this.javaClass.getRecordComponents();
        if (recordComponentArray == null) {
            throw new FormBinder.FormBindingException("Failed to get record components for " + this.javaClass.getSimpleName());
        }
        RecordComponent[] recordComponents = recordComponentArray;
        List parameterValues = new ArrayList();
        RecordComponent[] $this$forEach$iv = recordComponents;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ControlValue controlValue;
            Object controlId;
            RecordComponent element$iv;
            RecordComponent component = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Field field = this.javaClass.getDeclaredField(component.getName());
            FormField formFieldAnnotation = field.getAnnotation(FormField.class);
            NoFormField noFormFieldAnnotation = field.getAnnotation(NoFormField.class);
            if (noFormFieldAnnotation != null) {
                throw new FormBinder.FormBindingException("Record component " + component.getName() + " is marked with @NoFormField but is required");
            }
            Object object = formFieldAnnotation;
            if (object == null || (object = object.controlId()) == null) {
                object = controlId = component.getName();
            }
            if (submissionResult.getValues().get(controlId) == null) {
                throw new FormBinder.FormBindingException("No value found for control id '" + (String)controlId + "' in form submission binding to Java record " + this.javaClass.getName() + ": formFieldAnnotation=" + formFieldAnnotation + ", noFormFieldAnnotation=" + noFormFieldAnnotation + ", component=" + component);
            }
            Class<?> clazz = component.getType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
            Object convertedValue = this.convertToJavaType(controlValue, clazz);
            parameterValues.add(convertedValue);
        }
        try {
            Constructor<?>[] constructorArray = this.javaClass.getDeclaredConstructors();
            Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getDeclaredConstructors(...)");
            Constructor constructor = (Constructor)ArraysKt.first((Object[])constructorArray);
            constructor.trySetAccessible();
            Collection $this$toTypedArray$iv = parameterValues;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            Object t2 = constructor.newInstance(Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type T of com.embabel.ux.form.JavaFormBinder");
            t = t2;
        }
        catch (Exception e) {
            throw new FormBinder.FormBindingException("Failed to construct Java record " + this.javaClass.getSimpleName() + ": " + e.getMessage());
        }
        return t;
    }

    private final T bindJavaConstructor(FormSubmissionResult submissionResult) {
        Constructor<?>[] constructorArray = this.javaClass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getDeclaredConstructors(...)");
        Object[] $this$sortedByDescending$iv = constructorArray;
        boolean $i$f$sortedByDescending = false;
        List constructors = ArraysKt.sortedWith((Object[])$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Constructor it = (Constructor)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getParameterCount());
                it = (Constructor)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getParameterCount()));
            }
        });
        for (Constructor constructor : constructors) {
            try {
                Parameter[] parameters = constructor.getParameters();
                List parameterValues = new ArrayList();
                boolean allParametersFound = false;
                allParametersFound = true;
                Intrinsics.checkNotNull((Object)parameters);
                Parameter[] $this$forEach$iv = parameters;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    ControlValue controlValue;
                    Object controlId;
                    Parameter element$iv;
                    Parameter parameter = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    FormField formFieldAnnotation = parameter.getAnnotation(FormField.class);
                    NoFormField noFormFieldAnnotation = parameter.getAnnotation(NoFormField.class);
                    if (noFormFieldAnnotation != null) {
                        throw new FormBinder.FormBindingException("Constructor parameter " + parameter.getName() + " is marked with @NoFormField but is required");
                    }
                    Object object = formFieldAnnotation;
                    if (object == null || (object = object.controlId()) == null) {
                        object = controlId = parameter.getName();
                    }
                    if ((controlValue = submissionResult.getValues().get(controlId)) == null) {
                        if (parameter.getType().isPrimitive() || !parameter.isAnnotationPresent(Nullable.class)) {
                            allParametersFound = false;
                            continue;
                        }
                        bl = parameterValues.add(null);
                        continue;
                    }
                    Class<?> clazz = parameter.getType();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
                    Object convertedValue = this.convertToJavaType(controlValue, clazz);
                    bl = parameterValues.add(convertedValue);
                }
                if (!allParametersFound) continue;
                constructor.setAccessible(true);
                Collection $this$toTypedArray$iv = parameterValues;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                Object t = constructor.newInstance(Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type T of com.embabel.ux.form.JavaFormBinder");
                return t;
            }
            catch (Exception exception) {
            }
        }
        throw new FormBinder.FormBindingException("No suitable constructor found for Java class " + this.javaClass.getSimpleName());
    }

    private final Object convertToJavaType(ControlValue controlValue, Class<?> targetType) {
        Object object;
        ControlValue controlValue2 = controlValue;
        if (controlValue2 instanceof ControlValue.TextValue) {
            object = this.convertJavaTextValue(((ControlValue.TextValue)controlValue).getValue(), targetType);
        } else if (controlValue2 instanceof ControlValue.BooleanValue) {
            Class<List> clazz = targetType;
            object = Intrinsics.areEqual(clazz, Boolean.TYPE) || Intrinsics.areEqual(clazz, Boolean.class) ? Boolean.valueOf(((ControlValue.BooleanValue)controlValue).getValue()) : (Intrinsics.areEqual(clazz, String.class) ? String.valueOf(((ControlValue.BooleanValue)controlValue).getValue()) : Boolean.valueOf(((ControlValue.BooleanValue)controlValue).getValue()));
        } else if (controlValue2 instanceof ControlValue.NumberValue) {
            object = this.convertJavaNumberValue(((ControlValue.NumberValue)controlValue).getValue(), targetType);
        } else if (controlValue2 instanceof ControlValue.DateValue) {
            Class<List> clazz = targetType;
            if (Intrinsics.areEqual(clazz, LocalDate.class)) {
                object = ((ControlValue.DateValue)controlValue).getValue();
            } else if (Intrinsics.areEqual(clazz, String.class)) {
                String string = ((ControlValue.DateValue)controlValue).getValue().toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            } else {
                object = ((ControlValue.DateValue)controlValue).getValue();
            }
        } else if (controlValue2 instanceof ControlValue.TimeValue) {
            Class<List> clazz = targetType;
            if (Intrinsics.areEqual(clazz, LocalTime.class)) {
                object = ((ControlValue.TimeValue)controlValue).getValue();
            } else if (Intrinsics.areEqual(clazz, String.class)) {
                String string = ((ControlValue.TimeValue)controlValue).getValue().toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            } else {
                object = ((ControlValue.TimeValue)controlValue).getValue();
            }
        } else if (controlValue2 instanceof ControlValue.OptionValue) {
            object = ((ControlValue.OptionValue)controlValue).getValue();
        } else if (controlValue2 instanceof ControlValue.MultiOptionValue) {
            if (targetType.isAssignableFrom(List.class)) {
                object = ((ControlValue.MultiOptionValue)controlValue).getValues();
            } else if (targetType.isArray()) {
                Collection $this$toTypedArray$iv = ((ControlValue.MultiOptionValue)controlValue).getValues();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                object = thisCollection$iv.toArray(new String[0]);
            } else {
                object = ((ControlValue.MultiOptionValue)controlValue).getValues();
            }
        } else if (controlValue2 instanceof ControlValue.FileValue) {
            object = ((ControlValue.FileValue)controlValue).getFileIds();
        } else if (controlValue2 instanceof ControlValue.EmptyValue) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final Object convertJavaTextValue(String value, Class<?> targetType) {
        Class<?> clazz = targetType;
        return Intrinsics.areEqual(clazz, String.class) ? value : (Intrinsics.areEqual(clazz, Integer.TYPE) || Intrinsics.areEqual(clazz, Integer.class) ? StringsKt.toIntOrNull((String)value) : (Intrinsics.areEqual(clazz, Long.TYPE) || Intrinsics.areEqual(clazz, Long.class) ? StringsKt.toLongOrNull((String)value) : (Intrinsics.areEqual(clazz, Double.TYPE) || Intrinsics.areEqual(clazz, Double.class) ? StringsKt.toDoubleOrNull((String)value) : (Intrinsics.areEqual(clazz, Float.TYPE) || Intrinsics.areEqual(clazz, Float.class) ? StringsKt.toFloatOrNull((String)value) : (Intrinsics.areEqual(clazz, Boolean.TYPE) || Intrinsics.areEqual(clazz, Boolean.class) ? Boolean.valueOf(Boolean.parseBoolean(value)) : (Intrinsics.areEqual(clazz, LocalDate.class) ? LocalDate.parse(value) : (Intrinsics.areEqual(clazz, LocalTime.class) ? LocalTime.parse(value) : value)))))));
    }

    private final Object convertJavaNumberValue(double value, Class<?> targetType) {
        Class<?> clazz = targetType;
        return Intrinsics.areEqual(clazz, Integer.TYPE) || Intrinsics.areEqual(clazz, Integer.class) ? Integer.valueOf((int)value) : (Intrinsics.areEqual(clazz, Long.TYPE) || Intrinsics.areEqual(clazz, Long.class) ? Long.valueOf((long)value) : (Intrinsics.areEqual(clazz, Float.TYPE) || Intrinsics.areEqual(clazz, Float.class) ? Float.valueOf((float)value) : (Intrinsics.areEqual(clazz, Double.TYPE) || Intrinsics.areEqual(clazz, Double.class) ? Double.valueOf(value) : (Intrinsics.areEqual(clazz, String.class) ? String.valueOf(value) : Double.valueOf(value)))));
    }
}

