/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.ai.model;

import com.embabel.agent.spi.LlmService;
import com.embabel.common.ai.model.AiModel;
import com.embabel.common.ai.model.AutoModelSelectionCriteria;
import com.embabel.common.ai.model.ByNameModelSelectionCriteria;
import com.embabel.common.ai.model.ByRoleModelSelectionCriteria;
import com.embabel.common.ai.model.ConfigurableModelProviderProperties;
import com.embabel.common.ai.model.DefaultModelSelectionCriteria;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.EmbeddingServiceMetadata;
import com.embabel.common.ai.model.FallbackByNameModelSelectionCriteria;
import com.embabel.common.ai.model.LlmMetadata;
import com.embabel.common.ai.model.ModelMetadata;
import com.embabel.common.ai.model.ModelProvider;
import com.embabel.common.ai.model.ModelSelectionCriteria;
import com.embabel.common.ai.model.NoSuitableModelException;
import com.embabel.common.ai.model.RandomByNameModelSelectionCriteria;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.FormatUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u00020\u0006H\u0002J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003H\u0016J\u001f\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0012\u0010\u001c\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001dH\u0016J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0012\u0010\u001c\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001dH\u0016J\u0014\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0016R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/embabel/common/ai/model/ConfigurableModelProvider;", "Lcom/embabel/common/ai/model/ModelProvider;", "llms", "", "Lcom/embabel/agent/spi/LlmService;", "embeddingServices", "Lcom/embabel/common/ai/model/EmbeddingService;", "properties", "Lcom/embabel/common/ai/model/ConfigurableModelProviderProperties;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/embabel/common/ai/model/ConfigurableModelProviderProperties;)V", "logger", "Lorg/slf4j/Logger;", "defaultLlm", "defaultEmbeddingService", "showModel", "", "model", "showEmbeddingModel", "listModels", "Lcom/embabel/common/ai/model/ModelMetadata;", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "listRoles", "modelClass", "Ljava/lang/Class;", "Lcom/embabel/common/ai/model/AiModel;", "listModelNames", "getLlm", "criteria", "Lcom/embabel/common/ai/model/ModelSelectionCriteria;", "getEmbeddingService", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nConfigurableModelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurableModelProvider.kt\ncom/embabel/common/ai/model/ConfigurableModelProvider\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,219:1\n27#2:220\n295#3,2:221\n1557#3:223\n1628#3,3:224\n2632#3,3:228\n1557#3:231\n1628#3,3:232\n2632#3,3:237\n1557#3:240\n1628#3,3:241\n295#3,2:245\n1557#3:247\n1628#3,3:248\n1557#3:265\n1628#3,3:266\n1557#3:269\n1628#3,3:270\n1053#3:273\n1053#3:274\n1557#3:275\n1628#3,3:276\n1557#3:279\n1628#3,3:280\n1557#3:283\n1628#3,3:284\n295#3,2:287\n1557#3:289\n1628#3,3:290\n295#3,2:293\n1557#3:295\n1628#3,3:296\n774#3:299\n865#3,2:300\n1557#3:302\n1628#3,3:303\n295#3,2:306\n1557#3:308\n1628#3,3:309\n295#3,2:312\n216#4:227\n217#4:235\n216#4:236\n217#4:244\n535#5:251\n520#5,6:252\n535#5:258\n520#5,6:259\n*S KotlinDebug\n*F\n+ 1 ConfigurableModelProvider.kt\ncom/embabel/common/ai/model/ConfigurableModelProvider\n*L\n66#1:220\n68#1:221,2\n69#1:223\n69#1:224,3\n78#1:228,3\n79#1:231\n79#1:232,3\n85#1:237,3\n86#1:240\n86#1:241,3\n73#1:245,2\n74#1:247\n74#1:248,3\n104#1:265\n104#1:266,3\n111#1:269\n111#1:270,3\n125#1:273\n131#1:274\n149#1:275\n149#1:276,3\n150#1:279\n150#1:280,3\n158#1:283\n158#1:284,3\n159#1:287,2\n159#1:289\n159#1:290,3\n163#1:293,2\n163#1:295\n163#1:296,3\n167#1:299\n167#1:300,2\n169#1:302\n169#1:303,3\n177#1:306,2\n185#1:308\n185#1:309,3\n207#1:312,2\n77#1:227\n77#1:235\n84#1:236\n84#1:244\n92#1:251\n92#1:252,6\n98#1:258\n98#1:259,6\n*E\n"})
public final class ConfigurableModelProvider
implements ModelProvider {
    @NotNull
    private final List<LlmService<?>> llms;
    @NotNull
    private final List<EmbeddingService> embeddingServices;
    @NotNull
    private final ConfigurableModelProviderProperties properties;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LlmService<?> defaultLlm;

    /*
     * WARNING - void declaration
     */
    public ConfigurableModelProvider(@NotNull List<? extends LlmService<?>> llms, @NotNull List<? extends EmbeddingService> embeddingServices, @NotNull ConfigurableModelProviderProperties properties) {
        Iterator $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        String $this$map$iv;
        boolean $i$f$map;
        LlmService it;
        boolean $i$f$none;
        Iterable $this$none$iv;
        String model;
        Map.Entry<String, String> entry;
        Map.Entry<String, String> element$iv;
        Object v1;
        Iterable $this$firstOrNull$iv;
        ConfigurableModelProvider configurableModelProvider;
        block13: {
            Intrinsics.checkNotNullParameter(llms, (String)"llms");
            Intrinsics.checkNotNullParameter(embeddingServices, (String)"embeddingServices");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            this.llms = llms;
            this.embeddingServices = embeddingServices;
            this.properties = properties;
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(ConfigurableModelProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.logger = logger;
            Iterable iterable = this.llms;
            configurableModelProvider = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                LlmService it2 = (LlmService)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)this.properties.getDefaultLlm())) continue;
                v1 = element$iv2;
                break block13;
            }
            v1 = null;
        }
        LlmService llmService = v1;
        if (llmService == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            $this$firstOrNull$iv = this.llms;
            String string = this.properties.getDefaultLlm();
            boolean $i$f$map2 = false;
            Iterator iterator = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                LlmService llmService2 = (LlmService)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it3.getName());
            }
            collection = (List)destination$iv$iv2;
            ConfigurableModelProvider configurableModelProvider2 = configurableModelProvider;
            String string2 = "Default LLM '" + string + "' not found in available models: " + (List)collection;
            throw new IllegalArgumentException(string2);
        }
        configurableModelProvider.defaultLlm = llmService;
        Map<String, String> $this$forEach$iv = this.properties.getLlms();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection;
            boolean bl;
            String role;
            block14: {
                entry = element$iv = iterator.next();
                boolean bl2 = false;
                role = entry.getKey();
                model = entry.getValue();
                $this$none$iv = this.llms;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv3 : $this$none$iv) {
                        it = (LlmService)element$iv3;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)model)) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            $this$none$iv = this.llms;
            String string = role;
            String string3 = model;
            $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
            boolean $i$f$mapTo = false;
            Iterator bl3 = $this$mapTo$iv$iv.iterator();
            while (bl3.hasNext()) {
                void it4;
                Object item$iv$iv = bl3.next();
                LlmService llmService3 = (LlmService)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it4.getName());
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = "LLM '" + string3 + "' for role " + string + " is not available: Choices are " + (List)collection;
            throw new IllegalStateException($this$map$iv.toString());
        }
        this.logger.info(HasInfoString.infoString$default((HasInfoString)this, (Boolean)true, (int)0, (int)2, null));
        $this$forEach$iv = this.properties.getEmbeddingServices();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection;
            boolean bl;
            String role;
            block15: {
                entry = element$iv = iterator.next();
                boolean bl5 = false;
                role = entry.getKey();
                model = entry.getValue();
                $this$none$iv = this.embeddingServices;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv3 : $this$none$iv) {
                        it = (EmbeddingService)element$iv3;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)model)) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            $this$none$iv = this.embeddingServices;
            String string = role;
            String string4 = model;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object item$iv$iv = iterator3.next();
                EmbeddingService it4 = (EmbeddingService)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add(it4.getName());
            }
            collection = (List)destination$iv$iv;
            String string5 = "Embedding model '" + string4 + "' for role " + string + " is not available: Choices are " + (List)collection;
            throw new IllegalStateException(string5.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final EmbeddingService defaultEmbeddingService() {
        Object v0;
        Iterable $this$firstOrNull$iv;
        block3: {
            $this$firstOrNull$iv = this.embeddingServices;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EmbeddingService it = (EmbeddingService)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.properties.getDefaultEmbeddingModel())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        EmbeddingService embeddingService = v0;
        if (embeddingService == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$firstOrNull$iv = this.embeddingServices;
            String string = this.properties.getDefaultEmbeddingModel();
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EmbeddingService embeddingService2 = (EmbeddingService)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            String string2 = "Default embedding service '" + string + "' not found in available models: " + (List)destination$iv$iv;
            throw new IllegalArgumentException(string2);
        }
        return embeddingService;
    }

    /*
     * WARNING - void declaration
     */
    private final String showModel(LlmService<?> model) {
        void $this$filterTo$iv$iv;
        Map<String, String> $this$filter$iv = this.properties.getLlms();
        boolean $i$f$filter = false;
        Map<String, String> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)model.getName())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set roles = destination$iv$iv.keySet();
        String maybeRoles = !((Collection)roles).isEmpty() ? " - Roles: " + CollectionsKt.joinToString$default((Iterable)roles, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "";
        return "name: " + model.getName() + ", provider: " + model.getProvider() + maybeRoles;
    }

    /*
     * WARNING - void declaration
     */
    private final String showEmbeddingModel(EmbeddingService model) {
        void $this$filterTo$iv$iv;
        Map<String, String> $this$filter$iv = this.properties.getEmbeddingServices();
        boolean $i$f$filter = false;
        Map<String, String> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)model.getName())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set roles = destination$iv$iv.keySet();
        String maybeRoles = !((Collection)roles).isEmpty() ? " - Roles: " + CollectionsKt.joinToString$default((Iterable)roles, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "";
        return "name: " + model.getName() + ", provider: " + model.getProvider() + maybeRoles;
    }

    @Override
    @NotNull
    public List<ModelMetadata> listModels() {
        EmbeddingService it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.llms;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LlmService llmService = (LlmService)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LlmMetadata.Companion.invoke(it.getName(), it.getProvider(), it.getKnowledgeCutoffDate(), it.getPricingModel()));
        }
        $this$map$iv = this.embeddingServices;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EmbeddingService)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(EmbeddingServiceMetadata.Companion.invoke$default((EmbeddingServiceMetadata.Companion)EmbeddingServiceMetadata.Companion, (String)it.getName(), (String)it.getProvider(), null, null, (int)12, null));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        void $this$sortedBy$iv;
        void $this$sortedBy$iv2;
        Iterable iterable = this.llms;
        boolean $i$f$sortedBy22 = false;
        String llmsInfo = "Available LLMs:\n\t" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LlmService it = (LlmService)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (LlmService)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }), (CharSequence)"\n\t", null, null, (int)0, null, arg_0 -> ConfigurableModelProvider.infoString$lambda$15(this, arg_0), (int)30, null);
        Iterable $i$f$sortedBy22 = this.embeddingServices;
        boolean $i$f$sortedBy = false;
        String embeddingServicesInfo = "Available embedding services:\n\t" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EmbeddingService it = (EmbeddingService)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (EmbeddingService)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }), (CharSequence)"\n\t", null, null, (int)0, null, arg_0 -> ConfigurableModelProvider.infoString$lambda$17(this, arg_0), (int)30, null);
        return FormatUtilsKt.indent$default((String)("Default LLM: " + this.properties.getDefaultLlm() + "\n" + llmsInfo + "\nDefault embedding service: " + this.properties.getDefaultEmbeddingModel() + "\n" + embeddingServicesInfo), (int)indent, null, (int)2, null);
    }

    @Override
    @NotNull
    public List<String> listRoles(@NotNull Class<? extends AiModel<?>> modelClass) {
        List list;
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        if (LlmService.class.isAssignableFrom(modelClass)) {
            list = CollectionsKt.toList((Iterable)this.properties.getLlms().keySet());
        } else if (EmbeddingService.class.isAssignableFrom(modelClass)) {
            list = CollectionsKt.toList((Iterable)this.properties.getEmbeddingServices().keySet());
        } else {
            throw new IllegalArgumentException("Unsupported model class: " + modelClass);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> listModelNames(@NotNull Class<? extends AiModel<?>> modelClass) {
        List list;
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        if (LlmService.class.isAssignableFrom(modelClass)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.llms;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LlmService llmService = (LlmService)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else if (EmbeddingService.class.isAssignableFrom(modelClass)) {
            Iterable $this$map$iv = this.embeddingServices;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                EmbeddingService it = (EmbeddingService)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            throw new IllegalArgumentException("Unsupported model class: " + modelClass);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LlmService<?> getLlm(@NotNull ModelSelectionCriteria criteria) {
        LlmService llmService;
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        ModelSelectionCriteria modelSelectionCriteria = criteria;
        if (modelSelectionCriteria instanceof ByRoleModelSelectionCriteria) {
            Object v1;
            Iterable $this$firstOrNull$iv;
            block26: {
                String string = this.properties.getLlms().get(((ByRoleModelSelectionCriteria)criteria).getRole());
                if (string == null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.llms;
                    ModelSelectionCriteria modelSelectionCriteria2 = criteria;
                    boolean $i$f$map = false;
                    void var7_19 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        LlmService llmService2 = (LlmService)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getName());
                    }
                    List list = (List)destination$iv$iv;
                    ModelSelectionCriteria modelSelectionCriteria3 = modelSelectionCriteria2;
                    throw new NoSuitableModelException(modelSelectionCriteria3, list);
                }
                String modelName = string;
                $this$firstOrNull$iv = this.llms;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LlmService it = (LlmService)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)modelName)) continue;
                    v1 = element$iv;
                    break block26;
                }
                v1 = null;
            }
            if ((llmService = (LlmService)v1) == null) {
                void $this$map$iv;
                $this$firstOrNull$iv = this.llms;
                ModelSelectionCriteria modelSelectionCriteria4 = criteria;
                boolean $i$f$map2 = false;
                Iterator $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl = $this$mapTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object item$iv$iv2 = bl.next();
                    LlmService it = (LlmService)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getName());
                }
                List list = (List)destination$iv$iv;
                ModelSelectionCriteria modelSelectionCriteria5 = modelSelectionCriteria4;
                throw new NoSuitableModelException(modelSelectionCriteria5, list);
            }
        } else if (modelSelectionCriteria instanceof ByNameModelSelectionCriteria) {
            Object v3;
            Iterable $this$firstOrNull$iv;
            block27: {
                $this$firstOrNull$iv = this.llms;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LlmService it = (LlmService)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)((ByNameModelSelectionCriteria)criteria).getName())) continue;
                    v3 = element$iv;
                    break block27;
                }
                v3 = null;
            }
            if ((llmService = (LlmService)v3) == null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$firstOrNull$iv = this.llms;
                ModelSelectionCriteria modelSelectionCriteria6 = criteria;
                boolean $i$f$map = false;
                Iterator $i$f$map2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LlmService item$iv$iv2 = (LlmService)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                List list = (List)destination$iv$iv;
                ModelSelectionCriteria modelSelectionCriteria7 = modelSelectionCriteria6;
                throw new NoSuitableModelException(modelSelectionCriteria7, list);
            }
        } else if (modelSelectionCriteria instanceof RandomByNameModelSelectionCriteria) {
            LlmService it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.llms;
            boolean $i$f$filter = false;
            Iterable $this$mapTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LlmService)element$iv$iv;
                boolean bl = false;
                if (!((RandomByNameModelSelectionCriteria)criteria).getNames().contains(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List models = (List)destination$iv$iv;
            if (models.isEmpty()) {
                void $this$map$iv;
                $this$filter$iv = this.llms;
                ModelSelectionCriteria modelSelectionCriteria8 = criteria;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (LlmService)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                List list = (List)destination$iv$iv;
                ModelSelectionCriteria modelSelectionCriteria9 = modelSelectionCriteria8;
                throw new NoSuitableModelException(modelSelectionCriteria9, list);
            }
            llmService = (LlmService)CollectionsKt.random((Collection)models, (Random)((Random)Random.Default));
        } else if (modelSelectionCriteria instanceof FallbackByNameModelSelectionCriteria) {
            LlmService llm = null;
            for (Object requestedName : ((FallbackByNameModelSelectionCriteria)criteria).getNames()) {
                Object v4;
                block28: {
                    Iterable $this$firstOrNull$iv = this.llms;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        LlmService it = (LlmService)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)requestedName, (Object)it.getName())) continue;
                        v4 = element$iv;
                        break block28;
                    }
                    v4 = null;
                }
                llm = v4;
                if (llm != null) break;
                this.logger.info("Requested LLM '{}' not found", requestedName);
            }
            if ((llmService = llm) == null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object requestedName;
                requestedName = this.llms;
                ModelSelectionCriteria modelSelectionCriteria10 = criteria;
                boolean $i$f$map = false;
                void $i$f$firstOrNull = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LlmService bl = (LlmService)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getName());
                }
                List list = (List)destination$iv$iv;
                ModelSelectionCriteria modelSelectionCriteria11 = modelSelectionCriteria10;
                throw new NoSuitableModelException(modelSelectionCriteria11, list);
            }
        } else {
            if (modelSelectionCriteria instanceof AutoModelSelectionCriteria) {
                throw new IllegalStateException("Auto model selection criteria should have been resolved upstream".toString());
            }
            if (modelSelectionCriteria instanceof DefaultModelSelectionCriteria) {
                llmService = this.defaultLlm;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return llmService;
    }

    @Override
    @NotNull
    public EmbeddingService getEmbeddingService(@NotNull ModelSelectionCriteria criteria) {
        EmbeddingService embeddingService;
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (criteria instanceof ByRoleModelSelectionCriteria) {
            Object v1;
            block5: {
                String string = this.properties.getEmbeddingServices().get(((ByRoleModelSelectionCriteria)criteria).getRole());
                if (string == null) {
                    throw NoSuitableModelException.Companion.forModels(criteria, this.embeddingServices);
                }
                String modelName = string;
                Iterable $this$firstOrNull$iv = this.embeddingServices;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EmbeddingService it = (EmbeddingService)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)modelName)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            if ((embeddingService = (EmbeddingService)v1) == null) {
                throw NoSuitableModelException.Companion.forModels(criteria, this.embeddingServices);
            }
        } else {
            embeddingService = this.defaultEmbeddingService();
        }
        return embeddingService;
    }

    private static final CharSequence infoString$lambda$15(ConfigurableModelProvider this$0, LlmService it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.showModel(it);
    }

    private static final CharSequence infoString$lambda$17(ConfigurableModelProvider this$0, EmbeddingService it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.showEmbeddingModel(it);
    }
}

