/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.web.rest;

import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.AgentProcessStatusCode;
import com.embabel.agent.core.AgentProcessStatusReport;
import com.embabel.agent.web.rest.AgentProcessStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/v1/process"})
@Tag(name="AgentProcess information and control", description="Endpoints for retrieving AgentProcess information, including status and results.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/web/rest/AgentProcessController;", "", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "<init>", "(Lcom/embabel/agent/core/AgentPlatform;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "checkProcessStatus", "Lcom/embabel/agent/web/rest/AgentProcessStatus;", "processId", "", "killAgentProcess", "Lcom/embabel/agent/core/AgentProcessStatusReport;", "id", "embabel-agent-api"})
public class AgentProcessController {
    @NotNull
    private final AgentPlatform agentPlatform;
    private final Logger logger;

    public AgentProcessController(@NotNull AgentPlatform agentPlatform) {
        Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
        this.agentPlatform = agentPlatform;
        this.logger = LoggerFactory.getLogger(AgentProcessController.class);
    }

    @Operation(summary="Get the status of a process", description="Returns the status of the process with the given ID, including its current status, running time, and last result.")
    @ApiResponses(value={@ApiResponse(description="Process status returned", responseCode="200"), @ApiResponse(description="Process not found", responseCode="404")})
    @GetMapping(value={"/{processId}"})
    @NotNull
    public AgentProcessStatus checkProcessStatus(@PathVariable @NotNull String processId) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        AgentProcess agentProcess = this.agentPlatform.getAgentProcess(processId);
        if (agentProcess == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Process not found");
        }
        AgentProcess agentProcess2 = agentProcess;
        return new AgentProcessStatus(agentProcess2.getId(), (AgentProcessStatusCode)agentProcess2.getStatus(), agentProcess2.getTimestamp(), agentProcess2.getRunningTime(), agentProcess2.lastResult(), null, null, 96, null);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Kill the given process", description="Returns the status of a process if it could be killed")
    @ApiResponses(value={@ApiResponse(description="Process status killed successfully", responseCode="200"), @ApiResponse(description="Process not found", responseCode="404")})
    @NotNull
    public AgentProcessStatusReport killAgentProcess(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AgentProcess agentProcess = this.agentPlatform.killAgentProcess(id);
        if (agentProcess == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No process found with id: " + id);
        }
        AgentProcess killedProcess = agentProcess;
        return killedProcess.statusReport();
    }
}

