/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.spi.support.DelegatingTool;
import com.embabel.agent.spi.support.ToolDecoratorsKt;
import com.embabel.common.util.StringTransformer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/embabel/agent/spi/support/OutputTransformingTool;", "Lcom/embabel/agent/spi/support/DelegatingTool;", "delegate", "Lcom/embabel/agent/api/tool/Tool;", "outputTransformer", "Lcom/embabel/common/util/StringTransformer;", "<init>", "(Lcom/embabel/agent/api/tool/Tool;Lcom/embabel/common/util/StringTransformer;)V", "getDelegate", "()Lcom/embabel/agent/api/tool/Tool;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "", "embabel-agent-api"})
public final class OutputTransformingTool
implements DelegatingTool {
    @NotNull
    private final Tool delegate;
    @NotNull
    private final StringTransformer outputTransformer;
    private final Logger logger;
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;

    public OutputTransformingTool(@NotNull Tool delegate, @NotNull StringTransformer outputTransformer) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)outputTransformer, (String)"outputTransformer");
        this.delegate = delegate;
        this.outputTransformer = outputTransformer;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.definition = this.getDelegate().getDefinition();
        this.metadata = this.getDelegate().getMetadata();
    }

    @Override
    @NotNull
    public Tool getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Tool.Result rawResult = this.getDelegate().call(input);
        String transformed = this.outputTransformer.transform(ToolDecoratorsKt.access$getContent(rawResult));
        Object[] objectArray = new Object[]{this.getDelegate().getDefinition().getName(), input, ToolDecoratorsKt.access$getContent(rawResult), transformed};
        this.logger.debug("Tool {} called with input: {}, raw output: {}, transformed output: {}", objectArray);
        int saving = ToolDecoratorsKt.access$getContent(rawResult).length() - transformed.length();
        this.logger.debug("Saved {} bytes from {}", (Object)saving, (Object)ToolDecoratorsKt.access$getContent(rawResult).length());
        return Tool.Result.Companion.text(transformed);
    }
}

