/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.core.Context;
import com.embabel.agent.spi.ContextRepository;
import com.embabel.agent.spi.config.spring.ContextRepositoryProperties;
import com.embabel.agent.spi.support.InMemoryContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\tH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/spi/support/InMemoryContextRepository;", "Lcom/embabel/agent/spi/ContextRepository;", "properties", "Lcom/embabel/agent/spi/config/spring/ContextRepositoryProperties;", "<init>", "(Lcom/embabel/agent/spi/config/spring/ContextRepositoryProperties;)V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/embabel/agent/core/Context;", "accessOrder", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "create", "findById", "id", "save", "context", "delete", "", "size", "", "clear", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nInMemoryContextRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryContextRepository.kt\ncom/embabel/agent/spi/support/InMemoryContextRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class InMemoryContextRepository
implements ContextRepository {
    @NotNull
    private final ContextRepositoryProperties properties;
    @NotNull
    private final ConcurrentHashMap<String, Context> map;
    @NotNull
    private final ConcurrentLinkedQueue<String> accessOrder;
    @NotNull
    private final ReentrantReadWriteLock lock;

    public InMemoryContextRepository(@NotNull ContextRepositoryProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        this.map = new ConcurrentHashMap();
        this.accessOrder = new ConcurrentLinkedQueue();
        this.lock = new ReentrantReadWriteLock();
    }

    public /* synthetic */ InMemoryContextRepository(ContextRepositoryProperties contextRepositoryProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            contextRepositoryProperties = new ContextRepositoryProperties();
        }
        this(contextRepositoryProperties);
    }

    @Override
    @NotNull
    public Context create() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.save(new InMemoryContext(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Context findById(@NotNull String id) {
        Context context;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            context = this.map.get(id);
        }
        finally {
            readLock.unlock();
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Context save(@NotNull Context context) {
        Context context2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            String persistentId;
            boolean bl = false;
            String string = context.getId();
            if (string == null) {
                String string2 = UUID.randomUUID().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            if (this.map.containsKey(persistentId = string)) {
                this.accessOrder.remove(persistentId);
            }
            ((Map)this.map).put(persistentId, context);
            this.accessOrder.offer(persistentId);
            while (this.map.size() > this.properties.getWindowSize()) {
                String oldestId = this.accessOrder.poll();
                if (oldestId == null) continue;
                this.map.remove(oldestId);
            }
            context2 = context;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return context2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            String contextId = context.getId();
            this.map.remove(contextId);
            boolean bl2 = this.accessOrder.remove(contextId);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.map.size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.map.clear();
            this.accessOrder.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public InMemoryContextRepository() {
        this(null, 1, null);
    }
}

