/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core;

import com.embabel.agent.core.Usage;
import com.embabel.common.ai.model.LlmMetadata;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.core.types.Timed;
import com.embabel.common.core.types.Timestamped;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.ai.chat.metadata.DefaultUsage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\fH\u00c6\u0003J=\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/embabel/agent/core/LlmInvocation;", "Lcom/embabel/common/core/types/Timestamped;", "Lcom/embabel/common/core/types/Timed;", "llmMetadata", "Lcom/embabel/common/ai/model/LlmMetadata;", "usage", "Lcom/embabel/agent/core/Usage;", "agentName", "", "timestamp", "Ljava/time/Instant;", "runningTime", "Ljava/time/Duration;", "<init>", "(Lcom/embabel/common/ai/model/LlmMetadata;Lcom/embabel/agent/core/Usage;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Duration;)V", "getLlmMetadata", "()Lcom/embabel/common/ai/model/LlmMetadata;", "getUsage", "()Lcom/embabel/agent/core/Usage;", "getAgentName", "()Ljava/lang/String;", "getTimestamp", "()Ljava/time/Instant;", "getRunningTime", "()Ljava/time/Duration;", "cost", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "embabel-agent-api"})
public final class LlmInvocation
implements Timestamped,
Timed {
    @NotNull
    private final LlmMetadata llmMetadata;
    @NotNull
    private final Usage usage;
    @Nullable
    private final String agentName;
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final Duration runningTime;

    public LlmInvocation(@NotNull LlmMetadata llmMetadata, @NotNull Usage usage, @Nullable String agentName, @NotNull Instant timestamp, @NotNull Duration runningTime) {
        Intrinsics.checkNotNullParameter((Object)llmMetadata, (String)"llmMetadata");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)runningTime, (String)"runningTime");
        this.llmMetadata = llmMetadata;
        this.usage = usage;
        this.agentName = agentName;
        this.timestamp = timestamp;
        this.runningTime = runningTime;
    }

    public /* synthetic */ LlmInvocation(LlmMetadata llmMetadata, Usage usage, String string, Instant instant, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(llmMetadata, usage, string, instant, duration);
    }

    @NotNull
    public final LlmMetadata getLlmMetadata() {
        return this.llmMetadata;
    }

    @NotNull
    public final Usage getUsage() {
        return this.usage;
    }

    @Nullable
    public final String getAgentName() {
        return this.agentName;
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public Duration getRunningTime() {
        return this.runningTime;
    }

    public final double cost() {
        double d;
        PricingModel pricingModel = this.llmMetadata.getPricingModel();
        if (pricingModel != null) {
            Integer n = this.usage.getPromptTokens();
            Integer n2 = this.usage.getCompletionTokens();
            d = pricingModel.costOf((org.springframework.ai.chat.metadata.Usage)new DefaultUsage(Integer.valueOf(n != null ? n : 0), Integer.valueOf(n2 != null ? n2 : 0)));
        } else {
            d = 0.0;
        }
        return d;
    }

    @NotNull
    public final LlmMetadata component1() {
        return this.llmMetadata;
    }

    @NotNull
    public final Usage component2() {
        return this.usage;
    }

    @Nullable
    public final String component3() {
        return this.agentName;
    }

    @NotNull
    public final Instant component4() {
        return this.timestamp;
    }

    @NotNull
    public final Duration component5() {
        return this.runningTime;
    }

    @NotNull
    public final LlmInvocation copy(@NotNull LlmMetadata llmMetadata, @NotNull Usage usage, @Nullable String agentName, @NotNull Instant timestamp, @NotNull Duration runningTime) {
        Intrinsics.checkNotNullParameter((Object)llmMetadata, (String)"llmMetadata");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)runningTime, (String)"runningTime");
        return new LlmInvocation(llmMetadata, usage, agentName, timestamp, runningTime);
    }

    public static /* synthetic */ LlmInvocation copy$default(LlmInvocation llmInvocation, LlmMetadata llmMetadata, Usage usage, String string, Instant instant, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            llmMetadata = llmInvocation.llmMetadata;
        }
        if ((n & 2) != 0) {
            usage = llmInvocation.usage;
        }
        if ((n & 4) != 0) {
            string = llmInvocation.agentName;
        }
        if ((n & 8) != 0) {
            instant = llmInvocation.timestamp;
        }
        if ((n & 0x10) != 0) {
            duration = llmInvocation.runningTime;
        }
        return llmInvocation.copy(llmMetadata, usage, string, instant, duration);
    }

    @NotNull
    public String toString() {
        return "LlmInvocation(llmMetadata=" + this.llmMetadata + ", usage=" + this.usage + ", agentName=" + this.agentName + ", timestamp=" + this.timestamp + ", runningTime=" + this.runningTime + ")";
    }

    public int hashCode() {
        int result = this.llmMetadata.hashCode();
        result = result * 31 + this.usage.hashCode();
        result = result * 31 + (this.agentName == null ? 0 : this.agentName.hashCode());
        result = result * 31 + this.timestamp.hashCode();
        result = result * 31 + this.runningTime.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LlmInvocation)) {
            return false;
        }
        LlmInvocation llmInvocation = (LlmInvocation)other;
        if (!Intrinsics.areEqual((Object)this.llmMetadata, (Object)llmInvocation.llmMetadata)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.usage, (Object)llmInvocation.usage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.agentName, (Object)llmInvocation.agentName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timestamp, (Object)llmInvocation.timestamp)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.runningTime, (Object)llmInvocation.runningTime);
    }
}

