/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.annotation.support;

import com.embabel.agent.core.Action;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.IoBinding;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\"\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/embabel/agent/api/annotation/support/TypeSchemaExtractor;", "", "<init>", "()V", "extractSchema", "", "typeName", "klass", "Lkotlin/reflect/KClass;", "formatTypeName", "buildActionSignature", "action", "Lcom/embabel/agent/core/Action;", "isInjectedType", "", "buildArtifactsSummary", "blackboard", "Lcom/embabel/agent/core/Blackboard;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "maxValueLength", "", "formatValue", "value", "maxLength", "isSystemType", "obj", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nTypeSchemaExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeSchemaExtractor.kt\ncom/embabel/agent/api/annotation/support/TypeSchemaExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,195:1\n1557#2:196\n1628#2,3:197\n774#2:200\n865#2,2:201\n1557#2:203\n1628#2,3:204\n774#2:215\n865#2,2:216\n1755#2,3:218\n1#3:207\n503#4,7:208\n*S KotlinDebug\n*F\n+ 1 TypeSchemaExtractor.kt\ncom/embabel/agent/api/annotation/support/TypeSchemaExtractor\n*L\n57#1:196\n57#1:197,3\n81#1:200\n81#1:201,2\n82#1:203\n82#1:204,3\n126#1:215\n126#1:216,2\n192#1:218,3\n123#1:208,7\n*E\n"})
public final class TypeSchemaExtractor {
    @NotNull
    public static final TypeSchemaExtractor INSTANCE = new TypeSchemaExtractor();

    private TypeSchemaExtractor() {
    }

    @JvmStatic
    @NotNull
    public static final String extractSchema(@NotNull String typeName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        try {
            Class<?> clazz = Class.forName(typeName);
            Intrinsics.checkNotNull(clazz);
            string = TypeSchemaExtractor.extractSchema(JvmClassMappingKt.getKotlinClass(clazz));
        }
        catch (ClassNotFoundException e) {
            string = StringsKt.substringAfterLast$default((String)typeName, (String)".", null, (int)2, null);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String extractSchema(@NotNull KClass<?> klass) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Collection properties = KClasses.getMemberProperties(klass);
        if (properties.isEmpty()) {
            String string = klass.getSimpleName();
            if (string == null) {
                string = "Unknown";
            }
            return string;
        }
        Iterable $this$map$iv = properties;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void prop;
            KProperty1 kProperty1 = (KProperty1)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String typeName = INSTANCE.formatTypeName(prop.getReturnType().toString());
            collection.add(prop.getName() + ": " + typeName);
        }
        List fields = (List)destination$iv$iv;
        return "{ " + CollectionsKt.joinToString$default((Iterable)fields, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " }";
    }

    private final String formatTypeName(String typeName) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)typeName, (String)"kotlin.", (String)"", (boolean)false, (int)4, null), (String)"java.lang.", (String)"", (boolean)false, (int)4, null), (String)"java.util.", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String buildActionSignature(@NotNull Action action) {
        String string;
        String outputType;
        List inputs;
        block7: {
            block6: {
                void $this$mapTo$iv$iv;
                String it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Iterable $this$filter$iv = action.getInputs();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = ((IoBinding)element$iv$iv).unbox-impl();
                    boolean bl = false;
                    if (!(!INSTANCE.isInjectedType(IoBinding.getType-impl(it)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void input;
                    it = ((IoBinding)item$iv$iv).unbox-impl();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String simpleName = StringsKt.substringAfterLast$default((String)IoBinding.getType-impl((String)input), (String)".", null, (int)2, null);
                    collection.add(IoBinding.getName-impl((String)input) + ": " + simpleName);
                }
                inputs = (List)destination$iv$iv;
                IoBinding ioBinding = (IoBinding)CollectionsKt.firstOrNull((Iterable)action.getOutputs());
                String string2 = ioBinding != null ? ioBinding.unbox-impl() : null;
                if (string2 == null || (string2 = IoBinding.getType-impl(string2)) == null || (string2 = StringsKt.substringAfterLast$default((String)string2, (String)".", null, (int)2, null)) == null) {
                    string2 = "Unit";
                }
                outputType = string2;
                IoBinding ioBinding2 = (IoBinding)CollectionsKt.firstOrNull((Iterable)action.getOutputs());
                string = ioBinding2 != null ? ioBinding2.unbox-impl() : null;
                if (string == null) break block6;
                String it2 = string;
                boolean bl = false;
                String string3 = TypeSchemaExtractor.extractSchema(IoBinding.getType-impl(it2));
                string = string3;
                if (string3 != null) break block7;
            }
            string = "";
        }
        String outputSchema = string;
        String inputStr = CollectionsKt.joinToString$default((Iterable)inputs, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        String schemaStr = ((CharSequence)outputSchema).length() > 0 && !Intrinsics.areEqual((Object)outputSchema, (Object)outputType) ? "\n    Schema: " + outputSchema : "";
        return action.shortName() + "(" + inputStr + ") -> " + outputType + schemaStr;
    }

    private final boolean isInjectedType(String typeName) {
        Object[] objectArray = new String[]{"com.embabel.agent.api.common.Ai", "com.embabel.agent.api.common.OperationContext", "com.embabel.agent.core.AgentProcess", "com.embabel.agent.core.ProcessContext"};
        Set injectedTypes = SetsKt.setOf((Object[])objectArray);
        return injectedTypes.contains(typeName);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String buildArtifactsSummary(@NotNull Blackboard blackboard, @NotNull ObjectMapper objectMapper, int maxValueLength) {
        void $this$filter$iv;
        void $this$filterValues$iv;
        Intrinsics.checkNotNullParameter((Object)blackboard, (String)"blackboard");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Map<String, Object> map = blackboard.expressionEvaluationModel();
        boolean $i$f$filterValues232 = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(!INSTANCE.isSystemType(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map mapValues = result$iv;
        Iterable $i$f$filterValues232 = blackboard.getObjects();
        boolean $i$f$filter = false;
        void var7_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator bl = var7_10.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = bl.next();
            boolean bl2 = false;
            if (!(!INSTANCE.isSystemType(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List objectValues = (List)destination$iv$iv;
        if (mapValues.isEmpty() && objectValues.isEmpty()) {
            return "No artifacts yet";
        }
        List artifacts = new ArrayList();
        for (Map.Entry entry : mapValues.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String string = Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName();
            if (string == null) {
                string = "Unknown";
            }
            String typeName = string;
            String valueStr = INSTANCE.formatValue(value, objectMapper, maxValueLength);
            artifacts.add("- " + key + " (" + typeName + "): " + valueStr);
        }
        Set mapValueSet = CollectionsKt.toSet((Iterable)mapValues.values());
        for (Object obj : objectValues) {
            if (mapValueSet.contains(obj)) continue;
            String string = Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName();
            if (string == null) {
                string = "Unknown";
            }
            String typeName = string;
            String valueStr = INSTANCE.formatValue(obj, objectMapper, maxValueLength);
            artifacts.add("- (" + typeName + "): " + valueStr);
        }
        return CollectionsKt.joinToString$default((Iterable)artifacts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String buildArtifactsSummary$default(Blackboard blackboard, ObjectMapper objectMapper, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 500;
        }
        return TypeSchemaExtractor.buildArtifactsSummary(blackboard, objectMapper, n);
    }

    private final String formatValue(Object value, ObjectMapper objectMapper, int maxLength) {
        String string;
        try {
            Object object;
            String json = objectMapper.writeValueAsString(value);
            if (json.length() > maxLength) {
                Intrinsics.checkNotNull((Object)json);
                object = StringsKt.take((String)json, (int)maxLength) + "...";
            } else {
                object = json;
            }
            string = object;
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            string = StringsKt.take((String)value.toString(), (int)maxLength);
        }
        return string;
    }

    private final boolean isSystemType(Object obj) {
        boolean bl;
        block6: {
            String string = Reflection.getOrCreateKotlinClass(obj.getClass()).getQualifiedName();
            if (string == null) {
                return false;
            }
            String className = string;
            if (obj instanceof Boolean || obj instanceof Number || obj instanceof String) {
                return true;
            }
            if (StringsKt.startsWith$default((String)className, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"kotlin.", (boolean)false, (int)2, null)) {
                return true;
            }
            Object[] objectArray = new String[]{"com.embabel.agent.core.", "com.embabel.agent.spi.", "com.embabel.agent.api.common.", "com.embabel.agent.api.event."};
            List frameworkPrefixes = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = frameworkPrefixes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)className, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }
}

