/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.annotation.support;

import com.embabel.agent.api.annotation.support.CurriedActionTool;
import com.embabel.agent.api.annotation.support.TypeSchemaExtractor;
import com.embabel.agent.api.common.InteractionId;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.ActionQos;
import com.embabel.agent.core.ActionRunner;
import com.embabel.agent.core.ActionStatus;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.IoBinding;
import com.embabel.agent.core.ProcessContext;
import com.embabel.agent.core.support.AbstractAction;
import com.embabel.agent.core.support.LlmInteraction;
import com.embabel.agent.spi.LlmOperations;
import com.embabel.plan.WorldState;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010!\u001a\u00020\u0003H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/embabel/agent/api/annotation/support/SupervisorAction;", "Lcom/embabel/agent/core/support/AbstractAction;", "name", "", "description", "inputs", "", "Lcom/embabel/agent/core/IoBinding;", "outputs", "toolActions", "", "Lcom/embabel/agent/core/Action;", "goalAction", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Ljava/util/List;Lcom/embabel/agent/core/Action;)V", "getToolActions", "()Ljava/util/List;", "execute", "Lcom/embabel/agent/core/ActionStatus;", "processContext", "Lcom/embabel/agent/core/ProcessContext;", "isGoalAchieved", "", "goalOutputType", "canExecuteGoalAction", "executeGoalAction", "", "buildSupervisorPrompt", "tools", "Lcom/embabel/agent/api/tool/Tool;", "iteration", "", "referencedInputProperties", "variable", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nSupervisorAgentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupervisorAgentFactory.kt\ncom/embabel/agent/api/annotation/support/SupervisorAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,379:1\n1755#2,3:380\n1734#2,2:383\n1755#2,3:385\n1736#2:388\n1863#2,2:389\n*S KotlinDebug\n*F\n+ 1 SupervisorAgentFactory.kt\ncom/embabel/agent/api/annotation/support/SupervisorAction\n*L\n294#1:380,3\n307#1:383,2\n308#1:385,3\n307#1:388\n229#1:389,2\n*E\n"})
public final class SupervisorAction
extends AbstractAction {
    @NotNull
    private final List<Action> toolActions;
    @NotNull
    private final Action goalAction;

    public SupervisorAction(@NotNull String name, @NotNull String description, @NotNull Set<IoBinding> inputs, @NotNull Set<IoBinding> outputs, @NotNull List<? extends Action> toolActions, @NotNull Action goalAction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        Intrinsics.checkNotNullParameter(toolActions, (String)"toolActions");
        Intrinsics.checkNotNullParameter((Object)goalAction, (String)"goalAction");
        super(name, description, CollectionsKt.emptyList(), CollectionsKt.emptyList(), SupervisorAction::_init_$lambda$0, SupervisorAction::_init_$lambda$1, inputs, outputs, SetsKt.emptySet(), false, false, new ActionQos(0, 0L, 0.0, 0L, false, 31, null), 1024, null);
        this.toolActions = toolActions;
        this.goalAction = goalAction;
    }

    @NotNull
    public final List<Action> getToolActions() {
        return this.toolActions;
    }

    @Override
    @NotNull
    public ActionStatus execute(@NotNull ProcessContext processContext) {
        Intrinsics.checkNotNullParameter((Object)processContext, (String)"processContext");
        return ActionRunner.Companion.execute(processContext, (Function0<Unit>)((Function0)() -> SupervisorAction.execute$lambda$4(processContext, this)));
    }

    private final boolean isGoalAchieved(ProcessContext processContext, String goalOutputType) {
        boolean bl;
        block4: {
            if (goalOutputType == null) {
                return false;
            }
            Map<String, Object> blackboardModel = processContext.getBlackboard().expressionEvaluationModel();
            Iterable $this$any$iv = blackboardModel.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object value = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)value.getClass().getName(), (Object)goalOutputType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean canExecuteGoalAction(ProcessContext processContext) {
        boolean bl;
        block7: {
            Blackboard blackboard = processContext.getBlackboard();
            List mapValues = CollectionsKt.filterNotNull((Iterable)blackboard.expressionEvaluationModel().values());
            List<Object> objectValues = blackboard.getObjects();
            List allValues = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)mapValues, (Iterable)objectValues));
            Iterable $this$all$iv = this.goalAction.getInputs();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block6: {
                        String input = ((IoBinding)element$iv).unbox-impl();
                        boolean bl3 = false;
                        Iterable $this$any$iv = allValues;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            Iterator iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv2;
                                Object value = element$iv2 = iterator.next();
                                boolean bl4 = false;
                                if (!CurriedActionTool.Companion.isCompatibleType(value, IoBinding.getType-impl(input))) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void executeGoalAction(ProcessContext processContext) {
        ActionStatus result = this.goalAction.execute(processContext);
        this.getLogger().info("Goal action '{}' executed with result: {}", (Object)this.goalAction.shortName(), (Object)result);
    }

    private final String buildSupervisorPrompt(ProcessContext processContext, List<? extends Tool> tools, int iteration) {
        String string;
        String goalTypeName;
        String artifactsSummary;
        String actionSignatures;
        block5: {
            block4: {
                ObjectMapper objectMapper = processContext.getPlatformServices$embabel_agent_api().getObjectMapper();
                actionSignatures = CollectionsKt.joinToString$default((Iterable)this.toolActions, (CharSequence)"\n", null, null, (int)0, null, SupervisorAction::buildSupervisorPrompt$lambda$8, (int)30, null);
                artifactsSummary = TypeSchemaExtractor.buildArtifactsSummary$default(processContext.getBlackboard(), objectMapper, 0, 4, null);
                IoBinding ioBinding = (IoBinding)CollectionsKt.firstOrNull((Iterable)this.goalAction.getOutputs());
                String string2 = ioBinding != null ? ioBinding.unbox-impl() : null;
                if (string2 == null || (string2 = IoBinding.getType-impl(string2)) == null || (string2 = StringsKt.substringAfterLast$default((String)string2, (String)".", null, (int)2, null)) == null) {
                    string2 = "goal";
                }
                goalTypeName = string2;
                IoBinding ioBinding2 = (IoBinding)CollectionsKt.firstOrNull((Iterable)this.goalAction.getOutputs());
                string = ioBinding2 != null ? ioBinding2.unbox-impl() : null;
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                String string3 = TypeSchemaExtractor.extractSchema(IoBinding.getType-impl(it));
                string = string3;
                if (string3 != null) break block5;
            }
            string = "";
        }
        String goalSchema = string;
        Object iterationNote = iteration > 1 ? "\n\nIteration " + iteration + ": Review the artifacts gathered so far and decide the next step." : "";
        return StringsKt.trimMargin$default((String)("\n            |You are a supervisor agent that orchestrates actions to achieve a goal.\n            |You decide what to call and when, based on the available actions and gathered artifacts.\n            |\n            |## Available Actions\n            |Each action shows its signature and output type schema:\n            |" + actionSignatures + "\n            |\n            |## Current Artifacts\n            |Data gathered so far (typed and validated):\n            |" + artifactsSummary + "\n            |\n            |## Goal\n            |Produce: " + goalTypeName + "\n            |Schema: " + goalSchema + "\n            |Description: " + this.goalAction.getDescription() + "\n            |" + (String)iterationNote + "\n            |\n            |## Instructions\n            |- Review the available actions and their output types\n            |- Consider what artifacts you've gathered and what you still need\n            |- Call ONE action to make progress toward the goal\n            |- You can pass any appropriate arguments - use gathered data as context\n            |- When you have enough information, call the goal action to produce the final result\n            |- The action outputs are TYPED - you'll see their schemas above\n        "), null, (int)1, null);
    }

    @Override
    @NotNull
    public Set<String> referencedInputProperties(@NotNull String variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return SetsKt.emptySet();
    }

    private static final double _init_$lambda$0(WorldState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0.0;
    }

    private static final double _init_$lambda$1(WorldState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0.0;
    }

    private static final Unit execute$lambda$4(ProcessContext $processContext, SupervisorAction this$0) {
        ObjectMapper objectMapper = $processContext.getPlatformServices$embabel_agent_api().getObjectMapper();
        LlmOperations llmOperations = $processContext.getPlatformServices$embabel_agent_api().getLlmOperations();
        IoBinding ioBinding = (IoBinding)CollectionsKt.firstOrNull((Iterable)this$0.goalAction.getOutputs());
        String string = ioBinding != null ? ioBinding.unbox-impl() : null;
        String goalOutputType = string != null ? IoBinding.getType-impl(string) : null;
        int iteration = 0;
        int maxIterations = 10;
        while (iteration < maxIterations) {
            ++iteration;
            if (this$0.isGoalAchieved($processContext, goalOutputType)) {
                this$0.getLogger().info("Goal achieved after {} iterations", (Object)(iteration - 1));
                break;
            }
            List<Tool> curriedTools = CurriedActionTool.Companion.createTools(this$0.toolActions, $processContext.getBlackboard(), objectMapper);
            Object[] objectArray = new Object[]{iteration, curriedTools.size(), this$0.toolActions.size()};
            this$0.getLogger().info("Supervisor iteration {}: {} curried tools (from {} actions)", objectArray);
            Iterable $this$forEach$iv = curriedTools;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tool tool = (Tool)element$iv;
                boolean bl = false;
                boolean isReady = CurriedActionTool.Companion.isReady(tool);
                Object[] objectArray2 = new Object[]{tool.getDefinition().getName(), isReady ? "READY" : "needs inputs", tool.getDefinition().getDescription()};
                this$0.getLogger().debug("Tool '{}': {} - {}", objectArray2);
            }
            String prompt = this$0.buildSupervisorPrompt($processContext, curriedTools, iteration);
            LlmInteraction interaction = new LlmInteraction(InteractionId.constructor-impl(this$0.getName() + "-supervisor-" + iteration), null, null, curriedTools, null, null, null, null, false, false, 0, null, 4086, null);
            String response = llmOperations.generate(prompt, interaction, $processContext.getAgentProcess(), this$0);
            this$0.getLogger().info("Supervisor iteration {} response: {}", (Object)iteration, (Object)response);
            if (!this$0.isGoalAchieved($processContext, goalOutputType)) continue;
            this$0.getLogger().info("Goal achieved after iteration {}", (Object)iteration);
            break;
        }
        if (iteration >= maxIterations) {
            this$0.getLogger().warn("Supervisor reached max iterations ({}) without achieving goal", (Object)maxIterations);
        }
        if (!this$0.isGoalAchieved($processContext, goalOutputType) && this$0.canExecuteGoalAction($processContext)) {
            this$0.getLogger().info("Goal action inputs available, executing goal action: {}", (Object)this$0.goalAction.shortName());
            this$0.executeGoalAction($processContext);
        }
        if (goalOutputType != null) {
            Object goalOutput;
            block10: {
                Object v2;
                Map<String, Object> blackboardModel = $processContext.getBlackboard().expressionEvaluationModel();
                Iterable iterable = blackboardModel.values();
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t;
                    Object value = t = iterator.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)value.getClass().getName(), (Object)goalOutputType)) continue;
                    v2 = t;
                    break block10;
                }
                v2 = goalOutput = null;
            }
            if (goalOutput != null) {
                this$0.getLogger().info("Goal output found on blackboard: {}", goalOutput);
                IoBinding ioBinding2 = (IoBinding)CollectionsKt.firstOrNull((Iterable)this$0.getOutputs());
                String string2 = ioBinding2 != null ? ioBinding2.unbox-impl() : null;
                if (string2 == null || (string2 = IoBinding.getName-impl(string2)) == null) {
                    string2 = "it";
                }
                String outputBinding = string2;
                $processContext.getBlackboard().set(outputBinding, goalOutput);
            } else {
                this$0.getLogger().warn("Goal output type {} not found on blackboard after orchestration", (Object)goalOutputType);
            }
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence buildSupervisorPrompt$lambda$8(Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return "- " + TypeSchemaExtractor.buildActionSignature(action);
    }
}

