/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.annotation.support;

import com.embabel.agent.api.annotation.Action;
import com.embabel.agent.api.annotation.support.ActionMethodArgumentResolver;
import com.embabel.agent.api.annotation.support.ActionMethodManager;
import com.embabel.agent.api.annotation.support.ActionMethodManagerKt;
import com.embabel.agent.api.annotation.support.DuplicateParameterTypeExceptionKt;
import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.api.common.Transformation;
import com.embabel.agent.api.common.TransformationActionContext;
import com.embabel.agent.api.common.support.MultiTransformationAction;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.IoBinding;
import com.embabel.agent.core.ReplanRequestedException;
import com.embabel.agent.core.ToolGroupRequirement;
import com.embabel.plan.WorldState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u001c\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002JA\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJI\u0010\u001d\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\f\u001a\u00020\r2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u00012\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0002\u00a2\u0006\u0002\u0010!J=\u0010\"\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00012\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0002\u00a2\u0006\u0002\u0010#J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006+"}, d2={"Lcom/embabel/agent/api/annotation/support/StateActionMethodManager;", "", "actionMethodManager", "Lcom/embabel/agent/api/annotation/support/ActionMethodManager;", "<init>", "(Lcom/embabel/agent/api/annotation/support/ActionMethodManager;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "createAction", "Lcom/embabel/agent/core/Action;", "method", "Ljava/lang/reflect/Method;", "stateClass", "Ljava/lang/Class;", "resolveInputBindings", "", "Lcom/embabel/agent/core/IoBinding;", "javaMethod", "resolveStateInstance", "context", "Lcom/embabel/agent/api/common/OperationContext;", "invokeStateActionMethod", "O", "actionContext", "Lcom/embabel/agent/api/common/TransformationActionContext;", "", "(Ljava/lang/reflect/Method;Ljava/lang/Class;Lcom/embabel/agent/api/common/TransformationActionContext;)Ljava/lang/Object;", "invokeStateActionMethodKotlinReflect", "kFunction", "Lkotlin/reflect/KFunction;", "stateInstance", "(Ljava/lang/reflect/Method;Lkotlin/reflect/KFunction;Ljava/lang/Object;Lcom/embabel/agent/api/common/TransformationActionContext;)Ljava/lang/Object;", "invokeStateActionMethodJavaReflect", "(Ljava/lang/reflect/Method;Ljava/lang/Object;Lcom/embabel/agent/api/common/TransformationActionContext;)Ljava/lang/Object;", "handleThrowable", "", "instanceName", "", "methodName", "t", "", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nStateActionMethodManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateActionMethodManager.kt\ncom/embabel/agent/api/annotation/support/StateActionMethodManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n11158#2:249\n11493#2,3:250\n1#3:253\n*S KotlinDebug\n*F\n+ 1 StateActionMethodManager.kt\ncom/embabel/agent/api/annotation/support/StateActionMethodManager\n*L\n53#1:249\n53#1:250,3\n*E\n"})
public final class StateActionMethodManager {
    @NotNull
    private final ActionMethodManager actionMethodManager;
    private final Logger logger;

    public StateActionMethodManager(@NotNull ActionMethodManager actionMethodManager) {
        Intrinsics.checkNotNullParameter((Object)actionMethodManager, (String)"actionMethodManager");
        this.actionMethodManager = actionMethodManager;
        this.logger = LoggerFactory.getLogger(StateActionMethodManager.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final com.embabel.agent.core.Action createAction(@NotNull Method method, @NotNull Class<?> stateClass) {
        CharSequence charSequence;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(stateClass, (String)"stateClass");
        DuplicateParameterTypeExceptionKt.requireNonAmbiguousParameters(method);
        Action actionAnnotation = method.getAnnotation(Action.class);
        Parameter[] parameterArray = method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
        Object[] $this$map$iv = parameterArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (Parameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        List inputClasses = (List)destination$iv$iv;
        Set<IoBinding> inputs = this.resolveInputBindings(method);
        String string = stateClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String stateInput = IoBinding.constructor-impl("it", string);
        Set allInputs = SetsKt.plus(inputs, (Object)IoBinding.box-impl(stateInput));
        if (!(method.getReturnType() != null)) {
            boolean bl = false;
            String string2 = "Action method " + method.getName() + " must have a return type";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = stateClass.getSimpleName() + "." + method.getName();
        CharSequence charSequence2 = actionAnnotation.description();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = method.getName();
        } else {
            charSequence = charSequence2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ifBlank(...)");
        String string4 = (String)charSequence;
        Set set = CollectionsKt.toSet((Iterable)allInputs);
        boolean bl = actionAnnotation.canRerun();
        Intrinsics.checkNotNull((Object)actionAnnotation);
        boolean bl2 = ActionMethodManagerKt.computeClearBlackboard(method, actionAnnotation);
        object = CollectionsKt.plus((Collection)ArraysKt.toList((Object[])actionAnnotation.pre()), (Iterable)ActionMethodManagerKt.computeTriggerPreconditions(method));
        List list = ArraysKt.toList((Object[])actionAnnotation.post());
        List list2 = CollectionsKt.plus((Collection)inputClasses, stateClass);
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
        Class<?> clazz2 = clazz;
        String string5 = actionAnnotation.outputBinding();
        Set<ToolGroupRequirement> set2 = ActionMethodManagerKt.computeToolGroups(actionAnnotation);
        Transformation transformation2 = new Transformation(this, method, stateClass){
            final /* synthetic */ StateActionMethodManager this$0;
            final /* synthetic */ Method $method;
            final /* synthetic */ Class<?> $stateClass;
            {
                this.this$0 = $receiver;
                this.$method = $method;
                this.$stateClass = $stateClass;
            }

            public final Object transform(TransformationActionContext<List<Object>, ? extends Object> context) {
                Intrinsics.checkNotNullParameter(context, (String)"context");
                return StateActionMethodManager.access$invokeStateActionMethod(this.this$0, this.$method, this.$stateClass, context);
            }
        };
        return new MultiTransformationAction(string3, string4, (List)object, list, arg_0 -> StateActionMethodManager.createAction$lambda$3(actionAnnotation, arg_0), null, bl, bl2, null, set, list2, clazz2, string5, null, set2, transformation2, 8480, null);
    }

    private final Set<IoBinding> resolveInputBindings(Method javaMethod) {
        Set result = new LinkedHashSet();
        KFunction kotlinFunction = KotlinDetector.isKotlinReflectPresent() ? ReflectJvmMapping.getKotlinFunction((Method)javaMethod) : null;
        int n = javaMethod.getParameters().length;
        block0: for (int i = 0; i < n; ++i) {
            Parameter javaParameter = javaMethod.getParameters()[i];
            Object object = kotlinFunction;
            KParameter kotlinParameter = object != null && (object = KCallables.getValueParameters((KCallable)((KCallable)object))) != null ? (KParameter)CollectionsKt.getOrNull((List)object, (int)i) : null;
            for (ActionMethodArgumentResolver argumentResolver : this.actionMethodManager.getArgumentResolvers()) {
                Intrinsics.checkNotNull((Object)javaParameter);
                if (!argumentResolver.supportsParameter(javaParameter, kotlinParameter, null)) continue;
                CollectionsKt.addAll((Collection)result, (Iterable)argumentResolver.resolveInputBinding(javaParameter, kotlinParameter));
                continue block0;
            }
        }
        return result;
    }

    private final Object resolveStateInstance(OperationContext context, Class<?> stateClass) {
        AgentProcess agentProcess = context.getProcessContext().getAgentProcess();
        String string = stateClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object object = agentProcess.getValue("it", string);
        if (object == null) {
            throw new IllegalStateException("State instance of type " + stateClass.getName() + " not found in blackboard");
        }
        return object;
    }

    private final <O> O invokeStateActionMethod(Method method, Class<?> stateClass, TransformationActionContext<List<Object>, O> actionContext) {
        O o;
        Method actualMethod;
        this.logger.debug("Invoking state action method {}.{}", (Object)stateClass.getSimpleName(), (Object)method.getName());
        Object stateInstance = this.resolveStateInstance(actionContext, stateClass);
        if (Intrinsics.areEqual(stateInstance.getClass(), stateClass)) {
            v0 = method;
        } else {
            this.logger.debug("State class mismatch: expected {} but got {}. Re-looking up method.", (Object)stateClass.getName(), (Object)stateInstance.getClass().getName());
            Class<?>[] classArray = method.getParameterTypes();
            v0 = actualMethod = stateInstance.getClass().getMethod(method.getName(), Arrays.copyOf(classArray, classArray.length));
        }
        if (KotlinDetector.isKotlinReflectPresent()) {
            Intrinsics.checkNotNull((Object)actualMethod);
            KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)actualMethod);
            o = kFunction != null ? this.invokeStateActionMethodKotlinReflect(actualMethod, kFunction, stateInstance, actionContext) : this.invokeStateActionMethodJavaReflect(actualMethod, stateInstance, actionContext);
        } else {
            Intrinsics.checkNotNull((Object)actualMethod);
            o = this.invokeStateActionMethodJavaReflect(actualMethod, stateInstance, actionContext);
        }
        O result = o;
        Object[] objectArray = new Object[]{stateClass.getSimpleName(), method.getName(), result};
        this.logger.debug("Result of invoking state action method {}.{} was {}", objectArray);
        return result;
    }

    private final <O> O invokeStateActionMethodKotlinReflect(Method method, KFunction<?> kFunction, Object stateInstance, TransformationActionContext<List<Object>, O> actionContext) {
        Object object;
        Object[] args = new Object[method.getParameters().length + 1];
        args[0] = stateInstance;
        int n = method.getParameters().length;
        for (int i = 0; i < n; ++i) {
            KClassifier classifier;
            Parameter javaParameter = method.getParameters()[i];
            KParameter kotlinParameter = (KParameter)CollectionsKt.getOrNull((List)KCallables.getValueParameters((KCallable)((KCallable)kFunction)), (int)i);
            KParameter kParameter = kotlinParameter;
            KClassifier kClassifier = kParameter != null && (kParameter = kParameter.getType()) != null ? kParameter.getClassifier() : (classifier = null);
            if (!(classifier instanceof KClass)) continue;
            for (ActionMethodArgumentResolver argumentResolver : this.actionMethodManager.getArgumentResolvers()) {
                Intrinsics.checkNotNull((Object)javaParameter);
                if (!argumentResolver.supportsParameter(javaParameter, kotlinParameter, actionContext)) continue;
                Object arg = argumentResolver.resolveArgument(javaParameter, kotlinParameter, actionContext);
                if (arg == null) {
                    boolean isNullable;
                    boolean bl = isNullable = kotlinParameter.isOptional() || kotlinParameter.getType().isMarkedNullable();
                    if (!isNullable) {
                        throw new IllegalStateException(("Action " + actionContext.getAction().getName() + ": No value found for non-nullable parameter " + kotlinParameter.getName() + ":" + JvmClassMappingKt.getJavaClass((KClass)((KClass)classifier)).getName()).toString());
                    }
                }
                args[i + 1] = arg;
            }
        }
        try {
            try {
                KCallablesJvm.setAccessible((KCallable)((KCallable)kFunction), (boolean)true);
                object = kFunction.call(Arrays.copyOf(args, args.length));
            }
            catch (InvocationTargetException ite) {
                ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ite);
                object = Unit.INSTANCE;
            }
        }
        catch (Throwable t) {
            String string = stateInstance.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.handleThrowable(string, kFunction.getName(), t);
            object = Unit.INSTANCE;
        }
        Unit result = object;
        return (O)result;
    }

    private final <O> O invokeStateActionMethodJavaReflect(Method method, Object stateInstance, TransformationActionContext<List<Object>, O> actionContext) {
        Object object;
        Object[] args = new Object[method.getParameters().length];
        int n = method.getParameters().length;
        for (int i = 0; i < n; ++i) {
            Parameter parameter = method.getParameters()[i];
            for (ActionMethodArgumentResolver argumentResolver : this.actionMethodManager.getArgumentResolvers()) {
                Object arg;
                Intrinsics.checkNotNull((Object)parameter);
                if (!argumentResolver.supportsParameter(parameter, null, actionContext)) continue;
                args[i] = arg = argumentResolver.resolveArgument(parameter, null, actionContext);
            }
        }
        try {
            method.trySetAccessible();
            object = ReflectionUtils.invokeMethod((Method)method, (Object)stateInstance, (Object[])Arrays.copyOf(args, args.length));
        }
        catch (Throwable t) {
            String string = stateInstance.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            this.handleThrowable(string, string2, t);
            object = Unit.INSTANCE;
        }
        Object result = object;
        return (O)result;
    }

    private final void handleThrowable(String instanceName, String methodName, Throwable t) {
        if (t instanceof ReplanRequestedException) {
            throw t;
        }
        Object[] objectArray = new Object[]{instanceName, methodName, t.getMessage()};
        this.logger.warn("Error invoking state action method {}.{}: {}", objectArray);
        throw t;
    }

    private static final double createAction$lambda$3(Action $actionAnnotation, WorldState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $actionAnnotation.cost();
    }

    public static final /* synthetic */ Object access$invokeStateActionMethod(StateActionMethodManager $this, Method method, Class stateClass, TransformationActionContext actionContext) {
        return $this.invokeStateActionMethod(method, stateClass, actionContext);
    }
}

