/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.web.rest;

import com.embabel.agent.core.Action;
import com.embabel.agent.core.ActionMetadata;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentMetadata;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.Condition;
import com.embabel.agent.core.ConditionMetadata;
import com.embabel.agent.core.DomainType;
import com.embabel.agent.core.Goal;
import com.embabel.agent.core.ToolGroupMetadata;
import com.embabel.agent.web.rest.PlatformInfoSummary;
import com.embabel.common.ai.model.ModelMetadata;
import com.embabel.common.ai.model.ModelProvider;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/platform-info"})
@Tag(name="Platform Information", description="Endpoints for retrieving platform, agents, goals, actions, and conditions information.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0017J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0017J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\tH\u0017J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/web/rest/PlatformInfoController;", "", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "modelProvider", "Lcom/embabel/common/ai/model/ModelProvider;", "<init>", "(Lcom/embabel/agent/core/AgentPlatform;Lcom/embabel/common/ai/model/ModelProvider;)V", "getAgents", "", "Lcom/embabel/agent/core/AgentMetadata;", "getGoals", "", "Lcom/embabel/agent/core/Goal;", "getActions", "Lcom/embabel/agent/core/ActionMetadata;", "getPlatformInfo", "Lcom/embabel/agent/web/rest/PlatformInfoSummary;", "getConditions", "Lcom/embabel/agent/core/ConditionMetadata;", "getModels", "Lcom/embabel/common/ai/model/ModelMetadata;", "getToolGroups", "Lcom/embabel/agent/core/ToolGroupMetadata;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nPlatformInfoController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformInfoController.kt\ncom/embabel/agent/web/rest/PlatformInfoController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1557#2:185\n1628#2,3:186\n1053#2:189\n1557#2:190\n1628#2,3:191\n1053#2:194\n1557#2:195\n1628#2,3:196\n1557#2:199\n1628#2,3:200\n1053#2:203\n1557#2:204\n1628#2,3:205\n1053#2:208\n*S KotlinDebug\n*F\n+ 1 PlatformInfoController.kt\ncom/embabel/agent/web/rest/PlatformInfoController\n*L\n58#1:185\n58#1:186,3\n58#1:189\n92#1:190\n92#1:191,3\n92#1:194\n111#1:195\n111#1:196,3\n116#1:199\n116#1:200,3\n117#1:203\n137#1:204\n137#1:205,3\n154#1:208\n*E\n"})
public class PlatformInfoController {
    @NotNull
    private final AgentPlatform agentPlatform;
    @NotNull
    private final ModelProvider modelProvider;

    public PlatformInfoController(@NotNull AgentPlatform agentPlatform, @NotNull ModelProvider modelProvider) {
        Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
        Intrinsics.checkNotNullParameter((Object)modelProvider, (String)"modelProvider");
        this.agentPlatform = agentPlatform;
        this.modelProvider = modelProvider;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/agents"})
    @Operation(summary="Get all agents", description="Returns a list of all agents deployed on the platform.")
    @ApiResponses(value={@ApiResponse(description="List of agents returned successfully", responseCode="200")})
    @NotNull
    public List<AgentMetadata> getAgents() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.agentPlatform.agents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Agent agent = (Agent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AgentMetadata((Agent)it));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AgentMetadata it = (AgentMetadata)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (AgentMetadata)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @GetMapping(value={"/goals"})
    @Operation(summary="Get all goals", description="Returns a list of all goals known to the platform (across all agents).")
    @ApiResponses(value={@ApiResponse(description="List of goals returned successfully", responseCode="200")})
    @NotNull
    public Set<Goal> getGoals() {
        return this.agentPlatform.getGoals();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/actions"})
    @Operation(summary="Get all actions", description="Returns a list of all actions available on the platform (across all agents).")
    @ApiResponses(value={@ApiResponse(description="List of actions returned successfully", responseCode="200")})
    @NotNull
    public List<ActionMetadata> getActions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.agentPlatform.getActions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ActionMetadata((Action)it));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ActionMetadata it = (ActionMetadata)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ActionMetadata)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @GetMapping(value={""})
    @Operation(summary="Get platform information", description="Returns general platform information, including the number of agents, actions, goals, and conditions.")
    @ApiResponses(value={@ApiResponse(description="Platform information returned successfully", responseCode="200")})
    @NotNull
    public PlatformInfoSummary getPlatformInfo() {
        Collection<String> collection;
        DomainType it;
        Collection<String> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.agentPlatform.agents();
        int n = this.agentPlatform.agents().size();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Agent agent = (Agent)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((Agent)((Object)it)).getName());
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = this.agentPlatform.getDomainTypes();
        String string = this.agentPlatform.getName();
        int n2 = this.agentPlatform.getConditions().size();
        int n3 = this.agentPlatform.getGoals().size();
        int n4 = this.agentPlatform.getActions().size();
        collection2 = CollectionsKt.toSet((Iterable)collection2);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DomainType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = this.modelProvider.listModels();
        boolean $i$f$sortedBy = false;
        List<ToolGroupMetadata> list = this.agentPlatform.getToolGroupResolver().availableToolGroups();
        List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModelMetadata it = (ModelMetadata)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ModelMetadata)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        Set set = CollectionsKt.toSet((Iterable)collection);
        String string2 = string;
        int n5 = n2;
        int n6 = n3;
        int n7 = n4;
        Collection<String> collection3 = collection2;
        int n8 = n;
        return new PlatformInfoSummary(n8, (Set<String>)collection3, n7, n6, n5, string2, set, list2, (List<? extends ToolGroupMetadata>)list);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/conditions"})
    @Operation(summary="Get all conditions", description="Returns a list of all conditions available on the platform (across all agents).")
    @ApiResponses(value={@ApiResponse(description="List of conditions returned successfully", responseCode="200")})
    @NotNull
    public Set<ConditionMetadata> getConditions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.agentPlatform.getConditions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Condition condition2 = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ConditionMetadata.Companion.invoke(it.getName(), it.getCost()));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @GetMapping(value={"/models"})
    @Operation(summary="Get all models", description="Returns a list of all models available on the platform (across all agents).")
    @ApiResponses(value={@ApiResponse(description="List of conditions returned successfully", responseCode="200")})
    @NotNull
    public List<ModelMetadata> getModels() {
        Iterable $this$sortedBy$iv = this.modelProvider.listModels();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModelMetadata it = (ModelMetadata)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ModelMetadata)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @GetMapping(value={"/tool-groups"})
    @Operation(summary="Get all tools", description="Returns a list of all tool groups available on the platform (across all agents).")
    @ApiResponses(value={@ApiResponse(description="List of conditions returned successfully", responseCode="200")})
    @NotNull
    public List<ToolGroupMetadata> getToolGroups() {
        return this.agentPlatform.getToolGroupResolver().availableToolGroups();
    }
}

