/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.common.util.StringTransformer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/embabel/agent/spi/support/OutputTransformingToolCallback;", "Lorg/springframework/ai/tool/ToolCallback;", "delegate", "outputTransformer", "Lcom/embabel/common/util/StringTransformer;", "<init>", "(Lorg/springframework/ai/tool/ToolCallback;Lcom/embabel/common/util/StringTransformer;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "getToolDefinition", "Lorg/springframework/ai/tool/definition/ToolDefinition;", "call", "", "toolInput", "embabel-agent-api"})
public final class OutputTransformingToolCallback
implements ToolCallback {
    @NotNull
    private final ToolCallback delegate;
    @NotNull
    private final StringTransformer outputTransformer;
    private final Logger logger;

    public OutputTransformingToolCallback(@NotNull ToolCallback delegate, @NotNull StringTransformer outputTransformer) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)outputTransformer, (String)"outputTransformer");
        this.delegate = delegate;
        this.outputTransformer = outputTransformer;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public ToolDefinition getToolDefinition() {
        ToolDefinition toolDefinition = this.delegate.getToolDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)toolDefinition, (String)"getToolDefinition(...)");
        return toolDefinition;
    }

    @NotNull
    public String call(@NotNull String toolInput) {
        Intrinsics.checkNotNullParameter((Object)toolInput, (String)"toolInput");
        String string = this.delegate.call(toolInput);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"call(...)");
        String rawOutput = string;
        String transformed = this.outputTransformer.transform(rawOutput);
        Object[] objectArray = new Object[]{this.delegate.getToolDefinition().name(), toolInput, rawOutput, transformed};
        this.logger.debug("Tool {} called with input: {}, raw output: {}, transformed output: {}", objectArray);
        int saving = rawOutput.length() - transformed.length();
        this.logger.debug("Saved {} bytes from {}", (Object)saving, (Object)rawOutput.length());
        return transformed;
    }
}

