/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.tool.SimpleInputSchema;
import com.embabel.agent.api.tool.Tool;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00112\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00030\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010#\u001a\u0004\u0018\u00010\u00032\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00030\"H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u00020\u00192\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lcom/embabel/agent/api/tool/MethodTool;", "Lcom/embabel/agent/api/tool/Tool;", "instance", "", "method", "Lkotlin/reflect/KFunction;", "annotation", "Lcom/embabel/agent/api/annotation/LlmTool;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/lang/Object;Lkotlin/reflect/KFunction;Lcom/embabel/agent/api/annotation/LlmTool;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "", "createDefinition", "mapKotlinTypeToParameterType", "Lcom/embabel/agent/api/tool/Tool$ParameterType;", "type", "Lkotlin/reflect/KType;", "parseArguments", "", "invokeMethod", "args", "convertToExpectedType", "value", "param", "Lkotlin/reflect/KParameter;", "convertResult", "result", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tool.kt\ncom/embabel/agent/api/tool/MethodTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,697:1\n1#2:698\n774#3:699\n865#3,2:700\n1557#3:702\n1628#3,2:703\n295#3,2:706\n1630#3:708\n20#4:705\n*S KotlinDebug\n*F\n+ 1 Tool.kt\ncom/embabel/agent/api/tool/MethodTool\n*L\n563#1:699\n563#1:700,2\n564#1:702\n564#1:703,2\n565#1:706,2\n564#1:708\n565#1:705\n*E\n"})
final class MethodTool
implements Tool {
    @NotNull
    private final Object instance;
    @NotNull
    private final KFunction<?> method;
    @NotNull
    private final ObjectMapper objectMapper;
    private final Logger logger;
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;

    public MethodTool(@NotNull Object instance, @NotNull KFunction<?> method, @NotNull LlmTool annotation, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter(method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.instance = instance;
        this.method = method;
        this.objectMapper = objectMapper;
        this.logger = LoggerFactory.getLogger(MethodTool.class);
        this.definition = this.createDefinition(this.method, annotation);
        this.metadata = Tool.Metadata.Companion.invoke$default(Tool.Metadata.Companion, annotation.returnDirect(), null, 2, null);
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Tool.Result result;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            Map<String, Object> args = this.parseArguments(input);
            Object result2 = this.invokeMethod(args);
            result = this.convertResult(result2);
        }
        catch (Exception e) {
            Throwable actualCause;
            String string;
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            if ((string = (actualCause = throwable).getMessage()) == null && (string = e.getMessage()) == null) {
                string = "Tool invocation failed";
            }
            String message = string;
            Object[] objectArray = new Object[]{this.getDefinition().getName(), message, actualCause};
            this.logger.error("Error invoking tool '{}': {}", objectArray);
            result = Tool.Result.Companion.error(message, actualCause);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Tool.Definition createDefinition(KFunction<?> method, LlmTool annotation) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KParameter it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        CharSequence charSequence;
        CharSequence charSequence2 = annotation.name();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = method.getName();
        } else {
            charSequence = charSequence2;
        }
        String name = (String)charSequence;
        Iterable bl = method.getParameters();
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KParameter)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getKind() == KParameter.Kind.VALUE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object v1;
            void param;
            Collection collection;
            block7: {
                it = (KParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)param;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv;
                    boolean bl4 = false;
                    if (!(it$iv instanceof LlmTool.Param)) continue;
                    v1 = element$iv$iv;
                    break block7;
                }
                v1 = null;
            }
            LlmTool.Param paramAnnotation = (LlmTool.Param)((Annotation)v1);
            Object object = param.getName();
            if (object == null) {
                object = "arg" + param.getIndex();
            }
            Tool.ParameterType parameterType = this.mapKotlinTypeToParameterType(param.getType());
            Object object2 = paramAnnotation;
            if (object2 == null || (object2 = object2.description()) == null) {
                object2 = "";
            }
            LlmTool.Param param2 = paramAnnotation;
            collection.add(new Tool.Parameter((String)object, parameterType, (String)object2, param2 != null ? param2.required() : !param.isOptional(), null, 16, null));
        }
        List parameters = (List)destination$iv$iv;
        return Tool.Definition.Companion.invoke(name, annotation.description(), new SimpleInputSchema(parameters));
    }

    private final Tool.ParameterType mapKotlinTypeToParameterType(KType type2) {
        KClassifier classifier = type2.getClassifier();
        return Intrinsics.areEqual((Object)classifier, (Object)Reflection.getOrCreateKotlinClass(String.class)) ? Tool.ParameterType.STRING : (Intrinsics.areEqual((Object)classifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) || Intrinsics.areEqual((Object)classifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)) ? Tool.ParameterType.INTEGER : (Intrinsics.areEqual((Object)classifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)) || Intrinsics.areEqual((Object)classifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) ? Tool.ParameterType.NUMBER : (Intrinsics.areEqual((Object)classifier, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)) ? Tool.ParameterType.BOOLEAN : (Intrinsics.areEqual((Object)classifier, (Object)Reflection.getOrCreateKotlinClass(List.class)) || Intrinsics.areEqual((Object)classifier, (Object)Reflection.getOrCreateKotlinClass(Object[].class)) ? Tool.ParameterType.ARRAY : Tool.ParameterType.OBJECT))));
    }

    private final Map<String, Object> parseArguments(String input) {
        Map map;
        if (StringsKt.isBlank((CharSequence)input)) {
            return MapsKt.emptyMap();
        }
        try {
            Object object = this.objectMapper.readValue(input, Map.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            map = (Map)object;
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse tool input as JSON: {}", (Object)e.getMessage());
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final Object invokeMethod(Map<String, ? extends Object> args) {
        Map callArgs;
        block6: {
            List params = this.method.getParameters();
            callArgs = new LinkedHashMap();
            for (KParameter param : params) {
                switch (WhenMappings.$EnumSwitchMapping$0[param.getKind().ordinal()]) {
                    case 1: {
                        callArgs.put(param, this.instance);
                        break;
                    }
                    case 2: {
                        String paramName;
                        if (param.getName() == null) break;
                        Object value = args.get(paramName);
                        if (value != null) {
                            Object convertedValue = this.convertToExpectedType(value, param);
                            callArgs.put(param, convertedValue);
                            break;
                        }
                        if (param.isOptional() || !param.getType().isMarkedNullable()) break;
                        callArgs.put(param, null);
                    }
                }
            }
            Method method = ReflectJvmMapping.getJavaMethod(this.method);
            if (method == null) break block6;
            method.setAccessible(true);
        }
        return this.method.callBy(callArgs);
    }

    private final Object convertToExpectedType(Object value, KParameter param) {
        Object object;
        Type targetType = ReflectJvmMapping.getJavaType((KType)param.getType());
        if (targetType instanceof Class && ((Class)targetType).isInstance(value)) {
            return value;
        }
        if (Intrinsics.areEqual((Object)targetType, Integer.TYPE) || Intrinsics.areEqual((Object)targetType, Integer.class)) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            object = number != null ? Integer.valueOf(number.intValue()) : value;
        } else if (Intrinsics.areEqual((Object)targetType, Long.TYPE) || Intrinsics.areEqual((Object)targetType, Long.class)) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            object = number != null ? Long.valueOf(number.longValue()) : value;
        } else if (Intrinsics.areEqual((Object)targetType, Double.TYPE) || Intrinsics.areEqual((Object)targetType, Double.class)) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            object = number != null ? Double.valueOf(number.doubleValue()) : value;
        } else if (Intrinsics.areEqual((Object)targetType, Float.TYPE) || Intrinsics.areEqual((Object)targetType, Float.class)) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            object = number != null ? Float.valueOf(number.floatValue()) : value;
        } else if (Intrinsics.areEqual((Object)targetType, Boolean.TYPE) || Intrinsics.areEqual((Object)targetType, Boolean.class)) {
            Boolean bl = value instanceof Boolean ? (Boolean)value : null;
            object = bl != null ? bl : Boolean.parseBoolean(value.toString());
        } else if (Intrinsics.areEqual((Object)targetType, String.class)) {
            object = value.toString();
        } else {
            Object object2;
            try {
                object2 = this.objectMapper.convertValue(value, this.objectMapper.constructType(targetType));
                Intrinsics.checkNotNull((Object)object2);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{value, targetType, e.getMessage()};
                this.logger.warn("Failed to convert {} to {}: {}", objectArray);
                object2 = value;
            }
            object = object2;
        }
        return object;
    }

    private final Tool.Result convertResult(Object result) {
        Tool.Result result2;
        Object object = result;
        if (object == null) {
            result2 = Tool.Result.Companion.text("");
        } else if (object instanceof String) {
            result2 = Tool.Result.Companion.text((String)result);
        } else if (object instanceof Tool.Result) {
            result2 = (Tool.Result)result;
        } else {
            Tool.Result result3;
            try {
                String string = this.objectMapper.writeValueAsString(result);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                result3 = Tool.Result.Companion.text(string);
            }
            catch (Exception e) {
                result3 = Tool.Result.Companion.text(result.toString());
            }
            result2 = result3;
        }
        return result2;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KParameter.Kind.values().length];
            try {
                nArray[KParameter.Kind.INSTANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KParameter.Kind.VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

