/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.workflow.loop;

import com.embabel.common.core.types.Timed;
import com.embabel.common.core.types.Timestamped;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B!\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\r\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c2\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J)\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\"\u001a\u00020\u000eH\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/embabel/agent/api/common/workflow/loop/ResultHistory;", "RESULT", "", "Lcom/embabel/common/core/types/Timestamped;", "Lcom/embabel/common/core/types/Timed;", "_results", "", "timestamp", "Ljava/time/Instant;", "<init>", "(Ljava/util/List;Ljava/time/Instant;)V", "getTimestamp", "()Ljava/time/Instant;", "attemptCount", "", "runningTime", "Ljava/time/Duration;", "getRunningTime", "()Ljava/time/Duration;", "attempts", "", "lastAttempt", "()Ljava/lang/Object;", "recordResult", "", "result", "recordResult$embabel_agent_api", "(Ljava/lang/Object;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "embabel-agent-api"})
public final class ResultHistory<RESULT>
implements Timestamped,
Timed {
    @NotNull
    private final List<RESULT> _results;
    @NotNull
    private final Instant timestamp;

    public ResultHistory(@NotNull List<RESULT> _results, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter(_results, (String)"_results");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this._results = _results;
        this.timestamp = timestamp;
    }

    public /* synthetic */ ResultHistory(List list, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            instant = Instant.now();
        }
        this(list, instant);
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public final int attemptCount() {
        return this._results.size();
    }

    @NotNull
    public Duration getRunningTime() {
        Duration duration = Duration.between(this.getTimestamp(), Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    @NotNull
    public final List<RESULT> attempts() {
        return CollectionsKt.toList((Iterable)this._results);
    }

    @Nullable
    public final RESULT lastAttempt() {
        return (RESULT)CollectionsKt.lastOrNull(this._results);
    }

    public final void recordResult$embabel_agent_api(@NotNull RESULT result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        ((Collection)this._results).add(result);
    }

    private final List<RESULT> component1() {
        return this._results;
    }

    @NotNull
    public final Instant component2() {
        return this.timestamp;
    }

    @NotNull
    public final ResultHistory<RESULT> copy(@NotNull List<RESULT> _results, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter(_results, (String)"_results");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return new ResultHistory<RESULT>(_results, timestamp);
    }

    public static /* synthetic */ ResultHistory copy$default(ResultHistory resultHistory, List list, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            list = resultHistory._results;
        }
        if ((n & 2) != 0) {
            instant = resultHistory.timestamp;
        }
        return resultHistory.copy(list, instant);
    }

    @NotNull
    public String toString() {
        return "ResultHistory(_results=" + this._results + ", timestamp=" + this.timestamp + ")";
    }

    public int hashCode() {
        int result = ((Object)this._results).hashCode();
        result = result * 31 + this.timestamp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResultHistory)) {
            return false;
        }
        ResultHistory resultHistory = (ResultHistory)other;
        if (!Intrinsics.areEqual(this._results, resultHistory._results)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.timestamp, (Object)resultHistory.timestamp);
    }

    public ResultHistory() {
        this(null, null, 3, null);
    }
}

