/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.chat;

import com.embabel.chat.ContentPart;
import com.embabel.chat.ImagePart;
import com.embabel.chat.TextPart;
import com.embabel.chat.UserMessage;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/embabel/chat/UserMessageBuilder;", "", "<init>", "()V", "parts", "", "Lcom/embabel/chat/ContentPart;", "name", "", "text", "image", "mimeType", "data", "", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "build", "Lcom/embabel/chat/UserMessage;", "detectMimeType", "extension", "embabel-agent-api"})
public final class UserMessageBuilder {
    @NotNull
    private final List<ContentPart> parts = new ArrayList();
    @Nullable
    private String name;

    @NotNull
    public final UserMessageBuilder text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.parts.add(new TextPart(text));
        return this;
    }

    @NotNull
    public final UserMessageBuilder image(@NotNull String mimeType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.parts.add(new ImagePart(mimeType, data));
        return this;
    }

    @NotNull
    public final UserMessageBuilder image(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String mimeType = this.detectMimeType(FilesKt.getExtension((File)file));
        this.parts.add(new ImagePart(mimeType, FilesKt.readBytes((File)file)));
        return this;
    }

    @NotNull
    public final UserMessageBuilder image(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return this.image(file);
    }

    @NotNull
    public final UserMessageBuilder name(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        return this;
    }

    @NotNull
    public final UserMessage build() {
        return new UserMessage(CollectionsKt.toList((Iterable)this.parts), this.name, null, 4, null);
    }

    private final String detectMimeType(String extension) {
        String string = extension.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (string) {
            case "jpg", "jpeg" -> "image/jpeg";
            case "png" -> "image/png";
            case "gif" -> "image/gif";
            case "webp" -> "image/webp";
            case "bmp" -> "image/bmp";
            default -> throw new IllegalArgumentException("Unsupported image extension: " + extension);
        };
    }
}

