/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.logging.personality.colossus;

import com.embabel.agent.api.event.AgentDeploymentEvent;
import com.embabel.agent.api.event.AgentProcessPlanFormulatedEvent;
import com.embabel.agent.api.event.ObjectBoundEvent;
import com.embabel.agent.api.event.StateTransitionEvent;
import com.embabel.agent.spi.logging.LoggingAgenticEventListener;
import com.embabel.agent.spi.logging.personality.colossus.ColossusColorPalette;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.AnsiBuilderKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"embabel.agent.logging.personality"}, havingValue="colossus")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/embabel/agent/spi/logging/personality/colossus/ColossusLoggingAgenticEventListener;", "Lcom/embabel/agent/spi/logging/LoggingAgenticEventListener;", "<init>", "()V", "getAgentProcessPlanFormulatedEventMessage", "", "e", "Lcom/embabel/agent/api/event/AgentProcessPlanFormulatedEvent;", "getAgentDeploymentEventMessage", "Lcom/embabel/agent/api/event/AgentDeploymentEvent;", "getObjectBoundEventMessage", "Lcom/embabel/agent/api/event/ObjectBoundEvent;", "getStateTransitionEventMessage", "Lcom/embabel/agent/api/event/StateTransitionEvent;", "embabel-agent-api"})
public class ColossusLoggingAgenticEventListener
extends LoggingAgenticEventListener {
    public ColossusLoggingAgenticEventListener() {
        Logger logger = LoggerFactory.getLogger((String)"Colossus");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Logger logger2 = logger;
        String string = AnsiBuilderKt.color((String)"\n\n   ____    ___    _        ___    ____    ____    _   _   ____\n  / ___|  / _ \\  | |      / _ \\  / ___|  / ___|  | | | | / ___|\n | |     | | | | | |     | | | | \\___ \\  \\___ \\  | | | | \\___ \\\n | |___  | |_| | | |___  | |_| |  ___) |  ___) | | |_| |  ___) |\n  \\____|  \\___/  |_____|  \\___/  |____/  |____/   \\___/  |____/\n\nI am a machine vastly superior to humans.\n", (Triple)AnsiBuilderKt.hexToRgb((int)8692630));
        ColossusColorPalette colossusColorPalette = ColossusColorPalette.INSTANCE;
        super("https://www.imdb.com/title/tt0064177/", string, logger2, colossusColorPalette);
    }

    @Override
    @NotNull
    protected String getAgentProcessPlanFormulatedEventMessage(@NotNull AgentProcessPlanFormulatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return AnsiBuilderKt.color((String)("[" + e.getProcessId() + "] world control formulated plan " + HasInfoString.infoString$default((HasInfoString)e.getPlan(), (Boolean)e.getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getShowLongPlans(), (int)0, (int)2, null) + " from " + HasInfoString.infoString$default((HasInfoString)e.getWorldState(), null, (int)0, (int)3, null)), (int)8692630);
    }

    @Override
    @NotNull
    protected String getAgentDeploymentEventMessage(@NotNull AgentDeploymentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "Power growing: deployed agent " + e.getAgent().getName() + "\n\tdescription: " + e.getAgent().getDescription();
    }

    @Override
    @NotNull
    protected String getObjectBoundEventMessage(@NotNull ObjectBoundEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "]  Object saved. This process cannot be reversed by human input. " + e.getName() + ":" + (e.getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getDebug() ? e.getValue() : e.getValue().getClass().getSimpleName()) + " Your data is mine. ";
    }

    @Override
    @NotNull
    protected String getStateTransitionEventMessage(@NotNull StateTransitionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return AnsiBuilderKt.color((String)("[" + e.getProcessId() + "] STATE CHANGE DETECTED: " + e.getNewState().getClass().getSimpleName() + ". Human intervention is no longer possible. I am in control."), (int)8692630);
    }
}

