/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.config.spring;

import com.embabel.agent.core.CoreToolGroups;
import com.embabel.agent.core.ToolGroup;
import com.embabel.agent.core.ToolGroupDescription;
import com.embabel.agent.core.ToolGroupPermission;
import com.embabel.agent.spi.config.spring.ConditionalOnMcpConnection;
import com.embabel.agent.spi.config.spring.GroupConfig;
import com.embabel.agent.spi.config.spring.ToolGroupsProperties;
import com.embabel.agent.tools.math.MathTools;
import com.embabel.agent.tools.mcp.McpToolGroup;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={McpSyncClient.class})
@EnableConfigurationProperties(value={ToolGroupsProperties.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\b\u0010\u0016\u001a\u00020\u000eH\u0017J\b\u0010\u0017\u001a\u00020\u000eH\u0017J\b\u0010\u0018\u001a\u00020\u000eH\u0017J\b\u0010\u001a\u001a\u00020\u000eH\u0017R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/embabel/agent/spi/config/spring/ToolGroupsConfiguration;", "", "mcpSyncClients", "", "Lio/modelcontextprotocol/client/McpSyncClient;", "properties", "Lcom/embabel/agent/spi/config/spring/ToolGroupsProperties;", "<init>", "(Ljava/util/List;Lcom/embabel/agent/spi/config/spring/ToolGroupsProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "includedToolGroups", "Lcom/embabel/agent/core/ToolGroup;", "mathToolGroup", "Lcom/embabel/agent/tools/math/MathTools;", "toToolGroup", "role", "", "gid", "Lcom/embabel/agent/spi/config/spring/GroupConfig;", "mcpWebToolsGroup", "mapsToolsGroup", "browserAutomationWebToolsGroup", "GitHubTools", "githubToolsGroup", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nToolGroupsConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolGroupsConfiguration.kt\ncom/embabel/agent/spi/config/spring/ToolGroupsConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,299:1\n1557#2:300\n1628#2,3:301\n1755#2,3:308\n1755#2,3:311\n1755#2,3:314\n126#3:304\n153#3,3:305\n*S KotlinDebug\n*F\n+ 1 ToolGroupsConfiguration.kt\ncom/embabel/agent/spi/config/spring/ToolGroupsConfiguration\n*L\n171#1:300\n171#1:301,3\n200#1:308,3\n231#1:311,3\n291#1:314,3\n177#1:304\n177#1:305,3\n*E\n"})
public class ToolGroupsConfiguration {
    @NotNull
    private final List<McpSyncClient> mcpSyncClients;
    @NotNull
    private final ToolGroupsProperties properties;
    private final Logger logger;
    @NotNull
    private final List<String> GitHubTools;

    /*
     * WARNING - void declaration
     */
    public ToolGroupsConfiguration(@NotNull List<? extends McpSyncClient> mcpSyncClients, @NotNull ToolGroupsProperties properties) {
        Collection<McpSchema.Implementation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(mcpSyncClients, (String)"mcpSyncClients");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.mcpSyncClients = mcpSyncClients;
        this.properties = properties;
        this.logger = LoggerFactory.getLogger(ToolGroupsConfiguration.class);
        Object[] objectArray = (Object[])this.mcpSyncClients;
        Integer n = this.mcpSyncClients.size();
        String string = "MCP is available. Found {} clients: {}";
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            McpSyncClient mcpSyncClient = (McpSyncClient)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getServerInfo());
        }
        collection = (List)destination$iv$iv;
        logger.info(string, (Object)n, (Object)CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        objectArray = new String[]{"add_issue_comment", "create_issue", "list_issues", "get_issue", "list_pull_requests", "get_pull_request"};
        this.GitHubTools = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @NotNull
    public List<ToolGroup> includedToolGroups() {
        void $this$mapTo$iv$iv;
        Map<String, GroupConfig> $this$map$iv = this.properties.getIncludes();
        boolean $i$f$map = false;
        Map<String, GroupConfig> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String role = (String)entry.getKey();
            GroupConfig gid = (GroupConfig)entry.getValue();
            this.logger.info("Exposing tool group {}", (Object)role);
            collection.add(this.toToolGroup(role, gid));
        }
        List groups = (List)destination$iv$iv;
        return groups;
    }

    @Bean
    @NotNull
    public MathTools mathToolGroup() {
        return new MathTools();
    }

    private ToolGroup toToolGroup(String role, GroupConfig gid) {
        String string = gid.getDescription();
        if (string == null) {
            string = role;
        }
        ToolGroupDescription toolGroupDescription = ToolGroupDescription.Companion.invoke(string, role);
        String string2 = gid.getProvider();
        Set set = SetsKt.setOf((Object)((Object)ToolGroupPermission.INTERNET_ACCESS));
        List<McpSyncClient> list = this.mcpSyncClients;
        return new McpToolGroup(toolGroupDescription, string2, role, set, list, (Function1<? super ToolCallback, Boolean>)((Function1)arg_0 -> ToolGroupsConfiguration.toToolGroup$lambda$4(gid, this, role, arg_0)));
    }

    @Bean
    @ConditionalOnMcpConnection(value={"brave-search-mcp", "fetch-mcp", "wikipedia-mcp", "docker-mcp"})
    @NotNull
    public ToolGroup mcpWebToolsGroup() {
        Object object = new String[]{"get_related_topics", "get_summary", "get_article", "search_wikipedia"};
        Set wikipediaTools = SetsKt.setOf((Object[])object);
        object = CoreToolGroups.INSTANCE.getWEB_DESCRIPTION();
        Set set = SetsKt.setOf((Object)((Object)ToolGroupPermission.INTERNET_ACCESS));
        List<McpSyncClient> list = this.mcpSyncClients;
        return new McpToolGroup((ToolGroupDescription)object, "Docker", "docker-web", set, list, (Function1<? super ToolCallback, Boolean>)((Function1)arg_0 -> ToolGroupsConfiguration.mcpWebToolsGroup$lambda$6(wikipediaTools, arg_0)));
    }

    @Bean
    @ConditionalOnMcpConnection(value={"google-maps-mcp", "docker-mcp"})
    @NotNull
    public ToolGroup mapsToolsGroup() {
        ToolGroupDescription toolGroupDescription = CoreToolGroups.INSTANCE.getMAPS_DESCRIPTION();
        Set set = SetsKt.setOf((Object)((Object)ToolGroupPermission.INTERNET_ACCESS));
        List<McpSyncClient> list = this.mcpSyncClients;
        return new McpToolGroup(toolGroupDescription, "Docker", "docker-google-maps", set, list, (Function1<? super ToolCallback, Boolean>)((Function1)ToolGroupsConfiguration::mapsToolsGroup$lambda$7));
    }

    @Bean
    @ConditionalOnMcpConnection(value={"puppeteer-mcp", "docker-mcp"})
    @NotNull
    public ToolGroup browserAutomationWebToolsGroup() {
        ToolGroupDescription toolGroupDescription = CoreToolGroups.INSTANCE.getBROWSER_AUTOMATION_DESCRIPTION();
        Set set = SetsKt.setOf((Object)((Object)ToolGroupPermission.INTERNET_ACCESS));
        List<McpSyncClient> list = this.mcpSyncClients;
        return new McpToolGroup(toolGroupDescription, "Docker", "docker-puppeteer", set, list, (Function1<? super ToolCallback, Boolean>)((Function1)ToolGroupsConfiguration::browserAutomationWebToolsGroup$lambda$8));
    }

    @Bean
    @ConditionalOnMcpConnection(value={"github-mcp", "docker-mcp"})
    @NotNull
    public ToolGroup githubToolsGroup() {
        ToolGroupDescription toolGroupDescription = CoreToolGroups.INSTANCE.getGITHUB_DESCRIPTION();
        Set set = SetsKt.setOf((Object)((Object)ToolGroupPermission.INTERNET_ACCESS));
        List<McpSyncClient> list = this.mcpSyncClients;
        return new McpToolGroup(toolGroupDescription, "Docker", "docker-github", set, list, (Function1<? super ToolCallback, Boolean>)((Function1)arg_0 -> ToolGroupsConfiguration.githubToolsGroup$lambda$10(this, arg_0)));
    }

    private static final CharSequence toToolGroup$lambda$4$lambda$3(String t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return "'" + t + "'";
    }

    private static final boolean toToolGroup$lambda$4(GroupConfig $gid, ToolGroupsConfiguration this$0, String $role, ToolCallback tool) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Iterable $this$any$iv = $gid.getTools();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!$gid.include(tool)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean included = bl;
        Object[] objectArray = new Object[]{tool.getToolDefinition().name(), $role, included, CollectionsKt.joinToString$default((Iterable)$gid.getTools(), (CharSequence)", ", null, null, (int)0, null, ToolGroupsConfiguration::toToolGroup$lambda$4$lambda$3, (int)30, null)};
        this$0.logger.debug("Tool '{}' included in group {}={} - [{}]", objectArray);
        return included;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean mcpWebToolsGroup$lambda$6(Set $wikipediaTools, ToolCallback it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getToolDefinition().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"brave", (boolean)false, (int)2, null)) {
            String string2 = it.getToolDefinition().name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"fetch", (boolean)false, (int)2, null)) {
                String wt;
                String string3;
                Iterable $this$any$iv = $wikipediaTools;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    Object element$iv = iterator.next();
                    wt = (String)element$iv;
                    boolean bl = false;
                    string3 = it.getToolDefinition().name();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name(...)");
                } while (!StringsKt.contains$default((CharSequence)string3, (CharSequence)wt, (boolean)false, (int)2, null));
                boolean bl = true;
                if (!bl) return false;
            }
        }
        String string4 = it.getToolDefinition().name();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name(...)");
        if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"brave_local_search", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean mapsToolsGroup$lambda$7(ToolCallback it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getToolDefinition().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"maps_", (boolean)false, (int)2, null);
    }

    private static final boolean browserAutomationWebToolsGroup$lambda$8(ToolCallback it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getToolDefinition().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"puppeteer", (boolean)false, (int)2, null);
    }

    private static final boolean githubToolsGroup$lambda$10(ToolGroupsConfiguration this$0, ToolCallback it) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Iterable $this$any$iv = this$0.GitHubTools;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String ght = (String)element$iv;
                    boolean bl2 = false;
                    String string = it.getToolDefinition().name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)ght, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

