/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.reference;

import com.embabel.agent.api.common.LlmReference;
import com.embabel.agent.api.common.reference.LlmReferenceProvider;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/embabel/agent/api/common/reference/SpringResource;", "Lcom/embabel/agent/api/common/reference/LlmReferenceProvider;", "Lcom/embabel/agent/api/common/LlmReference;", "resourcePath", "", "name", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getResourcePath", "()Ljava/lang/String;", "getName", "getDescription", "reference", "notes", "equals", "", "other", "", "hashCode", "", "toString", "component1", "component2", "component3", "copy", "embabel-agent-api"})
public final class SpringResource
implements LlmReferenceProvider,
LlmReference {
    @JsonProperty(value="resourcePath")
    @NotNull
    private final String resourcePath;
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    @JsonCreator
    public SpringResource(@NotNull String resourcePath, @NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.resourcePath = resourcePath;
        this.name = name;
        this.description = description;
    }

    public /* synthetic */ SpringResource(String string, String string2, String object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        if ((n & 4) != 0) {
            object = "Spring resource at " + string;
        }
        this(string, string2, (String)object);
    }

    @NotNull
    public final String getResourcePath() {
        return this.resourcePath;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public LlmReference reference() {
        return this;
    }

    @Override
    @NotNull
    public String notes() {
        String string;
        try {
            Resource resource = new DefaultResourceLoader().getResource(this.resourcePath);
            Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"getResource(...)");
            Resource resource2 = resource;
            String string2 = resource2.getContentAsString(StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getContentAsString(...)");
            String content = string2;
            string = "Resource content:\n" + content;
        }
        catch (IOException e) {
            string = "Failed to read resource: " + e.getMessage();
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpringResource)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.resourcePath, (Object)((SpringResource)other).resourcePath) && Intrinsics.areEqual((Object)this.getDescription(), (Object)((SpringResource)other).getDescription());
    }

    public int hashCode() {
        int result = this.resourcePath.hashCode();
        result = 31 * result + this.getDescription().hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "SpringResource(resourcePath='" + this.resourcePath + "', description='" + this.getDescription() + "')";
    }

    @NotNull
    public final String component1() {
        return this.resourcePath;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.description;
    }

    @NotNull
    public final SpringResource copy(@NotNull String resourcePath, @NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new SpringResource(resourcePath, name, description);
    }

    public static /* synthetic */ SpringResource copy$default(SpringResource springResource, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = springResource.resourcePath;
        }
        if ((n & 2) != 0) {
            string2 = springResource.name;
        }
        if ((n & 4) != 0) {
            string3 = springResource.description;
        }
        return springResource.copy(string, string2, string3);
    }
}

