/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.config.spring.migration;

import com.embabel.agent.spi.config.spring.migration.DeprecatedPropertyScanningConfig;
import com.embabel.agent.spi.config.spring.migration.SimpleDeprecatedConfigWarner;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"embabel.agent.platform.migration.scanning.enabled"}, havingValue="true", matchIfMissing=false)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\b\u0017\u0018\u0000 72\u00020\u0001:\u000267B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0012J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0012J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0006H\u0012J#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0004H\u0012\u00a2\u0006\u0002\u0010!J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0012J \u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0006H\u0012J \u0010*\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0006H\u0012J \u0010+\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0006H\u0012J\u0010\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u0017H\u0012J \u0010/\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0006H\u0012J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0017H\u0012J\u0010\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0014H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u001405H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanner;", "Lorg/springframework/beans/factory/SmartInitializingSingleton;", "scanningConfigProvider", "Lorg/springframework/beans/factory/ObjectProvider;", "Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanningConfig;", "propertyWarnerProvider", "Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner;", "environment", "Lorg/springframework/core/env/Environment;", "<init>", "(Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/core/env/Environment;)V", "resourceResolver", "Lorg/springframework/core/io/support/PathMatchingResourcePatternResolver;", "metadataReaderFactory", "Lorg/springframework/core/type/classreading/CachingMetadataReaderFactory;", "init", "", "afterSingletonsInstantiated", "propertyMigrationRules", "", "Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanner$PropertyMigrationRule;", "exactPropertyMappings", "", "", "doScanning", "scanningConfig", "propertyWarner", "scanForDeprecatedConditionals", "scanEnvironmentPropertyUsage", "findClassesInPackage", "", "Lorg/springframework/core/io/Resource;", "packageName", "(Ljava/lang/String;Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanningConfig;)[Lorg/springframework/core/io/Resource;", "analyzeClassForDeprecatedConditionals", "", "metadataReader", "Lorg/springframework/core/type/classreading/MetadataReader;", "analyzeConditionalOnProperty", "className", "annotationMetadata", "Lorg/springframework/core/type/AnnotationMetadata;", "analyzeConfigurationProperties", "issueDeprecatedConfigurationPropertiesWarning", "prefix", "isDeprecatedProperty", "propertyName", "issueDeprecatedConditionalWarning", "getRecommendedProperty", "deprecatedProperty", "addMigrationRule", "rule", "getMigrationRules", "", "PropertyMigrationRule", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nDeprecatedPropertyScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedPropertyScanner.kt\ncom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,720:1\n774#2:721\n865#2,2:722\n1368#2:724\n1454#2,5:725\n1611#2,9:730\n1863#2:739\n1864#2:741\n1620#2:742\n1782#2,4:743\n1863#2,2:747\n827#2:757\n855#2,2:758\n1863#2,2:760\n1863#2,2:762\n1755#2,3:764\n1#3:740\n1#3:751\n4154#4:749\n4254#4:750\n4255#4:752\n37#5:753\n36#5,3:754\n*S KotlinDebug\n*F\n+ 1 DeprecatedPropertyScanner.kt\ncom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanner\n*L\n420#1:721\n420#1:722,2\n421#1:724\n421#1:725,5\n422#1:730,9\n422#1:739\n422#1:741\n422#1:742\n437#1:743,4\n456#1:747,2\n533#1:757\n533#1:758,2\n534#1:760,2\n592#1:762,2\n661#1:764,3\n422#1:740\n485#1:749\n485#1:750\n485#1:752\n491#1:753\n491#1:754,3\n*E\n"})
public class DeprecatedPropertyScanner
implements SmartInitializingSingleton {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectProvider<DeprecatedPropertyScanningConfig> scanningConfigProvider;
    @NotNull
    private final ObjectProvider<SimpleDeprecatedConfigWarner> propertyWarnerProvider;
    @NotNull
    private final Environment environment;
    @NotNull
    private final PathMatchingResourcePatternResolver resourceResolver;
    @NotNull
    private final CachingMetadataReaderFactory metadataReaderFactory;
    @NotNull
    private final List<PropertyMigrationRule> propertyMigrationRules;
    @NotNull
    private final Map<String, String> exactPropertyMappings;
    private static final Logger logger = LoggerFactory.getLogger(DeprecatedPropertyScanner.class);

    /*
     * WARNING - void declaration
     */
    public DeprecatedPropertyScanner(@NotNull ObjectProvider<DeprecatedPropertyScanningConfig> scanningConfigProvider, @NotNull ObjectProvider<SimpleDeprecatedConfigWarner> propertyWarnerProvider, @NotNull Environment environment) {
        void $this$exactPropertyMappings_u24lambda_u240;
        Map map;
        Intrinsics.checkNotNullParameter(scanningConfigProvider, (String)"scanningConfigProvider");
        Intrinsics.checkNotNullParameter(propertyWarnerProvider, (String)"propertyWarnerProvider");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.scanningConfigProvider = scanningConfigProvider;
        this.propertyWarnerProvider = propertyWarnerProvider;
        this.environment = environment;
        this.resourceResolver = new PathMatchingResourcePatternResolver();
        this.metadataReaderFactory = new CachingMetadataReaderFactory();
        this.propertyMigrationRules = new ArrayList();
        Map map2 = map = MapsKt.createMapBuilder();
        DeprecatedPropertyScanner deprecatedPropertyScanner = this;
        boolean bl = false;
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.ranking.max-attempts", "embabel.agent.platform.ranking.max-attempts");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.ranking.backoff-millis", "embabel.agent.platform.ranking.backoff-millis");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.ranking.backoff-multiplier", "embabel.agent.platform.ranking.backoff-multiplier");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.ranking.backoff-max-interval", "embabel.agent.platform.ranking.backoff-max-interval");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.llm-operations.prompts.template", "embabel.agent.platform.llm-operations.prompts.template");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.llm-operations.data-binding.max-attempts", "embabel.agent.platform.llm-operations.data-binding.max-attempts");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.llm-operations.data-binding.fixed-backoff-millis", "embabel.agent.platform.llm-operations.data-binding.fixed-backoff-millis");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.autonomy.agent-confidence-cut-off", "embabel.agent.platform.autonomy.agent-confidence-cut-off");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.autonomy.goal-confidence-cut-off", "embabel.agent.platform.autonomy.goal-confidence-cut-off");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.process-id-generation.include-version", "embabel.agent.platform.process-id-generation.include-version");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.process-id-generation.include-agent-name", "embabel.agent.platform.process-id-generation.include-agent-name");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations.data-binding.max-attempts", "embabel.agent.platform.llm-operations.data-binding.max-attempts");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations.data-binding.fixed-backoff-millis", "embabel.agent.platform.llm-operations.data-binding.fixed-backoff-millis");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations.prompts.template", "embabel.agent.platform.llm-operations.prompts.template");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations.prompts.maybe-prompt-template", "embabel.agent.platform.llm-operations.prompts.maybe-prompt-template");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations.prompts.generate-examples-by-default", "embabel.agent.platform.llm-operations.prompts.generate-examples-by-default");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations.prompts.default-timeout", "embabel.agent.platform.llm-operations.prompts.default-timeout");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.autonomy.agent-confidence-cut-off", "embabel.agent.platform.autonomy.agent-confidence-cut-off");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.autonomy.goal-confidence-cut-off", "embabel.agent.platform.autonomy.goal-confidence-cut-off");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.sse.max-buffer-size", "embabel.agent.platform.sse.max-buffer-size");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.sse.max-process-buffers", "embabel.agent.platform.sse.max-process-buffers");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.process-id-generation.include-version", "embabel.agent.platform.process-id-generation.include-version");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.process-id-generation.include-agent-name", "embabel.agent.platform.process-id-generation.include-agent-name");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.anthropic.max-attempts", "embabel.agent.platform.models.anthropic.max-attempts");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.anthropic.backoff-millis", "embabel.agent.platform.models.anthropic.backoff-millis");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.anthropic.backoff-multiplier", "embabel.agent.platform.models.anthropic.backoff-multiplier");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.anthropic.backoff-max-interval", "embabel.agent.platform.models.anthropic.backoff-max-interval");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.openai.max-attempts", "embabel.agent.platform.models.openai.max-attempts");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.openai.backoff-millis", "embabel.agent.platform.models.openai.backoff-millis");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.openai.backoff-multiplier", "embabel.agent.platform.models.openai.backoff-multiplier");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.openai.backoff-max-interval", "embabel.agent.platform.models.openai.backoff-max-interval");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.docker.models.max-attempts", "embabel.agent.platform.models.docker.max-attempts");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.docker.models.backoff-millis", "embabel.agent.platform.models.docker.backoff-millis");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.docker.models.backoff-multiplier", "embabel.agent.platform.models.docker.backoff-multiplier");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.docker.models.backoff-max-interval", "embabel.agent.platform.models.docker.backoff-max-interval");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.docker.models.base-url", "embabel.agent.models.docker.base-url");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.models.bedrock.models.name", "embabel.agent.models.bedrock.models.name");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.models.bedrock.models.knowledge-cutoff", "embabel.agent.models.bedrock.models.knowledge-cutoff");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.models.bedrock.models.input-price", "embabel.agent.models.bedrock.models.input-price");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.models.bedrock.models.output-price", "embabel.agent.models.bedrock.models.output-price");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.discord.token", "embabel.agent.discord.token");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.shell.line-length", "embabel.agent.shell.line-length");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.shell.chat.bind-conversation", "embabel.agent.shell.chat.bind-conversation");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.shell.chat.model", "embabel.agent.shell.chat.model");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.shell.chat.confirm-goals", "embabel.agent.shell.chat.confirm-goals");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.shell.chat.multi-goal", "embabel.agent.shell.chat.multi-goal");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.shell.chat.temperature", "embabel.agent.shell.chat.temperature");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent.enable-scanning", "embabel.agent.platform.scanning.annotation");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent.mock-mode", "embabel.agent.platform.test.mock-mode");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent.sse.max-buffer-size", "embabel.agent.platform.sse.max-buffer-size");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent.sse.max-process-buffers", "embabel.agent.platform.sse.max-process-buffers");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.anthropic", "embabel.agent.platform.models.anthropic");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.openai", "embabel.agent.platform.models.openai");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.docker.models", "embabel.agent.platform.models.docker");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.models.bedrock", "embabel.agent.models.bedrock");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations", "embabel.agent.platform.llm-operations");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations.data-binding", "embabel.agent.platform.llm-operations.data-binding");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.llm-operations.prompts", "embabel.agent.platform.llm-operations.prompts");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.autonomy", "embabel.agent.platform.autonomy");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.sse", "embabel.agent.platform.sse");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.process-id-generation", "embabel.agent.platform.process-id-generation");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.ranking", "embabel.agent.platform.ranking");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.agent-platform.scanning", "embabel.agent.platform.scanning");
        $this$exactPropertyMappings_u24lambda_u240.put("embabel.shell", "embabel.agent.shell");
        deprecatedPropertyScanner.exactPropertyMappings = MapsKt.build((Map)map);
    }

    @PostConstruct
    public void init() {
        logger.info("Deprecated property scanner initialized (warnings system active)");
    }

    public void afterSingletonsInstantiated() {
        logger.debug("afterSingletonsInstantiated() called");
        DeprecatedPropertyScanningConfig scanningConfig = (DeprecatedPropertyScanningConfig)this.scanningConfigProvider.getIfAvailable();
        SimpleDeprecatedConfigWarner propertyWarner = (SimpleDeprecatedConfigWarner)this.propertyWarnerProvider.getIfAvailable();
        logger.debug("scanningConfig available: " + (scanningConfig != null) + ", propertyWarner available: " + (propertyWarner != null));
        if (scanningConfig == null && propertyWarner == null) {
            logger.debug("Migration system completely disabled - both scanning config and property warner unavailable");
        } else if (scanningConfig == null) {
            logger.debug("DeprecatedPropertyScanningConfig not available - scanning disabled (Scenario 1/4: Iteration 0 default or warnings-only mode)");
        } else if (propertyWarner == null) {
            logger.debug("SimpleDeprecatedConfigWarner not available - cannot issue warnings (Scenario 2: Migration system disabled)");
        } else if (!scanningConfig.getEnabled()) {
            logger.debug("Conditional property scanning explicitly disabled via embabel.agent.platform.migration.scanning.enabled=false");
        } else {
            logger.info("All migration components available - starting conditional property scanning (Scenario 3: Full detection active)");
            this.doScanning(scanningConfig, propertyWarner);
            this.scanEnvironmentPropertyUsage(propertyWarner);
        }
    }

    private void doScanning(DeprecatedPropertyScanningConfig scanningConfig, SimpleDeprecatedConfigWarner propertyWarner) {
        block2: {
            Object object;
            logger.info("Scanning for deprecated conditional properties in packages: " + scanningConfig.getIncludePackages());
            Object object2 = this;
            try {
                DeprecatedPropertyScanner $this$doScanning_u24lambda_u241 = object2;
                boolean bl = false;
                $this$doScanning_u24lambda_u241.scanForDeprecatedConditionals(scanningConfig, propertyWarner);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object exception = object = throwable;
            boolean bl = false;
            logger.warn("Error during conditional property scanning: " + ((Throwable)exception).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scanForDeprecatedConditionals(DeprecatedPropertyScanningConfig scanningConfig, SimpleDeprecatedConfigWarner propertyWarner) {
        int n;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = scanningConfig.getIncludePackages();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!scanningConfig.shouldIncludePackage(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String packageName = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ArraysKt.asIterable((Object[])this.findClassesInPackage(packageName, scanningConfig));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Pair it$iv$iv;
            Object object;
            Object $this$scanForDeprecatedConditionals_u24lambda_u246_u24lambda_u244;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Resource resource = (Resource)element$iv$iv;
            boolean bl2 = false;
            Object object2 = this;
            try {
                MetadataReader metadataReader;
                $this$scanForDeprecatedConditionals_u24lambda_u246_u24lambda_u244 = object2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)((DeprecatedPropertyScanner)$this$scanForDeprecatedConditionals_u24lambda_u246_u24lambda_u244).metadataReaderFactory.getMetadataReader(resource), (String)"getMetadataReader(...)");
                $this$scanForDeprecatedConditionals_u24lambda_u246_u24lambda_u244 = Result.constructor-impl((Object)TuplesKt.to((Object)metadataReader, (Object)super.analyzeClassForDeprecatedConditionals(metadataReader, scanningConfig, propertyWarner)));
            }
            catch (Throwable bl3) {
                $this$scanForDeprecatedConditionals_u24lambda_u246_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object2 = $this$scanForDeprecatedConditionals_u24lambda_u246_u24lambda_u244;
            if (Result.exceptionOrNull-impl((Object)object2) == null) {
                object = object2;
            } else {
                Throwable exception;
                boolean bl4 = false;
                logger.debug("Error reading class metadata for " + resource + ": " + exception.getMessage());
                object = null;
            }
            if ((Pair)object == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List scanningResults = (List)destination$iv$iv;
        int scannedClasses = scanningResults.size();
        Iterable $this$count$iv = scanningResults;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!((Boolean)it.getSecond()).booleanValue() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int foundDeprecated = n;
        logger.info("Conditional property scanning completed. Scanned: " + scannedClasses + " classes, Found deprecated: " + foundDeprecated);
        propertyWarner.logAggregatedSummary();
    }

    private void scanEnvironmentPropertyUsage(SimpleDeprecatedConfigWarner propertyWarner) {
        logger.info("Scanning environment for deprecated property usage");
        Iterable $this$forEach$iv = this.exactPropertyMappings.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String deprecatedProperty = (String)element$iv;
            boolean bl = false;
            if (this.environment.getProperty(deprecatedProperty) == null) continue;
            boolean bl2 = false;
            String recommendedProperty = this.getRecommendedProperty(deprecatedProperty);
            propertyWarner.warnDeprecatedProperty(deprecatedProperty, recommendedProperty, "Property actively configured in environment");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Resource[] findClassesInPackage(String packageName, DeprecatedPropertyScanningConfig scanningConfig) {
        Resource[] resourceArray;
        Object $this$findClassesInPackage_u24lambda_u2413;
        String packagePath = StringsKt.replace$default((String)packageName, (char)'.', (char)'/', (boolean)false, (int)4, null);
        String pattern = "classpath*:" + packagePath + "/**/*.class";
        Resource[] resourceArray2 = this;
        try {
            Iterable iterable;
            $this$findClassesInPackage_u24lambda_u2413 = resourceArray2;
            boolean bl = false;
            Object[] resources = ((DeprecatedPropertyScanner)$this$findClassesInPackage_u24lambda_u2413).resourceResolver.getResources(pattern);
            boolean bl2 = false;
            if (scanningConfig.getAutoExcludeJarPackages()) {
                void $this$filterNotTo$iv$iv;
                Intrinsics.checkNotNull((Object)resources);
                Object[] $this$filterNot$iv = resources;
                boolean $i$f$filterNot = false;
                Object[] objectArray = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                int n = ((void)$this$filterNotTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void resource = element$iv$iv = $this$filterNotTo$iv$iv[i];
                    boolean bl3 = false;
                    String $this$findClassesInPackage_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = resource.getURL().toString();
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)$this$findClassesInPackage_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410);
                    if (StringsKt.contains$default((CharSequence)$this$findClassesInPackage_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, (CharSequence)".jar!", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$findClassesInPackage_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, (CharSequence)".war!", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                iterable = (List)destination$iv$iv;
            } else {
                Intrinsics.checkNotNull((Object)resources);
                iterable = ArraysKt.asIterable((Object[])resources);
            }
            Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)iterable);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$findClassesInPackage_u24lambda_u2413 = Result.constructor-impl((Object)thisCollection$iv.toArray(new Resource[0]));
        }
        catch (Throwable bl) {
            $this$findClassesInPackage_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        resourceArray2 = $this$findClassesInPackage_u24lambda_u2413;
        Throwable throwable = Result.exceptionOrNull-impl((Object)resourceArray2);
        if (throwable == null) {
            resourceArray = resourceArray2;
        } else {
            Throwable exception = throwable;
            boolean bl = false;
            logger.debug("Error finding classes in package " + packageName + ": " + exception.getMessage());
            resourceArray = new Resource[]{};
        }
        return resourceArray;
    }

    /*
     * WARNING - void declaration
     */
    private boolean analyzeClassForDeprecatedConditionals(MetadataReader metadataReader, DeprecatedPropertyScanningConfig scanningConfig, SimpleDeprecatedConfigWarner propertyWarner) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        String string = metadataReader.getClassMetadata().getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        String className = string;
        AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)annotationMetadata, (String)"getAnnotationMetadata(...)");
        AnnotationMetadata annotationMetadata2 = annotationMetadata;
        if (scanningConfig.shouldExcludePackage(className)) {
            return false;
        }
        boolean foundDeprecated = false;
        if (annotationMetadata2.hasAnnotation(ConditionalOnProperty.class.getName())) {
            foundDeprecated = this.analyzeConditionalOnProperty(className, annotationMetadata2, propertyWarner);
        }
        if (annotationMetadata2.hasAnnotation("org.springframework.boot.context.properties.ConfigurationProperties")) {
            boolean configPropsDeprecated = this.analyzeConfigurationProperties(className, annotationMetadata2, propertyWarner);
            foundDeprecated = foundDeprecated || configPropsDeprecated;
        }
        Set set = annotationMetadata2.getAnnotationTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAnnotationTypes(...)");
        Iterable configPropsDeprecated = set;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)ConditionalOnProperty.class.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object $this$analyzeClassForDeprecatedConditionals_u24lambda_u2418_u24lambda_u2416;
            String annotationType = (String)element$iv;
            boolean bl = false;
            Object object = this;
            try {
                $this$analyzeClassForDeprecatedConditionals_u24lambda_u2418_u24lambda_u2416 = object;
                boolean bl2 = false;
                $this$analyzeClassForDeprecatedConditionals_u24lambda_u2418_u24lambda_u2416 = Result.constructor-impl(Class.forName(annotationType));
            }
            catch (Throwable bl2) {
                $this$analyzeClassForDeprecatedConditionals_u24lambda_u2418_u24lambda_u2416 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            if (!Result.isSuccess-impl((Object)(object = $this$analyzeClassForDeprecatedConditionals_u24lambda_u2418_u24lambda_u2416))) continue;
            Class metaClass = (Class)object;
            boolean bl3 = false;
            if (!metaClass.isAnnotationPresent(ConditionalOnProperty.class) && !metaClass.isAnnotationPresent(Conditional.class)) continue;
            logger.debug("Found meta-annotation with conditional logic in " + className + ": " + annotationType);
        }
        return foundDeprecated;
    }

    private boolean analyzeConditionalOnProperty(String className, AnnotationMetadata annotationMetadata, SimpleDeprecatedConfigWarner propertyWarner) {
        Map map = annotationMetadata.getAnnotationAttributes(ConditionalOnProperty.class.getName());
        if (map == null) {
            return false;
        }
        Map attributes = map;
        Object v = attributes.get("name");
        String name = v instanceof String ? (String)v : null;
        Object v2 = attributes.get("prefix");
        String prefix = v2 instanceof String ? (String)v2 : null;
        Object v3 = attributes.get("value");
        Object[] value = v3 instanceof Object[] ? (Object[])v3 : null;
        List deprecatedProperties2 = SequencesKt.toList((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(prefix, name, value, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $prefix;
            final /* synthetic */ String $name;
            final /* synthetic */ Object[] $value;
            final /* synthetic */ DeprecatedPropertyScanner this$0;
            {
                this.$prefix = $prefix;
                this.$name = $name;
                this.$value = $value;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                block31: {
                    block28: {
                        block30: {
                            block29: {
                                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$sequence = (SequenceScope)this.L$0;
                                        if (this.$prefix == null) break;
                                        var3_4 = this.$prefix;
                                        var4_5 = this.this$0;
                                        prefixValue = var3_4;
                                        $i$a$-let-DeprecatedPropertyScanner$analyzeConditionalOnProperty$deprecatedProperties$1$1 = false;
                                        if (DeprecatedPropertyScanner.access$isDeprecatedProperty((DeprecatedPropertyScanner)var4_5, (String)prefixValue)) {
                                            this.L$0 = $this$sequence;
                                            this.label = 1;
                                            v0 = $this$sequence.yield((Object)prefixValue, (Continuation)this);
                                            if (v0 == var16_2) {
                                                return var16_2;
                                            }
                                        }
                                        break;
                                    }
                                    case 1: {
                                        $i$a$-let-DeprecatedPropertyScanner$analyzeConditionalOnProperty$deprecatedProperties$1$1 = false;
                                        $this$sequence = (SequenceScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        break;
                                    }
                                }
                                v1 = this.$name;
                                if (v1 == null) break block28;
                                var3_4 = v1;
                                var4_5 = this.$prefix;
                                var5_6 = this.this$0;
                                propertyName = var3_4;
                                $i$a$-let-DeprecatedPropertyScanner$analyzeConditionalOnProperty$deprecatedProperties$1$2 = false;
                                v2 /* !! */  = var4_5;
                                if (var4_5 == null) break block29;
                                it = v2 /* !! */ ;
                                $i$a$-let-DeprecatedPropertyScanner$analyzeConditionalOnProperty$deprecatedProperties$1$2$fullPropertyName$1 = false;
                                v3 = (String)it + "." + (String)propertyName;
                                v2 /* !! */  = v3;
                                if (v3 != null) break block30;
                            }
                            v2 /* !! */  = propertyName;
                        }
                        if (DeprecatedPropertyScanner.access$isDeprecatedProperty(var5_6, (String)(fullPropertyName = v2 /* !! */ ))) {
                            this.L$0 = $this$sequence;
                            this.label = 2;
                            v4 = $this$sequence.yield((Object)fullPropertyName, (Continuation)this);
                            if (v4 == var16_2) {
                                return var16_2;
                            }
                        }
                        break block28;
                        {
                            case 2: {
                                $i$a$-let-DeprecatedPropertyScanner$analyzeConditionalOnProperty$deprecatedProperties$1$2 = false;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
                            }
                        }
                    }
                    if (this.$value == null) break block31;
                    var3_4 = this.$value;
                    var4_5 = this.$prefix;
                    var5_6 = this.this$0;
                    $i$f$forEach = false;
                    var7_10 = 0;
                    var8_15 = $this$forEach$iv.length;
lbl67:
                    // 2 sources

                    while (var7_10 < var8_15) {
                        block33: {
                            block32: {
                                prop = element$iv = $this$forEach$iv[var7_10];
                                $i$a$-forEach-DeprecatedPropertyScanner$analyzeConditionalOnProperty$deprecatedProperties$1$3 = false;
                                propertyName = String.valueOf(prop);
                                v5 /* !! */  = var4_5;
                                if (var4_5 == null) break block32;
                                it = v5 /* !! */ ;
                                $i$a$-let-DeprecatedPropertyScanner$analyzeConditionalOnProperty$deprecatedProperties$1$3$fullPropertyName$1 = false;
                                v6 = (String)it + "." + propertyName;
                                v5 /* !! */  = v6;
                                if (v6 != null) break block33;
                            }
                            v5 /* !! */  = propertyName;
                        }
                        if (DeprecatedPropertyScanner.access$isDeprecatedProperty(var5_6, (String)(fullPropertyName /* !! */  = v5 /* !! */ ))) {
                            this.L$0 = $this$sequence;
                            this.L$1 = $this$forEach$iv;
                            this.L$2 = var4_5;
                            this.L$3 = var5_6;
                            this.I$0 = var7_10;
                            this.I$1 = var8_15;
                            this.label = 3;
                            v7 = $this$sequence.yield((Object)fullPropertyName /* !! */ , (Continuation)this);
                            if (v7 == var16_2) {
                                return var16_2;
                            }
                        }
                        ** GOTO lbl106
                    }
                    {
                        break;
                        case 3: {
                            $i$f$forEach = false;
                            $i$a$-forEach-DeprecatedPropertyScanner$analyzeConditionalOnProperty$deprecatedProperties$1$3 = false;
                            var8_15 = this.I$1;
                            var7_10 = this.I$0;
                            var5_6 = (DeprecatedPropertyScanner)this.L$3;
                            var4_5 = (String)this.L$2;
                            $this$forEach$iv = (Object[])this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl106:
                            // 2 sources

                            ++var7_10;
                            ** GOTO lbl67
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })));
        Iterable $this$forEach$iv = deprecatedProperties2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String propertyName = (String)element$iv;
            boolean bl = false;
            this.issueDeprecatedConditionalWarning(className, propertyName, propertyWarner);
        }
        return !((Collection)deprecatedProperties2).isEmpty();
    }

    private boolean analyzeConfigurationProperties(String className, AnnotationMetadata annotationMetadata, SimpleDeprecatedConfigWarner propertyWarner) {
        boolean bl;
        String prefix;
        Map map = annotationMetadata.getAnnotationAttributes("org.springframework.boot.context.properties.ConfigurationProperties");
        if (map == null) {
            return false;
        }
        Map attributes = map;
        Object v = attributes.get("prefix");
        String string = v instanceof String ? (String)v : null;
        if (string == null) {
            v = attributes.get("value");
            string = v instanceof String ? (String)v : null;
        }
        if ((prefix = string) != null && this.isDeprecatedProperty(prefix)) {
            this.issueDeprecatedConfigurationPropertiesWarning(className, prefix, propertyWarner);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void issueDeprecatedConfigurationPropertiesWarning(String className, String prefix, SimpleDeprecatedConfigWarner propertyWarner) {
        String recommendedPrefix = this.getRecommendedProperty(prefix);
        String annotationDetails = "@ConfigurationProperties(prefix = \"" + prefix + "\")";
        String recommendedApproach = "@ConfigurationProperties(prefix = \"" + recommendedPrefix + "\")";
        propertyWarner.warnDeprecatedConfigurationProperties(className, annotationDetails, recommendedApproach);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDeprecatedProperty(String propertyName) {
        boolean bl;
        if (this.exactPropertyMappings.containsKey(propertyName)) return true;
        Iterable $this$any$iv = this.propertyMigrationRules;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            PropertyMigrationRule rule = (PropertyMigrationRule)element$iv;
            boolean bl2 = false;
            if (rule.tryApply(propertyName) != null) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private void issueDeprecatedConditionalWarning(String className, String propertyName, SimpleDeprecatedConfigWarner propertyWarner) {
        String recommendedProperty = this.getRecommendedProperty(propertyName);
        String annotationDetails = "@ConditionalOnProperty(\"" + propertyName + "\")";
        String recommendedApproach = "@ConditionalOnProperty(\"" + recommendedProperty + "\")";
        propertyWarner.warnDeprecatedConditional(className, annotationDetails, recommendedApproach);
    }

    private String getRecommendedProperty(String deprecatedProperty) {
        Object object = this.exactPropertyMappings.get(deprecatedProperty);
        if (object == null) {
            Object object2;
            block3: {
                for (PropertyMigrationRule rule : (Iterable)this.propertyMigrationRules) {
                    boolean bl = false;
                    String string = rule.tryApply(deprecatedProperty);
                    if (string == null) continue;
                    object2 = string;
                    break block3;
                }
                object2 = object = null;
            }
            if (object2 == null) {
                object = deprecatedProperty + " (please check migration guide for specific replacement)";
            }
        }
        return object;
    }

    public void addMigrationRule(@NotNull PropertyMigrationRule rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        this.propertyMigrationRules.add(rule);
        logger.debug("Added migration rule: " + rule.getDescription());
    }

    @NotNull
    public List<PropertyMigrationRule> getMigrationRules() {
        return CollectionsKt.toList((Iterable)this.propertyMigrationRules);
    }

    public static final /* synthetic */ boolean access$isDeprecatedProperty(DeprecatedPropertyScanner $this, String propertyName) {
        return $this.isDeprecatedProperty(propertyName);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanner$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u0017\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u00c6\u0003J?\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanner$PropertyMigrationRule;", "", "pattern", "Ljava/util/regex/Pattern;", "replacement", "", "description", "condition", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/regex/Pattern;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getPattern", "()Ljava/util/regex/Pattern;", "getReplacement", "()Ljava/lang/String;", "getDescription", "getCondition", "()Lkotlin/jvm/functions/Function1;", "tryApply", "property", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "embabel-agent-api"})
    @SourceDebugExtension(value={"SMAP\nDeprecatedPropertyScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedPropertyScanner.kt\ncom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanner$PropertyMigrationRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,720:1\n1#2:721\n*E\n"})
    public static final class PropertyMigrationRule {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final String replacement;
        @NotNull
        private final String description;
        @Nullable
        private final Function1<String, Boolean> condition;

        public PropertyMigrationRule(@NotNull Pattern pattern, @NotNull String replacement, @NotNull String description, @Nullable Function1<? super String, Boolean> condition2) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.pattern = pattern;
            this.replacement = replacement;
            this.description = description;
            this.condition = condition2;
        }

        public /* synthetic */ PropertyMigrationRule(Pattern pattern, String string, String string2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                function1 = null;
            }
            this(pattern, string, string2, (Function1<? super String, Boolean>)function1);
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final Function1<String, Boolean> getCondition() {
            return this.condition;
        }

        @Nullable
        public final String tryApply(@NotNull String property) {
            Object it;
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Function1<String, Boolean> function1 = this.condition;
            if (function1 != null) {
                it = function1;
                boolean bl = false;
                if (!((Boolean)it.invoke((Object)property)).booleanValue()) {
                    return null;
                }
            }
            Matcher matcher = this.pattern.matcher(property);
            it = matcher;
            boolean bl = false;
            Matcher matcher2 = ((Matcher)it).matches() ? matcher : null;
            return matcher2 != null ? matcher2.replaceAll(this.replacement) : null;
        }

        @NotNull
        public final Pattern component1() {
            return this.pattern;
        }

        @NotNull
        public final String component2() {
            return this.replacement;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        @Nullable
        public final Function1<String, Boolean> component4() {
            return this.condition;
        }

        @NotNull
        public final PropertyMigrationRule copy(@NotNull Pattern pattern, @NotNull String replacement, @NotNull String description, @Nullable Function1<? super String, Boolean> condition2) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new PropertyMigrationRule(pattern, replacement, description, condition2);
        }

        public static /* synthetic */ PropertyMigrationRule copy$default(PropertyMigrationRule propertyMigrationRule, Pattern pattern, String string, String string2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                pattern = propertyMigrationRule.pattern;
            }
            if ((n & 2) != 0) {
                string = propertyMigrationRule.replacement;
            }
            if ((n & 4) != 0) {
                string2 = propertyMigrationRule.description;
            }
            if ((n & 8) != 0) {
                function1 = propertyMigrationRule.condition;
            }
            return propertyMigrationRule.copy(pattern, string, string2, function1);
        }

        @NotNull
        public String toString() {
            return "PropertyMigrationRule(pattern=" + this.pattern + ", replacement=" + this.replacement + ", description=" + this.description + ", condition=" + this.condition + ")";
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = result * 31 + this.replacement.hashCode();
            result = result * 31 + this.description.hashCode();
            result = result * 31 + (this.condition == null ? 0 : this.condition.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropertyMigrationRule)) {
                return false;
            }
            PropertyMigrationRule propertyMigrationRule = (PropertyMigrationRule)other;
            if (!Intrinsics.areEqual((Object)this.pattern, (Object)propertyMigrationRule.pattern)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.replacement, (Object)propertyMigrationRule.replacement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)propertyMigrationRule.description)) {
                return false;
            }
            return Intrinsics.areEqual(this.condition, propertyMigrationRule.condition);
        }
    }
}

