/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.domain.library;

import com.embabel.agent.domain.library.ContentAsset;
import com.embabel.agent.domain.library.InternetResource;
import com.embabel.agent.domain.library.InternetResources;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.FormatUtilsKt;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Research report, containing a topic, content and links")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016R\u0013\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u00020\u00058WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/embabel/agent/domain/library/ResearchReport;", "Lcom/embabel/agent/domain/library/InternetResources;", "Lcom/embabel/common/core/types/HasInfoString;", "Lcom/embabel/agent/domain/library/ContentAsset;", "topic", "", "content", "links", "", "Lcom/embabel/agent/domain/library/InternetResource;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getTopic", "()Ljava/lang/String;", "getContent", "getLinks", "()Ljava/util/List;", "timestamp", "Ljava/time/Instant;", "getTimestamp", "()Ljava/time/Instant;", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "toString", "contribution", "embabel-agent-api"})
public class ResearchReport
implements InternetResources,
HasInfoString,
ContentAsset {
    @NotNull
    private final String topic;
    @NotNull
    private final String content;
    @NotNull
    private final List<InternetResource> links;
    @NotNull
    private final Instant timestamp;

    public ResearchReport(@NotNull String topic, @NotNull String content, @NotNull List<? extends InternetResource> links) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(links, (String)"links");
        this.topic = topic;
        this.content = content;
        this.links = links;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.timestamp = instant;
    }

    @JsonPropertyDescription(value="Topic the report is about, e.g. 'Quantum Computing', 'AI Ethics', etc.")
    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @Override
    @JsonPropertyDescription(value="The text of the research report")
    @NotNull
    public String getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public List<InternetResource> getLinks() {
        return this.links;
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|Report:\n           |" + this.getContent() + "\n           |Links: " + CollectionsKt.joinToString$default((Iterable)this.getLinks(), (CharSequence)"\n", null, null, (int)0, null, ResearchReport::infoString$lambda$0, (int)30, null) + "\n           |"), null, (int)1, null), (int)indent, (boolean)false, (boolean)false, null, (int)14, null);
    }

    @NotNull
    public String toString() {
        return this.infoString(false, 0);
    }

    @Override
    @NotNull
    public String contribution() {
        return StringsKt.trimIndent((String)("\n            |Research Report:\n            |Topic: " + this.topic + "\n            |Content: " + this.getContent() + "\n            |Links: " + CollectionsKt.joinToString$default((Iterable)this.getLinks(), (CharSequence)"\n", null, null, (int)0, null, ResearchReport::contribution$lambda$1, (int)30, null) + "\n            |Date: " + this.getTimestamp().atZone(ZoneId.systemDefault()).toLocalDate() + "\n        "));
    }

    private static final CharSequence infoString$lambda$0(InternetResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUrl();
    }

    private static final CharSequence contribution$lambda$1(InternetResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUrl() + " - " + it.getSummary();
    }
}

