/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core;

import com.embabel.agent.api.common.SomeOf;
import com.embabel.agent.core.Cardinality;
import com.embabel.agent.core.CreationPermitted;
import com.embabel.agent.core.DomainType;
import com.embabel.agent.core.DomainTypePropertyDefinition;
import com.embabel.agent.core.DynamicType;
import com.embabel.agent.core.PropertyDefinition;
import com.embabel.agent.core.SimplePropertyDefinition;
import com.embabel.common.util.FormatUtilsKt;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013B\u0013\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0015\b\u0016\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0014\u0010\u001d\u001a\u00020\f2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0001H\u0016J\u0014\u0010\u001f\u001a\u00020\f2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0001H\u0016J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0016J\u0014\u0010&\u001a\u00020\f2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u001f\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010*\u001a\u00020+H\u0016\u00a2\u0006\u0002\u0010,J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010.\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010/\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u000100H\u00d6\u0003J\t\u00101\u001a\u00020+H\u00d6\u0001J\t\u00102\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00078GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\nR\u0014\u0010\u0019\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0014\u0010\u001b\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00108WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012\u00a8\u00064"}, d2={"Lcom/embabel/agent/core/JvmType;", "Lcom/embabel/agent/core/DomainType;", "className", "", "<init>", "(Ljava/lang/String;)V", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "getClassName", "()Ljava/lang/String;", "creationPermitted", "", "getCreationPermitted", "()Z", "parents", "", "getParents", "()Ljava/util/List;", "getClazz", "()Ljava/lang/Class;", "clazz$delegate", "Lkotlin/Lazy;", "name", "getName", "ownLabel", "getOwnLabel", "description", "getDescription", "isAssignableFrom", "other", "isAssignableTo", "children", "", "additionalBasePackages", "ownProperties", "Lcom/embabel/agent/core/PropertyDefinition;", "getOwnProperties", "shouldNestAsEntity", "type", "infoString", "verbose", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "component1", "copy", "equals", "", "hashCode", "toString", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nJvmType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmType.kt\ncom/embabel/agent/core/JvmType\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n13402#2,2:236\n11476#2,9:238\n13402#2:247\n13403#2:249\n11485#2:250\n1#3:248\n*S KotlinDebug\n*F\n+ 1 JvmType.kt\ncom/embabel/agent/core/JvmType\n*L\n51#1:236,2\n139#1:238,9\n139#1:247\n139#1:249\n139#1:250\n139#1:248\n*E\n"})
public final class JvmType
implements DomainType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String className;
    @NotNull
    private final Lazy clazz$delegate;
    private static final Logger logger = LoggerFactory.getLogger(JvmType.class);

    @JsonCreator
    public JvmType(@JsonProperty(value="className") @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.className = className;
        this.clazz$delegate = LazyKt.lazy(() -> JvmType.clazz_delegate$lambda$1(this));
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public JvmType(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this(string);
    }

    @Override
    @JsonIgnore
    public boolean getCreationPermitted() {
        CreationPermitted cpa = this.getClazz().getAnnotation(CreationPermitted.class);
        return cpa != null;
    }

    @JsonIgnore
    @NotNull
    public List<JvmType> getParents() {
        Class<?> superclass = this.getClazz().getSuperclass();
        List parentList = new ArrayList();
        if (superclass != null && !Intrinsics.areEqual(superclass, Object.class)) {
            parentList.add(new JvmType(superclass));
        }
        Class<?>[] classArray = this.getClazz().getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
        Object[] $this$forEach$iv = classArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            parentList.add(new JvmType(it));
        }
        return parentList;
    }

    @JsonIgnore
    @NotNull
    public final Class<?> getClazz() {
        Lazy lazy = this.clazz$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Class)object;
    }

    @JsonIgnore
    @NotNull
    public String getName() {
        return this.className;
    }

    @Override
    @JsonIgnore
    @NotNull
    public String getOwnLabel() {
        String string = this.getClazz().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @JsonIgnore
    @NotNull
    public String getDescription() {
        Object object;
        JsonClassDescription ann = this.getClazz().getAnnotation(JsonClassDescription.class);
        if (ann != null) {
            object = this.getClazz().getSimpleName() + ": " + ann.value();
        } else {
            String string = this.getClazz().getName();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        }
        return object;
    }

    @Override
    public boolean isAssignableFrom(@NotNull Class<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.getClazz().isAssignableFrom(other);
    }

    @Override
    public boolean isAssignableFrom(@NotNull DomainType other) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        DomainType domainType = other;
        if (domainType instanceof JvmType) {
            bl = this.getClazz().isAssignableFrom(((JvmType)other).getClazz());
        } else if (domainType instanceof DynamicType) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean isAssignableTo(@NotNull Class<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return other.isAssignableFrom(this.getClazz());
    }

    @Override
    public boolean isAssignableTo(@NotNull DomainType other) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        DomainType domainType = other;
        if (domainType instanceof JvmType) {
            bl = ((JvmType)other).getClazz().isAssignableFrom(this.getClazz());
        } else if (domainType instanceof DynamicType) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public Collection<JvmType> children(@NotNull Collection<String> additionalBasePackages) {
        Collection collection;
        Intrinsics.checkNotNullParameter(additionalBasePackages, (String)"additionalBasePackages");
        Collection collection2 = additionalBasePackages;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)this.getClazz().getPackageName());
        } else {
            collection = collection2;
        }
        Collection basePackagesToUse = collection;
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(this.getClazz()));
        List result = new ArrayList();
        for (String packageName : basePackagesToUse) {
            try {
                Set candidateComponents;
                Intrinsics.checkNotNullExpressionValue((Object)scanner.findCandidateComponents(packageName), (String)"findCandidateComponents(...)");
                for (BeanDefinition beanDef : candidateComponents) {
                    try {
                        Class<?> candidateClass;
                        String className = beanDef.getBeanClassName();
                        if (className == null || Intrinsics.areEqual((Object)className, (Object)this.getClazz().getName()) || Intrinsics.areEqual(candidateClass = Class.forName(className), this.getClazz()) || !this.getClazz().isAssignableFrom(candidateClass)) continue;
                        Intrinsics.checkNotNull(candidateClass);
                        result.add(new JvmType(candidateClass));
                    }
                    catch (ClassNotFoundException e) {
                        logger.debug("Could not load class: " + beanDef.getBeanClassName(), (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.debug("Error processing class: " + beanDef.getBeanClassName(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Could not scan package: " + packageName, (Throwable)e);
            }
        }
        return CollectionsKt.toSet((Iterable)result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @JsonIgnore
    @NotNull
    public List<PropertyDefinition> getOwnProperties() {
        void $this$mapNotNullTo$iv$iv;
        Field[] fieldArray = this.getClazz().getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] $this$mapNotNull$iv = fieldArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PropertyDefinition propertyDefinition;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            Field field = (Field)element$iv$iv;
            boolean bl2 = false;
            if (Collection.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                Class typeArg;
                Type type2 = field.getGenericType();
                Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                ParameterizedType parameterizedType = (ParameterizedType)type2;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getActualTypeArguments(...)");
                Object object = ArraysKt.firstOrNull((Object[])typeArray);
                Class clazz = typeArg = object instanceof Class ? (Class)object : null;
                if (typeArg != null && this.shouldNestAsEntity(typeArg)) {
                    Cardinality cardinality = Set.class.isAssignableFrom(field.getType()) ? Cardinality.SET : Cardinality.LIST;
                    String string = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    propertyDefinition = new DomainTypePropertyDefinition(string, new JvmType(typeArg), cardinality, null, 8, null);
                } else {
                    String string = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = field.getType().getSimpleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
                    propertyDefinition = new SimplePropertyDefinition(string, string2, null, null, 12, null);
                }
            } else {
                Class<?> clazz = field.getType();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
                if (this.shouldNestAsEntity(clazz)) {
                    String string = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    Class<?> clazz2 = field.getType();
                    Intrinsics.checkNotNullExpressionValue(clazz2, (String)"getType(...)");
                    propertyDefinition = new DomainTypePropertyDefinition(string, new JvmType(clazz2), null, null, 12, null);
                } else {
                    String string = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string3 = field.getType().getSimpleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSimpleName(...)");
                    propertyDefinition = new SimplePropertyDefinition(string, string3, null, null, 12, null);
                }
            }
            PropertyDefinition it$iv$iv = propertyDefinition;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean shouldNestAsEntity(Class<?> type2) {
        if (type2.isPrimitive() || Intrinsics.areEqual(type2, Boolean.class) || Intrinsics.areEqual(type2, Byte.class) || Intrinsics.areEqual(type2, Short.class) || Intrinsics.areEqual(type2, Integer.class) || Intrinsics.areEqual(type2, Long.class) || Intrinsics.areEqual(type2, Float.class) || Intrinsics.areEqual(type2, Double.class) || Intrinsics.areEqual(type2, Character.class)) {
            return false;
        }
        if (Intrinsics.areEqual(type2, String.class) || Intrinsics.areEqual(type2, BigDecimal.class) || Intrinsics.areEqual(type2, BigInteger.class) || Intrinsics.areEqual(type2, Date.class) || Intrinsics.areEqual(type2, LocalDate.class) || Intrinsics.areEqual(type2, LocalDateTime.class) || Intrinsics.areEqual(type2, Instant.class)) {
            return false;
        }
        return !Collection.class.isAssignableFrom(type2) && !Map.class.isAssignableFrom(type2);
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("\n                |class: " + this.getClazz().getName() + "\n                |"), null, (int)1, null), (int)indent, (boolean)false, (boolean)false, null, (int)14, null);
    }

    @NotNull
    public final String component1() {
        return this.className;
    }

    @NotNull
    public final JvmType copy(@JsonProperty(value="className") @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return new JvmType(className);
    }

    public static /* synthetic */ JvmType copy$default(JvmType jvmType, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = jvmType.className;
        }
        return jvmType.copy(string);
    }

    @NotNull
    public String toString() {
        return "JvmType(className=" + this.className + ")";
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmType)) {
            return false;
        }
        JvmType jvmType = (JvmType)other;
        return Intrinsics.areEqual((Object)this.className, (Object)jvmType.className);
    }

    private static final Class clazz_delegate$lambda$1(JvmType this$0) {
        return Class.forName(this$0.className);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\tR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/embabel/agent/core/JvmType$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "fromClasses", "", "Lcom/embabel/agent/core/JvmType;", "classes", "Ljava/lang/Class;", "embabel-agent-api"})
    @SourceDebugExtension(value={"SMAP\nJvmType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmType.kt\ncom/embabel/agent/core/JvmType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1368#2:236\n1454#2,2:237\n1557#2:239\n1628#2,3:240\n1456#2,3:243\n*S KotlinDebug\n*F\n+ 1 JvmType.kt\ncom/embabel/agent/core/JvmType$Companion\n*L\n221#1:236\n221#1:237,2\n224#1:239\n224#1:240,3\n221#1:243,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<JvmType> fromClasses(@NotNull Collection<? extends Class<?>> classes) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Iterable $this$flatMap$iv = classes;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                Class it = (Class)element$iv$iv;
                boolean bl = false;
                if (SomeOf.class.isAssignableFrom(it)) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable2 = SomeOf.Companion.eligibleFields(it);
                    boolean $i$f$map = false;
                    void var13_13 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void field;
                        Field field2 = (Field)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        Class<?> clazz = field.getType();
                        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
                        collection.add(new JvmType(clazz));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.listOf((Object)new JvmType(it));
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

