/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.autonomy;

import com.embabel.agent.api.common.autonomy.PlanLister;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.common.util.TimeKt;
import com.embabel.plan.Plan;
import com.embabel.plan.common.condition.ConditionPlan;
import com.embabel.plan.common.condition.ConditionPlanner;
import com.embabel.plan.common.condition.ConditionPlanningSystem;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/api/common/autonomy/DefaultPlanLister;", "Lcom/embabel/agent/api/common/autonomy/PlanLister;", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "<init>", "(Lcom/embabel/agent/core/AgentPlatform;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "achievablePlans", "", "Lcom/embabel/plan/Plan;", "processOptions", "Lcom/embabel/agent/core/ProcessOptions;", "bindings", "", "", "", "planningSystem", "Lcom/embabel/plan/common/condition/ConditionPlanningSystem;", "embabel-agent-api"})
public class DefaultPlanLister
implements PlanLister {
    @NotNull
    private final AgentPlatform agentPlatform;
    private final Logger logger;

    public DefaultPlanLister(@NotNull AgentPlatform agentPlatform) {
        Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
        this.agentPlatform = agentPlatform;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @NotNull
    public List<Plan> achievablePlans(@NotNull ProcessOptions processOptions, @NotNull Map<String, ? extends Object> bindings) {
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        Agent uberAgent = this.agentPlatform.createAgent("PlanLister", "Embabel", "Won't even run, just lists plans");
        AgentProcess dummyAgentProcess = this.agentPlatform.createAgentProcess(uberAgent, processOptions, bindings);
        Object object = dummyAgentProcess.getPlanner();
        ConditionPlanner conditionPlanner = object instanceof ConditionPlanner ? (ConditionPlanner)object : null;
        if (conditionPlanner == null) {
            object = "Only GoapPlanners are presently supported: found " + Reflection.getOrCreateKotlinClass(dummyAgentProcess.getPlanner().getClass()).getQualifiedName();
            throw new NotImplementedError("An operation is not implemented: " + (String)object);
        }
        ConditionPlanner planner = conditionPlanner;
        ConditionPlanningSystem planningSystem = this.planningSystem();
        object = TimeKt.time(() -> DefaultPlanLister.achievablePlans$lambda$0(planner, planningSystem));
        List plans = (List)object.component1();
        long ms = ((Number)object.component2()).longValue();
        Object[] objectArray = new Object[]{planningSystem.getActions().size(), planningSystem.getGoals().size(), ms, bindings, CollectionsKt.joinToString$default((Iterable)plans, (CharSequence)"\n", null, null, (int)0, null, DefaultPlanLister::achievablePlans$lambda$1, (int)30, null), planningSystem.infoString(true, 1)};
        this.logger.info("Achievable plans given {} actions and {} goals in {}ms from bindings {} : {}\n{}", objectArray);
        return plans;
    }

    private ConditionPlanningSystem planningSystem() {
        return new ConditionPlanningSystem(CollectionsKt.toSet((Iterable)this.agentPlatform.getActions()), this.agentPlatform.getGoals());
    }

    private static final List achievablePlans$lambda$0(ConditionPlanner $planner, ConditionPlanningSystem $planningSystem) {
        return $planner.plansToGoals($planningSystem);
    }

    private static final CharSequence achievablePlans$lambda$1(ConditionPlan it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.infoString(true, 1);
    }
}

