/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.annotation.support;

import com.embabel.agent.api.annotation.AchievesGoal;
import com.embabel.agent.api.annotation.Action;
import com.embabel.agent.api.annotation.Agent;
import com.embabel.agent.api.annotation.AgentCapabilities;
import com.embabel.agent.api.annotation.Condition;
import com.embabel.agent.api.annotation.RequireNameMatch;
import com.embabel.agent.api.annotation.support.ActionMethodManager;
import com.embabel.agent.api.annotation.support.AgentMetadataReaderKt;
import com.embabel.agent.api.annotation.support.AgenticInfo;
import com.embabel.agent.api.annotation.support.DefaultActionMethodManager;
import com.embabel.agent.api.annotation.support.DuplicateParameterTypeExceptionKt;
import com.embabel.agent.api.annotation.support.MethodDefinedOperationNameGenerator;
import com.embabel.agent.api.annotation.support.UtilsKt;
import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.api.common.StuckHandler;
import com.embabel.agent.api.common.ToolObject;
import com.embabel.agent.core.AgentScope;
import com.embabel.agent.core.ComputedBooleanCondition;
import com.embabel.agent.core.Export;
import com.embabel.agent.core.Goal;
import com.embabel.agent.core.IoBinding;
import com.embabel.agent.core.JvmType;
import com.embabel.agent.core.support.Rerun;
import com.embabel.agent.core.support.SpringAiUtilsKt;
import com.embabel.agent.validation.AgentStructureValidator;
import com.embabel.agent.validation.AgentValidationManager;
import com.embabel.agent.validation.AgentValidator;
import com.embabel.agent.validation.DefaultAgentValidationManager;
import com.embabel.agent.validation.GoapPathToCompletionValidator;
import com.embabel.agent.validation.ValidationResult;
import com.embabel.common.core.types.Semver;
import com.embabel.common.util.NameUtils;
import com.embabel.plan.WorldState;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\n\u0010\fJ'\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u0001H\u0016J\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0012J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0012J\u001c\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0012J\u001c\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0012J\u001c\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0012J\u0018\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001cH\u0012J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0012J\u0018\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0001H\u0012J\u0018\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0001H\u0012J(\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0012J\"\u00102\u001a\u0004\u0018\u00010*2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u00103\u001a\u0002042\u0006\u0010\u001a\u001a\u00020\u0001H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/embabel/agent/api/annotation/support/AgentMetadataReader;", "", "actionMethodManager", "Lcom/embabel/agent/api/annotation/support/ActionMethodManager;", "nameGenerator", "Lcom/embabel/agent/api/annotation/support/MethodDefinedOperationNameGenerator;", "agentStructureValidator", "Lcom/embabel/agent/validation/AgentStructureValidator;", "goapPathToCompletionValidator", "Lcom/embabel/agent/validation/GoapPathToCompletionValidator;", "<init>", "(Lcom/embabel/agent/api/annotation/support/ActionMethodManager;Lcom/embabel/agent/api/annotation/support/MethodDefinedOperationNameGenerator;Lcom/embabel/agent/validation/AgentStructureValidator;Lcom/embabel/agent/validation/GoapPathToCompletionValidator;)V", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "agentValidationManager", "Lcom/embabel/agent/validation/AgentValidationManager;", "createAgentScopes", "", "Lcom/embabel/agent/core/AgentScope;", "instances", "", "([Ljava/lang/Object;)Ljava/util/List;", "createAgentMetadata", "instance", "findConditionMethods", "Ljava/lang/reflect/Method;", "type", "Ljava/lang/Class;", "findActionMethods", "isActionMethod", "", "method", "isConditionMethod", "isMethodFromSupertype", "methodSignaturesMatch", "method1", "method2", "findGoalGetters", "getGoal", "Lcom/embabel/agent/core/Goal;", "createCondition", "Lcom/embabel/agent/core/ComputedBooleanCondition;", "invokeConditionMethod", "condition", "Lcom/embabel/agent/core/Condition;", "context", "Lcom/embabel/agent/api/common/OperationContext;", "createGoalFromActionMethod", "action", "Lcom/embabel/agent/core/Action;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAgentMetadataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentMetadataReader.kt\ncom/embabel/agent/api/annotation/support/AgentMetadataReader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,479:1\n11476#2,9:480\n13402#2:489\n13403#2:491\n11485#2:492\n12567#2:505\n12567#2,2:506\n12568#2:508\n12567#2,2:509\n13402#2,2:511\n11158#2:522\n11493#2,3:523\n1#3:490\n1#3:521\n1557#4:493\n1628#4,3:494\n1557#4:497\n1628#4,3:498\n1557#4:501\n1628#4,3:502\n1557#4:513\n1628#4,3:514\n37#5:517\n36#5,3:518\n*S KotlinDebug\n*F\n+ 1 AgentMetadataReader.kt\ncom/embabel/agent/api/annotation/support/AgentMetadataReader\n*L\n131#1:480,9\n131#1:489\n131#1:491\n131#1:492\n277#1:505\n278#1:506,2\n277#1:508\n288#1:509,2\n310#1:511,2\n455#1:522\n455#1:523,3\n131#1:490\n172#1:493\n172#1:494,3\n178#1:497\n178#1:498,3\n179#1:501\n179#1:502,3\n378#1:513\n378#1:514,3\n413#1:517\n413#1:518,3\n*E\n"})
public class AgentMetadataReader {
    @NotNull
    private final ActionMethodManager actionMethodManager;
    @NotNull
    private final MethodDefinedOperationNameGenerator nameGenerator;
    private final Logger logger;
    @NotNull
    private final AgentValidationManager agentValidationManager;

    public AgentMetadataReader(@NotNull ActionMethodManager actionMethodManager, @NotNull MethodDefinedOperationNameGenerator nameGenerator, @NotNull AgentStructureValidator agentStructureValidator, @NotNull GoapPathToCompletionValidator goapPathToCompletionValidator) {
        Intrinsics.checkNotNullParameter((Object)actionMethodManager, (String)"actionMethodManager");
        Intrinsics.checkNotNullParameter((Object)nameGenerator, (String)"nameGenerator");
        Intrinsics.checkNotNullParameter((Object)agentStructureValidator, (String)"agentStructureValidator");
        Intrinsics.checkNotNullParameter((Object)goapPathToCompletionValidator, (String)"goapPathToCompletionValidator");
        this.actionMethodManager = actionMethodManager;
        this.nameGenerator = nameGenerator;
        this.logger = LoggerFactory.getLogger(AgentMetadataReader.class);
        Object[] objectArray = new AgentValidator[]{agentStructureValidator, goapPathToCompletionValidator};
        this.agentValidationManager = new DefaultAgentValidationManager(CollectionsKt.listOf((Object[])objectArray));
    }

    public /* synthetic */ AgentMetadataReader(ActionMethodManager actionMethodManager, MethodDefinedOperationNameGenerator methodDefinedOperationNameGenerator, AgentStructureValidator agentStructureValidator, GoapPathToCompletionValidator goapPathToCompletionValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            actionMethodManager = new DefaultActionMethodManager(null, null, 3, null);
        }
        if ((n & 2) != 0) {
            methodDefinedOperationNameGenerator = MethodDefinedOperationNameGenerator.Companion.invoke();
        }
        this(actionMethodManager, methodDefinedOperationNameGenerator, agentStructureValidator, goapPathToCompletionValidator);
    }

    public AgentMetadataReader() {
        this(new DefaultActionMethodManager(null, null, 3, null), MethodDefinedOperationNameGenerator.Companion.invoke(), new AgentStructureValidator((ApplicationContext)new StaticApplicationContext()), new GoapPathToCompletionValidator());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AgentScope> createAgentScopes(Object ... instances) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)instances, (String)"instances");
        Object[] $this$mapNotNull$iv = instances;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            AgentScope it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (this.createAgentMetadata(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public AgentScope createAgentMetadata(@NotNull Object instance) {
        AgentScope agentScope;
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (instance instanceof Class) {
            this.logger.warn("\u2753Call to createAgentMetadata with class {}. Pass an instance", (Object)((Class)instance).getName());
            return null;
        }
        AgenticInfo agenticInfo = new AgenticInfo(instance.getClass());
        Class<?> targetType = agenticInfo.getTargetType();
        if (!agenticInfo.agentic()) {
            Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(AgentCapabilities.class).getSimpleName(), Reflection.getOrCreateKotlinClass(Agent.class).getSimpleName(), targetType.getName()};
            this.logger.debug("No @{} or @{} annotation found on {}", objectArray);
            return null;
        }
        if (!agenticInfo.validationErrors().isEmpty()) {
            Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(AgentCapabilities.class).getSimpleName(), Reflection.getOrCreateKotlinClass(Agent.class).getSimpleName(), targetType.getName()};
            this.logger.warn(CollectionsKt.joinToString$default((Iterable)agenticInfo.validationErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), objectArray);
            return null;
        }
        Iterable $this$map$iv = this.findGoalGetters(targetType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void it;
            Method method = (Method)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getGoal((Method)it, instance));
        }
        List getterGoals = (List)destination$iv$iv;
        List<Method> actionMethods = this.findActionMethods(targetType);
        List<Method> conditionMethods = this.findConditionMethods(targetType);
        List<ToolCallback> toolCallbacksOnInstance = SpringAiUtilsKt.safelyGetToolCallbacksFrom(ToolObject.Companion.from(instance));
        Iterable $this$map$iv2 = conditionMethods;
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            void it;
            object = (Method)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.createCondition((Method)it, instance));
        }
        Set conditions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = actionMethods;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Object[] destination$iv$iv3 = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void actionMethod;
            Method bl = (Method)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            com.embabel.agent.core.Action action = this.actionMethodManager.createAction((Method)actionMethod, instance, toolCallbacksOnInstance);
            collection.add(new Pair((Object)action, (Object)this.createGoalFromActionMethod((Method)actionMethod, action, instance)));
        }
        Pair pair = CollectionsKt.unzip((Iterable)((List)destination$iv$iv3));
        List actions = (List)pair.component1();
        List actionGoals = (List)pair.component2();
        List goals = CollectionsKt.plus((Collection)getterGoals, (Iterable)CollectionsKt.filterNotNull((Iterable)actionGoals));
        if (actionMethods.isEmpty() && goals.isEmpty() && conditionMethods.isEmpty()) {
            destination$iv$iv3 = new Object[]{Reflection.getOrCreateKotlinClass(Action.class).getSimpleName(), Reflection.getOrCreateKotlinClass(Condition.class).getSimpleName(), targetType.getName()};
            this.logger.warn("\u2753No methods annotated with @{} or @{} and no goals defined on {}", destination$iv$iv3);
            return null;
        }
        if (agenticInfo.getAgentAnnotation() != null) {
            CharSequence charSequence;
            $i$f$mapTo3 = agenticInfo.agentName();
            CharSequence charSequence2 = agenticInfo.getAgentAnnotation().provider();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = instance.getClass().getPackage().getName();
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ifBlank(...)");
            var15_27 = (String)charSequence;
            object = agenticInfo.getAgentAnnotation().description();
            charSequence2 = Semver.constructor-impl((String)agenticInfo.getAgentAnnotation().version());
            Set set = CollectionsKt.toSet((Iterable)goals);
            StuckHandler stuckHandler = instance instanceof StuckHandler ? (StuckHandler)instance : null;
            boolean bl = agenticInfo.getAgentAnnotation().opaque();
            agentScope = new com.embabel.agent.core.Agent((String)$i$f$mapTo3, (String)var15_27, (String)charSequence2, (String)object, conditions, actions, set, stuckHandler, bl, null, 512, null);
        } else {
            $i$f$mapTo3 = AgentScope.Companion;
            String string = agenticInfo.getType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            var15_27 = string;
            object = CollectionsKt.toSet((Iterable)goals);
            agentScope = AgentScope.Companion.invoke$default((AgentScope.Companion)$i$f$mapTo3, (String)var15_27, null, actions, (Set)object, conditions, false, 34, null);
        }
        AgentScope agent = agentScope;
        ValidationResult validationResult = this.agentValidationManager.validate(agent);
        if (!validationResult.isValid()) {
            this.logger.warn("Agent validation failed:\n" + CollectionsKt.joinToString$default((Iterable)validationResult.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        return agent;
    }

    private List<Method> findConditionMethods(Class<?> type2) {
        List conditionMethods = new ArrayList();
        ReflectionUtils.doWithMethods(type2, arg_0 -> AgentMetadataReader.findConditionMethods$lambda$5(conditionMethods, arg_0), arg_0 -> AgentMetadataReader.findConditionMethods$lambda$6(this, type2, arg_0));
        return conditionMethods;
    }

    private List<Method> findActionMethods(Class<?> type2) {
        List actionMethods = new ArrayList();
        ReflectionUtils.doWithMethods(type2, arg_0 -> AgentMetadataReader.findActionMethods$lambda$7(actionMethods, arg_0), arg_0 -> AgentMetadataReader.findActionMethods$lambda$8(this, type2, arg_0));
        if (actionMethods.isEmpty()) {
            this.logger.debug("No methods annotated with @{} found in {}", (Object)Reflection.getOrCreateKotlinClass(Action.class).getSimpleName(), type2);
        }
        return actionMethods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isActionMethod(Method method, Class<?> type2) {
        if (!method.isAnnotationPresent(Action.class)) return false;
        Method[] methodArray = type2.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        if (!ArraysKt.contains((Object[])methodArray, (Object)method)) {
            if (!this.isMethodFromSupertype(method, type2)) return false;
        }
        if (!method.getReturnType().isInterface()) return true;
        if (!AgentMetadataReaderKt.access$hasRequiredJsonDeserializeAnnotationOnInterfaceReturnType(method)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConditionMethod(Method method, Class<?> type2) {
        if (!method.isAnnotationPresent(Condition.class)) return false;
        Method[] methodArray = type2.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        if (ArraysKt.contains((Object[])methodArray, (Object)method)) return true;
        if (!this.isMethodFromSupertype(method, type2)) return false;
        return true;
    }

    private boolean isMethodFromSupertype(Method method, Class<?> type2) {
        boolean bl;
        block6: {
            Class<?>[] classArray = type2.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
            Object[] $this$any$iv = classArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                block5: {
                    Object element$iv = $this$any$iv[i];
                    Class interfaceType = (Class)element$iv;
                    boolean bl3 = false;
                    Method[] methodArray = interfaceType.getDeclaredMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
                    Object[] $this$any$iv2 = methodArray;
                    boolean $i$f$any2 = false;
                    for (Object element$iv2 : $this$any$iv2) {
                        Method interfaceMethod = (Method)element$iv2;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)interfaceMethod);
                        if (!this.methodSignaturesMatch(method, interfaceMethod)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        for (Class<?> superclass = type2.getSuperclass(); superclass != null && !Intrinsics.areEqual(superclass, Object.class); superclass = superclass.getSuperclass()) {
            boolean bl5;
            block7: {
                Method[] methodArray = superclass.getDeclaredMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
                Object[] $this$any$iv = methodArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Method superMethod = (Method)element$iv;
                    boolean bl6 = false;
                    Intrinsics.checkNotNull((Object)superMethod);
                    if (!this.methodSignaturesMatch(method, superMethod)) continue;
                    bl5 = true;
                    break block7;
                }
                bl5 = false;
            }
            if (!bl5) continue;
            return true;
        }
        return false;
    }

    private boolean methodSignaturesMatch(Method method1, Method method2) {
        return Intrinsics.areEqual((Object)method1.getName(), (Object)method2.getName()) && Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes()) && Intrinsics.areEqual(method1.getReturnType(), method2.getReturnType());
    }

    private List<Method> findGoalGetters(Class<?> type2) {
        List goalGetters = new ArrayList();
        Method[] methodArray = type2.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        Object[] $this$forEach$iv = methodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            if (method.getParameterCount() != 0 || Intrinsics.areEqual(method.getReturnType(), Void.TYPE) || !Goal.class.isAssignableFrom(method.getReturnType())) continue;
            Intrinsics.checkNotNull((Object)method);
            goalGetters.add(method);
        }
        if (goalGetters.isEmpty()) {
            this.logger.debug("No goal getters found in {}", type2);
        }
        return goalGetters;
    }

    private Goal getGoal(Method method, Object instance) {
        Object object = ReflectionUtils.invokeMethod((Method)method, (Object)instance);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.embabel.agent.core.Goal");
        Goal rawGoal = (Goal)object;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return Goal.copy$default(rawGoal, this.nameGenerator.generateName(instance, NameUtils.INSTANCE.beanMethodToPropertyName(string)), null, null, null, null, null, null, null, null, 510, null);
    }

    private ComputedBooleanCondition createCondition(Method method, Object instance) {
        CharSequence charSequence;
        DuplicateParameterTypeExceptionKt.requireNonAmbiguousParameters(method);
        Condition conditionAnnotation = method.getAnnotation(Condition.class);
        CharSequence charSequence2 = conditionAnnotation.name();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            charSequence = this.nameGenerator.generateName(instance, string);
        } else {
            charSequence = charSequence2;
        }
        Function2 function2 = (arg_0, arg_1) -> AgentMetadataReader.createCondition$lambda$14(this, method, instance, arg_0, arg_1);
        double d = conditionAnnotation.cost();
        String string = (String)charSequence;
        return new ComputedBooleanCondition(string, d, (Function2<? super OperationContext, ? super com.embabel.agent.core.Condition, Boolean>)function2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean invokeConditionMethod(Method method, Object instance, com.embabel.agent.core.Condition condition2, OperationContext context) {
        boolean bl;
        Object[] parameter;
        this.logger.debug("Invoking condition method {} on {}", (Object)method.getName(), (Object)instance.getClass().getName());
        List args = new ArrayList();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])method.getParameters());
        while (iterator.hasNext()) {
            String variable;
            void $this$mapTo$iv$iv;
            parameter = (Object[])iterator.next();
            if (OperationContext.class.isAssignableFrom(parameter.getType())) {
                ((Collection)args).add(context);
                continue;
            }
            RequireNameMatch requireNameMatch = parameter.getAnnotation(RequireNameMatch.class);
            Iterable $this$map$iv = context.getAgentProcess().getAgent().getJvmTypes();
            boolean $i$f$map22 = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JvmType jvmType = (JvmType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getClazz());
            }
            List domainTypes = (List)destination$iv$iv;
            if (UtilsKt.getBindingParameterName(parameter.getName(), requireNameMatch) == null) {
                throw new IllegalStateException("Parameter name should be available".toString());
            }
            Collection $i$f$map22 = args;
            String string = parameter.getType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Object object2 = context.getValue(variable, string, context.getAgentProcess().getAgent());
            if (object2 == null) {
                AgentMetadataReader $this$invokeConditionMethod_u24lambda_u2416 = this;
                boolean bl3 = false;
                if (domainTypes.contains(parameter.getType())) {
                    var16_22 = new Object[]{instance.getClass().getName(), method.getName(), variable, parameter.getType()};
                    $this$invokeConditionMethod_u24lambda_u2416.logger.debug("Condition method {}.{} has no value for parameter {} of known type {}: Returning false", var16_22);
                } else {
                    var16_22 = new Object[]{instance.getClass().getName(), method.getName(), variable, parameter.getType()};
                    $this$invokeConditionMethod_u24lambda_u2416.logger.warn("Condition method {}.{} has unsupported argument {}. Unknown type {}", var16_22);
                }
                return false;
            }
            object = object2;
            $i$f$map22.add(object);
        }
        try {
            method.trySetAccessible();
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            Object object = ReflectionUtils.invokeMethod((Method)method, (Object)instance, (Object[])Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean evaluationResult = (Boolean)object;
            parameter = new Object[]{evaluationResult, method.getName(), instance.getClass().getName(), args};
            this.logger.debug("Condition evaluated to {}, calling {} on {} using args {}", parameter);
            bl = evaluationResult;
        }
        catch (Throwable t) {
            this.logger.warn("Error invoking condition method " + method.getName() + " with args " + args, t);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private Goal createGoalFromActionMethod(Method method, com.embabel.agent.core.Action action, Object instance) {
        void $this$mapTo$iv$iv;
        CharSequence charSequence;
        Action actionAnnotation = method.getAnnotation(Action.class);
        AchievesGoal achievesGoal = method.getAnnotation(AchievesGoal.class);
        if (achievesGoal == null) {
            return null;
        }
        AchievesGoal goalAnnotation = achievesGoal;
        String string = actionAnnotation.outputBinding();
        String string2 = method.getReturnType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String inputBinding = IoBinding.constructor-impl(string, string2);
        String string3 = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String string4 = this.nameGenerator.generateName(instance, string3);
        String string5 = goalAnnotation.description();
        Set set = SetsKt.setOf((Object)IoBinding.box-impl(inputBinding));
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
        JvmType jvmType = new JvmType(clazz);
        Set set2 = SetsKt.plus((Set)SetsKt.setOf((Object)Rerun.INSTANCE.hasRunCondition(action)), (Iterable)CollectionsKt.toSet((Iterable)action.getPreconditions().keySet()));
        boolean bl = goalAnnotation.export().local();
        boolean bl2 = goalAnnotation.export().remote();
        Object object = goalAnnotation.export().name();
        if (StringsKt.isBlank((CharSequence)object)) {
            boolean bl3 = false;
            charSequence = null;
        } else {
            charSequence = object;
        }
        String string6 = (String)charSequence;
        KClass[] $this$map$iv = Reflection.getOrCreateKotlinClasses((Class[])goalAnnotation.export().startingInputTypes());
        boolean $i$f$map = false;
        KClass[] kClassArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var25_25 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(JvmClassMappingKt.getJavaClass((KClass)it));
        }
        object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Export export = new Export(string6, bl2, bl, (Set<? extends Class<?>>)object);
        return new Goal(string4, string5, set2, set, jvmType, arg_0 -> AgentMetadataReader.createGoalFromActionMethod$lambda$19(goalAnnotation, arg_0), null, null, export, 192, null);
    }

    private static final void findConditionMethods$lambda$5(List $conditionMethods, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        $conditionMethods.add(method);
    }

    private static final boolean findConditionMethods$lambda$6(AgentMetadataReader this$0, Class $type, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return this$0.isConditionMethod(method, $type);
    }

    private static final void findActionMethods$lambda$7(List $actionMethods, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        $actionMethods.add(method);
    }

    private static final boolean findActionMethods$lambda$8(AgentMetadataReader this$0, Class $type, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return this$0.isActionMethod(method, $type);
    }

    private static final boolean createCondition$lambda$14(AgentMetadataReader this$0, Method $method, Object $instance, OperationContext context, com.embabel.agent.core.Condition condition2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)condition2, (String)"condition");
        return this$0.invokeConditionMethod($method, $instance, condition2, context);
    }

    private static final double createGoalFromActionMethod$lambda$19(AchievesGoal $goalAnnotation, WorldState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $goalAnnotation.value();
    }
}

