/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.file;

import com.embabel.agent.tools.DirectoryBased;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0001\u0010J\u001c\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0003H\u0017J(\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/tools/file/PatternSearch;", "Lcom/embabel/agent/tools/DirectoryBased;", "findPatternInProject", "", "pattern", "globPattern", "", "Lcom/embabel/agent/tools/file/PatternSearch$PatternMatch;", "Lkotlin/text/Regex;", "useParallelSearch", "", "scanFile", "file", "Ljava/io/File;", "matchesGlob", "path", "PatternMatch", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nPatternSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternSearch.kt\ncom/embabel/agent/tools/file/PatternSearch\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n27#2:197\n27#2:205\n1557#3:198\n1628#3,3:199\n1863#3,2:202\n1#4:204\n*S KotlinDebug\n*F\n+ 1 PatternSearch.kt\ncom/embabel/agent/tools/file/PatternSearch\n*L\n67#1:197\n149#1:205\n78#1:198\n78#1:199,3\n90#1:202,2\n*E\n"})
public interface PatternSearch
extends DirectoryBased {
    @Tool(description="search for a regex in the project")
    @NotNull
    default public String findPatternInProject(@ToolParam(description="regex pattern") @NotNull String pattern, @ToolParam(description="glob pattern for files to search in") @NotNull String globPattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)globPattern, (String)"globPattern");
        return CollectionsKt.joinToString$default((Iterable)PatternSearch.findPatternInProject$default(this, new Regex(pattern), globPattern, false, 4, null), (CharSequence)"\n", null, null, (int)0, null, PatternSearch::findPatternInProject$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<PatternMatch> findPatternInProject(@NotNull Regex pattern, @NotNull String globPattern, boolean useParallelSearch) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)globPattern, (String)"globPattern");
        File root = new File(this.getRoot());
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException("Invalid root directory: " + root);
        }
        List results = new ArrayList();
        AtomicBoolean cancelled = new AtomicBoolean(false);
        List allFiles = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)root)), arg_0 -> PatternSearch.findPatternInProject$lambda$1(this, globPattern, arg_0)));
        boolean $i$f$loggerFor22 = false;
        Logger logger = LoggerFactory.getLogger(PatternSearch.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Object[] $i$f$loggerFor22 = new Object[]{allFiles.size(), globPattern, pattern.getPattern()};
        logger.info("Scanning {} files found using glob '{}' for regex pattern '{}'...", $i$f$loggerFor22);
        if (useParallelSearch && allFiles.size() > 100) {
            Iterator $this$mapTo$iv$iv;
            int numThreads = Runtime.getRuntime().availableProcessors();
            List chunks = CollectionsKt.chunked((Iterable)allFiles, (int)(allFiles.size() / numThreads + 1));
            Iterable $this$map$iv = chunks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void chunk;
                Object item$iv$iv = iterator.next();
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> PatternSearch.findPatternInProject$lambda$5$lambda$4((List)chunk, cancelled, this, pattern, results), (int)31, null));
            }
            List threads = (List)destination$iv$iv;
            Iterable $this$forEach$iv = threads;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread it = (Thread)element$iv;
                boolean bl = false;
                it.join();
            }
        } else {
            for (File file : allFiles) {
                PatternMatch it;
                if (this.scanFile(file, pattern) == null) continue;
                boolean bl = false;
                results.add(it);
            }
        }
        return results;
    }

    public static /* synthetic */ List findPatternInProject$default(PatternSearch patternSearch, Regex regex, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPatternInProject");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return patternSearch.findPatternInProject(regex, string, bl);
    }

    private PatternMatch scanFile(File file, Regex pattern) {
        try {
            List lines = FilesKt.readLines$default((File)file, null, (int)1, null);
            String fileContent = FilesKt.readText$default((File)file, null, (int)1, null);
            if (!pattern.containsMatchIn((CharSequence)fileContent)) {
                return null;
            }
            int n = ((Collection)lines).size();
            for (int i = 0; i < n; ++i) {
                String line = (String)lines.get(i);
                if (!pattern.containsMatchIn((CharSequence)line)) continue;
                int startLine = Math.max(0, i - 2);
                int endLine = Math.min(lines.size() - 1, i + 5);
                List<String> contextLines = lines.subList(startLine, endLine + 1);
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                return new PatternMatch(file, string, i + 1, contextLines);
            }
            return null;
        }
        catch (Exception e) {
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(PatternSearch.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("Error scanning file " + file.getPath() + ": " + e.getMessage());
            return null;
        }
    }

    default public boolean matchesGlob(@NotNull String path, @NotNull String globPattern) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)globPattern, (String)"globPattern");
        String[] stringArray = new String[]{"/"};
        List pathParts = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)path, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"/"};
        List patternParts = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)globPattern, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        String regexPattern = CollectionsKt.joinToString$default((Iterable)patternParts, (CharSequence)"/", null, null, (int)0, null, PatternSearch::matchesGlob$lambda$8, (int)30, null);
        CharSequence charSequence = StringsKt.replace$default((String)path, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        return new Regex(regexPattern).matches(charSequence);
    }

    private static CharSequence findPatternInProject$lambda$0(PatternMatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile().getPath() + ":" + it.getMatchedLine() + " " + CollectionsKt.joinToString$default((Iterable)it.getContextLines(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean findPatternInProject$lambda$1(PatternSearch this$0, String $globPattern, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isFile()) return false;
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!this$0.matchesGlob(string, $globPattern)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Unit findPatternInProject$lambda$5$lambda$4(List $chunk, AtomicBoolean $cancelled, PatternSearch this$0, Regex $pattern, List $results) {
        List threadResults = new ArrayList();
        for (File file : $chunk) {
            PatternMatch it;
            if ($cancelled.get()) break;
            if (this$0.scanFile(file, $pattern) == null) continue;
            boolean bl = false;
            threadResults.add(it);
        }
        List list = $results;
        synchronized (list) {
            boolean bl = false;
            $results.addAll(threadResults);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static CharSequence matchesGlob$lambda$8(String part) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        if (Intrinsics.areEqual((Object)part, (Object)"**")) {
            charSequence = ".*";
        } else if (StringsKt.contains$default((CharSequence)part, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)part, (CharSequence)"?", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)part, (CharSequence)"{", (boolean)false, (int)2, null)) {
            String string;
            if (StringsKt.contains$default((CharSequence)part, (CharSequence)"{", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)part, (CharSequence)"}", (boolean)false, (int)2, null)) {
                String prefix = StringsKt.substringBefore$default((String)part, (String)"{", null, (int)2, null);
                String[] stringArray = new String[]{","};
                List options = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)part, (String)"{", null, (int)2, null), (String)"}", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String suffix = StringsKt.substringAfter$default((String)part, (String)"}", null, (int)2, null);
                string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)(prefix + "(" + CollectionsKt.joinToString$default((Iterable)options, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")" + suffix), (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"*", (String)".*", (boolean)false, (int)4, null), (String)"?", (String)".", (boolean)false, (int)4, null);
            } else {
                string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)part, (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"*", (String)".*", (boolean)false, (int)4, null), (String)"?", (String)".", (boolean)false, (int)4, null);
            }
            charSequence = string;
        } else {
            charSequence = part;
        }
        return charSequence;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/embabel/agent/tools/file/PatternSearch$PatternMatch;", "", "file", "Ljava/io/File;", "relativePath", "", "matchedLine", "", "contextLines", "", "<init>", "(Ljava/io/File;Ljava/lang/String;ILjava/util/List;)V", "getFile", "()Ljava/io/File;", "getRelativePath", "()Ljava/lang/String;", "getMatchedLine", "()I", "getContextLines", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "embabel-agent-api"})
    public static final class PatternMatch {
        @NotNull
        private final File file;
        @NotNull
        private final String relativePath;
        private final int matchedLine;
        @NotNull
        private final List<String> contextLines;

        public PatternMatch(@NotNull File file, @NotNull String relativePath, int matchedLine, @NotNull List<String> contextLines) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter(contextLines, (String)"contextLines");
            this.file = file;
            this.relativePath = relativePath;
            this.matchedLine = matchedLine;
            this.contextLines = contextLines;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }

        public final int getMatchedLine() {
            return this.matchedLine;
        }

        @NotNull
        public final List<String> getContextLines() {
            return this.contextLines;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        @NotNull
        public final String component2() {
            return this.relativePath;
        }

        public final int component3() {
            return this.matchedLine;
        }

        @NotNull
        public final List<String> component4() {
            return this.contextLines;
        }

        @NotNull
        public final PatternMatch copy(@NotNull File file, @NotNull String relativePath, int matchedLine, @NotNull List<String> contextLines) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter(contextLines, (String)"contextLines");
            return new PatternMatch(file, relativePath, matchedLine, contextLines);
        }

        public static /* synthetic */ PatternMatch copy$default(PatternMatch patternMatch, File file, String string, int n, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                file = patternMatch.file;
            }
            if ((n2 & 2) != 0) {
                string = patternMatch.relativePath;
            }
            if ((n2 & 4) != 0) {
                n = patternMatch.matchedLine;
            }
            if ((n2 & 8) != 0) {
                list = patternMatch.contextLines;
            }
            return patternMatch.copy(file, string, n, list);
        }

        @NotNull
        public String toString() {
            return "PatternMatch(file=" + this.file + ", relativePath=" + this.relativePath + ", matchedLine=" + this.matchedLine + ", contextLines=" + this.contextLines + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + this.relativePath.hashCode();
            result = result * 31 + Integer.hashCode(this.matchedLine);
            result = result * 31 + ((Object)this.contextLines).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatternMatch)) {
                return false;
            }
            PatternMatch patternMatch = (PatternMatch)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)patternMatch.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.relativePath, (Object)patternMatch.relativePath)) {
                return false;
            }
            if (this.matchedLine != patternMatch.matchedLine) {
                return false;
            }
            return Intrinsics.areEqual(this.contextLines, patternMatch.contextLines);
        }
    }
}

