/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a8\u0006\u0006"}, d2={"resolvePath", "Ljava/nio/file/Path;", "root", "", "path", "resolveAndValidateFile", "embabel-agent-api"})
public final class FileToolsKt {
    private static final Path resolvePath(String root, String path) {
        Path basePath = Paths.get(root, new String[0]).toAbsolutePath().normalize();
        Path resolvedPath = basePath.resolve(path).normalize().toAbsolutePath();
        if (!resolvedPath.startsWith(basePath)) {
            throw new SecurityException("Path traversal attempt detected: " + path + ", root=" + root + ", resolved='" + resolvedPath + "', base=$'basePath'");
        }
        Intrinsics.checkNotNull((Object)resolvedPath);
        return resolvedPath;
    }

    private static final Path resolveAndValidateFile(String root, String path) {
        Path resolvedPath = FileToolsKt.resolvePath(root, path);
        if (!Files.exists(resolvedPath, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + path + ", root=" + root);
        }
        if (!Files.isRegularFile(resolvedPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Path is not a regular file: " + path + ", root=" + root);
        }
        return resolvedPath;
    }

    public static final /* synthetic */ Path access$resolvePath(String root, String path) {
        return FileToolsKt.resolvePath(root, path);
    }

    public static final /* synthetic */ Path access$resolveAndValidateFile(String root, String path) {
        return FileToolsKt.resolveAndValidateFile(root, path);
    }
}

