/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.springai;

import com.embabel.agent.spi.InvalidLlmReturnFormatException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.converter.StructuredOutputConverter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/spi/support/springai/ExceptionWrappingConverter;", "T", "Lorg/springframework/ai/converter/StructuredOutputConverter;", "expectedType", "Ljava/lang/Class;", "delegate", "<init>", "(Ljava/lang/Class;Lorg/springframework/ai/converter/StructuredOutputConverter;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "convert", "source", "", "(Ljava/lang/String;)Ljava/lang/Object;", "getFormat", "embabel-agent-api"})
public final class ExceptionWrappingConverter<T>
implements StructuredOutputConverter<T> {
    @NotNull
    private final Class<T> expectedType;
    @NotNull
    private final StructuredOutputConverter<T> delegate;
    private final Logger logger;

    public ExceptionWrappingConverter(@NotNull Class<T> expectedType, @NotNull StructuredOutputConverter<T> delegate) {
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.expectedType = expectedType;
        this.delegate = delegate;
        this.logger = LoggerFactory.getLogger(ExceptionWrappingConverter.class);
    }

    @Nullable
    public T convert(@NotNull String source) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.logger.debug("Raw LLM output: {}", (Object)source);
        try {
            object = this.delegate.convert((Object)source);
        }
        catch (Exception e) {
            this.logger.warn("Error {} converting LLM output: {}", (Object)e.getMessage(), (Object)source);
            throw new InvalidLlmReturnFormatException(source, this.expectedType, e);
        }
        return (T)object;
    }

    @Nullable
    public String getFormat() {
        return this.delegate.getFormat();
    }
}

