/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.WritableStore;
import com.embabel.agent.rag.ingestion.Ingester;
import com.embabel.agent.rag.ingestion.IngestionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.reader.TextReader;
import org.springframework.ai.transformer.splitter.TextSplitter;
import org.springframework.ai.transformer.splitter.TokenTextSplitter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0003H\u0016J\u0016\u0010\u001f\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0003H\u0002J\u001f\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/embabel/agent/rag/ingestion/MultiIngester;", "Lcom/embabel/agent/rag/ingestion/Ingester;", "stores", "", "Lcom/embabel/agent/rag/WritableStore;", "splitterProvider", "Lkotlin/Function0;", "Lorg/springframework/ai/transformer/splitter/TextSplitter;", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "getStores", "()Ljava/util/List;", "splitter", "getSplitter", "()Lorg/springframework/ai/transformer/splitter/TextSplitter;", "splitter$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "active", "", "ingest", "Lcom/embabel/agent/rag/ingestion/IngestionResult;", "resourcePath", "", "accept", "", "documents", "Lorg/springframework/ai/document/Document;", "writeToStores", "infoString", "verbose", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nMultiIngester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiIngester.kt\ncom/embabel/agent/rag/ingestion/MultiIngester\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1557#2:88\n1628#2,3:89\n1557#2:92\n1628#2,3:93\n*S KotlinDebug\n*F\n+ 1 MultiIngester.kt\ncom/embabel/agent/rag/ingestion/MultiIngester\n*L\n66#1:88\n66#1:89,3\n71#1:92\n71#1:93,3\n*E\n"})
public final class MultiIngester
implements Ingester {
    @NotNull
    private final List<WritableStore> stores;
    @NotNull
    private final Function0<TextSplitter> splitterProvider;
    @NotNull
    private final Lazy splitter$delegate;
    private final Logger logger;

    public MultiIngester(@NotNull List<? extends WritableStore> stores, @NotNull Function0<? extends TextSplitter> splitterProvider) {
        Intrinsics.checkNotNullParameter(stores, (String)"stores");
        Intrinsics.checkNotNullParameter(splitterProvider, (String)"splitterProvider");
        this.stores = stores;
        this.splitterProvider = splitterProvider;
        this.splitter$delegate = LazyKt.lazy(() -> MultiIngester.splitter_delegate$lambda$1(this));
        this.logger = LoggerFactory.getLogger(this.getClass());
        Object[] objectArray = new Object[]{this.getClass().getSimpleName(), this.getStores().size(), this.getSplitter()};
        this.logger.info("{} with {} writable rag services: Using text splitter {}", objectArray);
    }

    public /* synthetic */ MultiIngester(List list, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = MultiIngester::_init_$lambda$0;
        }
        this(list, (Function0<? extends TextSplitter>)function0);
    }

    @Override
    @NotNull
    public List<WritableStore> getStores() {
        return this.stores;
    }

    private final TextSplitter getSplitter() {
        Lazy lazy = this.splitter$delegate;
        return (TextSplitter)lazy.getValue();
    }

    @Override
    public boolean active() {
        return !((Collection)this.getStores()).isEmpty();
    }

    @Override
    @NotNull
    public IngestionResult ingest(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        List sourceDocs = new TextReader(resourcePath).get();
        List documents = this.getSplitter().split(sourceDocs);
        Object[] objectArray = new Object[]{sourceDocs.size(), resourcePath, documents.size(), this.getStores().size()};
        this.logger.info("Split {} source documents at {} into {} indexable chunks: Will write to {} writable rag services", objectArray);
        Intrinsics.checkNotNull((Object)documents);
        this.logger.debug("Documents: {}", (Object)CollectionsKt.joinToString$default((Iterable)documents, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return this.writeToStores(documents);
    }

    public void accept(@NotNull List<? extends Document> documents) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        this.writeToStores(documents);
    }

    /*
     * WARNING - void declaration
     */
    private final IngestionResult writeToStores(List<? extends Document> documents) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = this.getStores();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            WritableStore writableStore = (WritableStore)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            it.write(documents);
            collection.add(it.getName());
        }
        List storesWrittenTo = (List)destination$iv$iv;
        Iterable $this$map$iv2 = documents;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Document bl = (Document)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            collection.add(string);
        }
        List list = (List)destination$iv$iv2;
        Set set = CollectionsKt.toSet((Iterable)storesWrittenTo);
        return new IngestionResult(set, list);
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        return this.getStores().isEmpty() ? "No RAG services" : this.getClass().getSimpleName() + " of " + CollectionsKt.joinToString$default((Iterable)this.getStores(), (CharSequence)",", null, null, (int)0, null, MultiIngester::infoString$lambda$4, (int)30, null);
    }

    private static final TokenTextSplitter _init_$lambda$0() {
        return new TokenTextSplitter();
    }

    private static final TextSplitter splitter_delegate$lambda$1(MultiIngester this$0) {
        return (TextSplitter)this$0.splitterProvider.invoke();
    }

    private static final CharSequence infoString$lambda$4(WritableStore it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

