/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.Chunk;
import com.embabel.agent.rag.LeafSection;
import com.embabel.agent.rag.ingestion.MaterializedContainerSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002#$B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\rJ\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0017\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J\"\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\r2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\r2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/embabel/agent/rag/ingestion/ContentChunker;", "", "config", "Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "<init>", "(Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;)V", "getConfig", "()Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "chunk", "", "Lcom/embabel/agent/rag/Chunk;", "section", "Lcom/embabel/agent/rag/ingestion/MaterializedContainerSection;", "splitSections", "sections", "createSingleChunkFromContainer", "leaves", "Lcom/embabel/agent/rag/LeafSection;", "chunkLeavesIntelligently", "containerSection", "groupLeavesForOptimalChunking", "createCombinedLeafChunk", "createSingleLeafChunk", "leaf", "splitLeafIntoMultipleChunks", "splitText", "", "text", "splitBySentences", "getOverlapText", "previousChunk", "Config", "DefaultConfig", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nContentChunker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentChunker.kt\ncom/embabel/agent/rag/ingestion/ContentChunker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,412:1\n1#2:413\n1368#3:414\n1454#3,5:415\n774#3:420\n865#3,2:421\n1872#3,3:423\n774#3:426\n865#3,2:427\n1368#3:429\n1454#3,2:430\n774#3:432\n865#3,2:433\n1456#3,3:435\n774#3:438\n865#3,2:439\n774#3:441\n865#3,2:442\n1368#3:444\n1454#3,2:445\n774#3:447\n865#3,2:448\n1456#3,3:450\n774#3:453\n865#3,2:454\n*S KotlinDebug\n*F\n+ 1 ContentChunker.kt\ncom/embabel/agent/rag/ingestion/ContentChunker\n*L\n64#1:414\n64#1:415,5\n216#1:420\n216#1:421,2\n220#1:423,3\n243#1:426\n243#1:427,2\n306#1:429\n306#1:430,2\n311#1:432\n311#1:433,2\n306#1:435,3\n313#1:438\n313#1:439,2\n323#1:441\n323#1:442,2\n356#1:444\n356#1:445,2\n361#1:447\n361#1:448,2\n356#1:450,3\n363#1:453\n363#1:454,2\n*E\n"})
public final class ContentChunker {
    @NotNull
    private final Config config;
    private final Logger logger;

    public ContentChunker(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ ContentChunker(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = new DefaultConfig(0, 0, 3, null);
        }
        this(config);
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Chunk> chunk(@NotNull MaterializedContainerSection section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        List<LeafSection> leaves = section.leaves();
        Object[] objectArray = (Object[])leaves;
        int n = 0;
        for (Object t : objectArray) {
            void it;
            LeafSection leafSection = (LeafSection)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getContent().length() + it.getTitle().length() + 1;
            n = n2 + n3;
        }
        int totalContentLength = n;
        if (totalContentLength <= this.config.getMaxChunkSize()) {
            objectArray = new Object[]{section.getTitle(), leaves.size(), totalContentLength, this.config.getMaxChunkSize()};
            this.logger.debug("Creating single chunk for container section '{}' with {} leaves (total length: {} <= max: {})", objectArray);
            return CollectionsKt.listOf((Object)this.createSingleChunkFromContainer(section, leaves));
        }
        this.logger.debug("Total content ({} chars) exceeds maxChunkSize ({}), attempting intelligent grouping", (Object)totalContentLength, (Object)this.config.getMaxChunkSize());
        return this.chunkLeavesIntelligently(section, leaves);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Chunk> splitSections(@NotNull List<? extends MaterializedContainerSection> sections) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Iterable $this$flatMap$iv = sections;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MaterializedContainerSection it = (MaterializedContainerSection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.chunk(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Chunk createSingleChunkFromContainer(MaterializedContainerSection section, List<LeafSection> leaves) {
        String combinedContent = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)leaves, (CharSequence)"\n\n", null, null, (int)0, null, ContentChunker::createSingleChunkFromContainer$lambda$2, (int)30, null))).toString();
        Map combinedMetadata = new LinkedHashMap();
        combinedMetadata.putAll(section.getMetadata());
        combinedMetadata.put("container_section_id", section.getId());
        combinedMetadata.put("container_section_title", section.getTitle());
        combinedMetadata.put("container_section_url", section.getUri());
        combinedMetadata.put("chunk_index", 0);
        combinedMetadata.put("total_chunks", 1);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Chunk.Companion.invoke(string, combinedContent, combinedMetadata, section.getId());
    }

    private final List<Chunk> chunkLeavesIntelligently(MaterializedContainerSection containerSection, List<LeafSection> leaves) {
        List allChunks = new ArrayList();
        List<List<LeafSection>> leafGroups = this.groupLeavesForOptimalChunking(leaves);
        this.logger.debug("Grouped {} leaves into {} groups for chunking", (Object)leaves.size(), (Object)leafGroups.size());
        for (List<LeafSection> group : leafGroups) {
            boolean bl;
            if (group.size() == 1) {
                LeafSection leaf = (LeafSection)CollectionsKt.first(group);
                int leafContentSize = leaf.getContent().length() + leaf.getTitle().length() + 1;
                if (leafContentSize <= this.config.getMaxChunkSize()) {
                    bl = allChunks.add(this.createSingleLeafChunk(containerSection, leaf));
                    continue;
                }
                bl = allChunks.addAll((Collection)this.splitLeafIntoMultipleChunks(containerSection, leaf));
                continue;
            }
            bl = allChunks.add(this.createCombinedLeafChunk(containerSection, group));
        }
        return allChunks;
    }

    private final List<List<LeafSection>> groupLeavesForOptimalChunking(List<LeafSection> leaves) {
        List groups = new ArrayList();
        List currentGroup = new ArrayList();
        int currentGroupSize = 0;
        for (LeafSection leaf : leaves) {
            int leafSize = leaf.getContent().length() + leaf.getTitle().length() + 1;
            if (!((Collection)currentGroup).isEmpty() && currentGroupSize + leafSize + 2 > this.config.getMaxChunkSize()) {
                groups.add(CollectionsKt.toList((Iterable)currentGroup));
                currentGroup.clear();
                currentGroupSize = 0;
            }
            if (leafSize > this.config.getMaxChunkSize()) {
                if (!((Collection)currentGroup).isEmpty()) {
                    groups.add(CollectionsKt.toList((Iterable)currentGroup));
                    currentGroup.clear();
                    currentGroupSize = 0;
                }
                groups.add(CollectionsKt.listOf((Object)leaf));
                continue;
            }
            currentGroup.add(leaf);
            currentGroupSize += leafSize + 2;
        }
        if (!((Collection)currentGroup).isEmpty()) {
            groups.add(CollectionsKt.toList((Iterable)currentGroup));
        }
        return groups;
    }

    private final Chunk createCombinedLeafChunk(MaterializedContainerSection containerSection, List<LeafSection> leaves) {
        String combinedContent = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)leaves, (CharSequence)"\n\n", null, null, (int)0, null, ContentChunker::createCombinedLeafChunk$lambda$3, (int)30, null))).toString();
        Map combinedMetadata = new LinkedHashMap();
        combinedMetadata.putAll(containerSection.getMetadata());
        combinedMetadata.put("container_section_id", containerSection.getId());
        combinedMetadata.put("container_section_title", containerSection.getTitle());
        combinedMetadata.put("container_section_url", containerSection.getUri());
        combinedMetadata.put("chunk_index", 0);
        combinedMetadata.put("total_chunks", 1);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Chunk.Companion.invoke(string, combinedContent, combinedMetadata, containerSection.getId());
    }

    private final Chunk createSingleLeafChunk(MaterializedContainerSection containerSection, LeafSection leaf) {
        String content = !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? leaf.getTitle() + "\n" + leaf.getContent() : leaf.getContent();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"container_section_id", (Object)containerSection.getId()), TuplesKt.to((Object)"container_section_title", (Object)containerSection.getTitle()), TuplesKt.to((Object)"leaf_section_id", (Object)leaf.getId()), TuplesKt.to((Object)"leaf_section_title", (Object)leaf.getTitle()), TuplesKt.to((Object)"leaf_section_url", (Object)leaf.getUri()), TuplesKt.to((Object)"chunk_index", (Object)0), TuplesKt.to((Object)"total_chunks", (Object)1)};
        return Chunk.Companion.invoke(string, ((Object)StringsKt.trim((CharSequence)content)).toString(), MapsKt.plus(leaf.getMetadata(), (Map)MapsKt.mapOf((Pair[])pairArray)), leaf.getId());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Chunk> splitLeafIntoMultipleChunks(MaterializedContainerSection containerSection, LeafSection leaf) {
        void $this$filterTo$iv$iv;
        List chunks = new ArrayList();
        String fullContent = !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? leaf.getTitle() + "\n" + leaf.getContent() : leaf.getContent();
        Iterable $this$filter$iv = this.splitText(((Object)StringsKt.trim((CharSequence)fullContent)).toString());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List textChunks = (List)destination$iv$iv;
        this.logger.debug("Split leaf section '{}' into {} text chunks", (Object)leaf.getTitle(), (Object)textChunks.size());
        Iterable $this$forEachIndexed$iv = textChunks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void textChunk;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (String)item$iv;
            int index = n;
            boolean bl = false;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"container_section_id", (Object)containerSection.getId()), TuplesKt.to((Object)"container_section_title", (Object)containerSection.getTitle()), TuplesKt.to((Object)"leaf_section_id", (Object)leaf.getId()), TuplesKt.to((Object)"leaf_section_title", (Object)leaf.getTitle()), TuplesKt.to((Object)"leaf_section_url", (Object)leaf.getUri()), TuplesKt.to((Object)"chunk_index", (Object)index), TuplesKt.to((Object)"total_chunks", (Object)textChunks.size())};
            Chunk chunk = Chunk.Companion.invoke(string, ((Object)StringsKt.trim((CharSequence)((CharSequence)textChunk))).toString(), MapsKt.plus(leaf.getMetadata(), (Map)MapsKt.mapOf((Pair[])pairArray)), leaf.getId());
            chunks.add(chunk);
        }
        return chunks;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitText(String text) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterator $this$filterTo$iv$iv2;
        String[] stringArray = new String[]{"\n\n"};
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator<String> iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List paragraphs = (List)destination$iv$iv;
        List chunks = new ArrayList();
        StringBuilder currentChunk = new StringBuilder();
        for (String paragraph : paragraphs) {
            if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + paragraph.length() + 2 > this.config.getMaxChunkSize()) {
                String overlap;
                String string = currentChunk.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                currentChunk = new StringBuilder();
                if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + paragraph.length() + 2 <= this.config.getMaxChunkSize()) {
                    currentChunk.append(overlap).append("\n\n");
                }
            }
            if (paragraph.length() > this.config.getMaxChunkSize()) {
                List<String> sentenceChunks = this.splitBySentences(paragraph);
                for (String sentenceChunk : sentenceChunks) {
                    if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + sentenceChunk.length() + 2 > this.config.getMaxChunkSize()) {
                        String overlap;
                        String string = currentChunk.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                        currentChunk = new StringBuilder();
                        if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + sentenceChunk.length() + 2 <= this.config.getMaxChunkSize()) {
                            currentChunk.append(overlap).append("\n\n");
                        }
                    }
                    if (((CharSequence)currentChunk).length() > 0) {
                        currentChunk.append("\n\n");
                    }
                    currentChunk.append(sentenceChunk);
                }
                continue;
            }
            if (((CharSequence)currentChunk).length() > 0) {
                currentChunk.append("\n\n");
            }
            currentChunk.append(paragraph);
        }
        if (((CharSequence)currentChunk).length() > 0) {
            String string = currentChunk.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        iterator = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String chunk = (String)element$iv$iv;
            boolean bl = false;
            if (chunk.length() <= this.config.getMaxChunkSize()) {
                list = CollectionsKt.listOf((Object)chunk);
            } else {
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3 = StringsKt.chunked((CharSequence)chunk, (int)this.config.getMaxChunkSize());
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    String it = (String)element$iv$iv2;
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                    if (!bl4) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv3;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filter3 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl5 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl5) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List finalChunks = (List)destination$iv$iv2;
        Collection collection2 = finalChunks;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = ((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0 ? CollectionsKt.listOf((Object)((Object)StringsKt.trim((CharSequence)text)).toString()) : CollectionsKt.emptyList();
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitBySentences(String text) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterator $this$filterTo$iv$iv2;
        CharSequence charSequence = text;
        Regex regex = new Regex("(?<=[.!?])\\s+");
        int n = 0;
        Iterable $this$filter$iv2 = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv2.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sentences = (List)destination$iv$iv;
        List chunks = new ArrayList();
        StringBuilder currentChunk = new StringBuilder();
        for (String sentence : sentences) {
            if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + sentence.length() + 1 > this.config.getMaxChunkSize()) {
                String overlap;
                String string = currentChunk.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                currentChunk = new StringBuilder();
                if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + sentence.length() + 1 <= this.config.getMaxChunkSize()) {
                    currentChunk.append(overlap).append(" ");
                }
            }
            if (((CharSequence)currentChunk).length() > 0) {
                currentChunk.append(" ");
            }
            currentChunk.append(sentence);
        }
        if (((CharSequence)currentChunk).length() > 0) {
            String string = currentChunk.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        object = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String chunk = (String)element$iv$iv;
            boolean bl = false;
            if (chunk.length() <= this.config.getMaxChunkSize()) {
                list = CollectionsKt.listOf((Object)chunk);
            } else {
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3 = StringsKt.chunked((CharSequence)chunk, (int)this.config.getMaxChunkSize());
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    String it = (String)element$iv$iv2;
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                    if (!bl4) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv3;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filter3 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl5 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl5) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List finalChunks = (List)destination$iv$iv2;
        Collection collection2 = finalChunks;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = ((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0 ? CollectionsKt.listOf((Object)((Object)StringsKt.trim((CharSequence)text)).toString()) : CollectionsKt.emptyList();
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    private final String getOverlapText(String previousChunk) {
        String string;
        if (previousChunk.length() <= this.config.getOverlapSize()) {
            return "";
        }
        String overlap = StringsKt.takeLast((String)previousChunk, (int)this.config.getOverlapSize());
        int sentenceStart = StringsKt.indexOf$default((CharSequence)overlap, (String)". ", (int)0, (boolean)false, (int)6, null) + 2;
        if (sentenceStart > 1 && sentenceStart < overlap.length()) {
            String string2 = overlap.substring(sentenceStart);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String[] stringArray = new String[]{" "};
            List words = StringsKt.split$default((CharSequence)overlap, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            string = words.size() > 1 ? CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)words, (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) : "";
        }
        return string;
    }

    private static final CharSequence createSingleChunkFromContainer$lambda$2(LeafSection leaf) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        return !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? (CharSequence)(leaf.getTitle() + "\n" + leaf.getContent()) : (CharSequence)leaf.getContent();
    }

    private static final CharSequence createCombinedLeafChunk$lambda$3(LeafSection leaf) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        return !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? (CharSequence)(leaf.getTitle() + "\n" + leaf.getContent()) : (CharSequence)leaf.getContent();
    }

    public ContentChunker() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "", "maxChunkSize", "", "getMaxChunkSize", "()I", "overlapSize", "getOverlapSize", "embabel-agent-api"})
    public static interface Config {
        public int getMaxChunkSize();

        public int getOverlapSize();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/rag/ingestion/ContentChunker$DefaultConfig;", "Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "maxChunkSize", "", "overlapSize", "<init>", "(II)V", "getMaxChunkSize", "()I", "getOverlapSize", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "embabel-agent-api"})
    @SourceDebugExtension(value={"SMAP\nContentChunker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentChunker.kt\ncom/embabel/agent/rag/ingestion/ContentChunker$DefaultConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,412:1\n1#2:413\n*E\n"})
    public static final class DefaultConfig
    implements Config {
        private final int maxChunkSize;
        private final int overlapSize;

        @JvmOverloads
        public DefaultConfig(int maxChunkSize, int overlapSize) {
            this.maxChunkSize = maxChunkSize;
            this.overlapSize = overlapSize;
            if (!(this.getMaxChunkSize() > 0)) {
                boolean $i$a$-require-ContentChunker$DefaultConfig$42 = false;
                String $i$a$-require-ContentChunker$DefaultConfig$42 = "maxChunkSize must be positive";
                throw new IllegalArgumentException($i$a$-require-ContentChunker$DefaultConfig$42.toString());
            }
            if (!(this.getOverlapSize() >= 0)) {
                boolean $i$a$-require-ContentChunker$DefaultConfig$52 = false;
                String $i$a$-require-ContentChunker$DefaultConfig$52 = "overlapSize must be non-negative";
                throw new IllegalArgumentException($i$a$-require-ContentChunker$DefaultConfig$52.toString());
            }
            if (!(this.getOverlapSize() < this.getMaxChunkSize())) {
                boolean bl = false;
                String string = "overlapSize must be < maxChunkSize";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ DefaultConfig(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 1500;
            }
            if ((n3 & 2) != 0) {
                n2 = 200;
            }
            this(n, n2);
        }

        @Override
        public int getMaxChunkSize() {
            return this.maxChunkSize;
        }

        @Override
        public int getOverlapSize() {
            return this.overlapSize;
        }

        public final int component1() {
            return this.maxChunkSize;
        }

        public final int component2() {
            return this.overlapSize;
        }

        @NotNull
        public final DefaultConfig copy(int maxChunkSize, int overlapSize) {
            return new DefaultConfig(maxChunkSize, overlapSize);
        }

        public static /* synthetic */ DefaultConfig copy$default(DefaultConfig defaultConfig, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = defaultConfig.maxChunkSize;
            }
            if ((n3 & 2) != 0) {
                n2 = defaultConfig.overlapSize;
            }
            return defaultConfig.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "DefaultConfig(maxChunkSize=" + this.maxChunkSize + ", overlapSize=" + this.overlapSize + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.maxChunkSize);
            result = result * 31 + Integer.hashCode(this.overlapSize);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultConfig)) {
                return false;
            }
            DefaultConfig defaultConfig = (DefaultConfig)other;
            if (this.maxChunkSize != defaultConfig.maxChunkSize) {
                return false;
            }
            return this.overlapSize == defaultConfig.overlapSize;
        }

        @JvmOverloads
        public DefaultConfig(int maxChunkSize) {
            this(maxChunkSize, 0, 2, null);
        }

        @JvmOverloads
        public DefaultConfig() {
            this(0, 0, 3, null);
        }
    }
}

