/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag;

import com.embabel.agent.rag.Chunk;
import com.embabel.agent.rag.EntityData;
import com.embabel.agent.rag.Fact;
import com.embabel.agent.rag.RagResponse;
import com.embabel.agent.rag.RagResponseFormatter;
import com.embabel.agent.rag.Retrievable;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.core.types.SimilarityResult;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/embabel/agent/rag/SimpleRagResponseFormatter;", "Lcom/embabel/agent/rag/RagResponseFormatter;", "<init>", "()V", "NO_RESULTS_FOUND", "", "format", "ragResponse", "Lcom/embabel/agent/rag/RagResponse;", "embabel-agent-api"})
public final class SimpleRagResponseFormatter
implements RagResponseFormatter {
    @NotNull
    public static final SimpleRagResponseFormatter INSTANCE = new SimpleRagResponseFormatter();
    @NotNull
    public static final String NO_RESULTS_FOUND = "No results found";

    private SimpleRagResponseFormatter() {
    }

    @Override
    @NotNull
    public String format(@NotNull RagResponse ragResponse) {
        Intrinsics.checkNotNullParameter((Object)ragResponse, (String)"ragResponse");
        List<SimilarityResult<? extends Retrievable>> results = ragResponse.getResults();
        return results.isEmpty() ? NO_RESULTS_FOUND : CollectionsKt.joinToString$default((Iterable)results, (CharSequence)"\n\n", null, null, (int)0, null, SimpleRagResponseFormatter::format$lambda$0, (int)30, null);
    }

    private static final CharSequence format$lambda$0(SimilarityResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = "%.2f";
        Object[] objectArray = new Object[]{result.getScore()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String formattedScore = string2;
        Retrievable match = (Retrievable)result.getMatch();
        return match instanceof EntityData ? (CharSequence)(formattedScore + ": " + ((EntityData)match).embeddableValue()) : (match instanceof Chunk ? (CharSequence)(formattedScore + ": " + ((Chunk)match).getText()) : (match instanceof Fact ? (CharSequence)(formattedScore + ": fact - " + ((Fact)match).getAssertion()) : (CharSequence)(formattedScore + ": " + result.getMatch().getClass().getSimpleName() + " - " + HasInfoString.infoString$default((HasInfoString)match, (Boolean)true, (int)0, (int)2, null))));
    }
}

