/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core.support;

import com.embabel.agent.api.common.Asyncer;
import com.embabel.agent.api.common.PlatformServices;
import com.embabel.agent.channel.OutputChannel;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.AgentProcessCallback;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.Context;
import com.embabel.agent.core.ContextId;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.core.support.ConcurrentAgentProcess;
import com.embabel.agent.core.support.InMemoryBlackboard;
import com.embabel.agent.core.support.SimpleAgentProcess;
import com.embabel.agent.event.AgentDeploymentEvent;
import com.embabel.agent.event.AgentProcessCreationEvent;
import com.embabel.agent.event.AgenticEventListener;
import com.embabel.agent.event.ProcessKilledEvent;
import com.embabel.agent.spi.AgentProcessIdGenerator;
import com.embabel.agent.spi.AgentProcessRepository;
import com.embabel.agent.spi.ContextRepository;
import com.embabel.agent.spi.LlmOperations;
import com.embabel.agent.spi.OperationScheduler;
import com.embabel.agent.spi.PlannerFactory;
import com.embabel.agent.spi.ToolGroupResolver;
import com.embabel.agent.spi.config.spring.AgentPlatformProperties;
import com.embabel.agent.spi.support.GoapPlannerFactory;
import com.embabel.agent.spi.support.InMemoryAgentProcessRepository;
import com.embabel.agent.spi.support.InMemoryContextRepository;
import com.embabel.agent.spi.support.SpringContextPlatformServices;
import com.embabel.common.textio.template.TemplateRenderer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0093\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0001\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\u0003H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\u0003H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u0002030)H\u0016J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u000203H\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u0003H\u0012J,\u0010G\u001a\u00020=2\u0006\u0010A\u001a\u0002032\u0006\u0010D\u001a\u00020E2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020J0IH\u0016J,\u0010K\u001a\u00020=2\u0006\u0010A\u001a\u0002032\u0006\u0010D\u001a\u00020E2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020J0IH\u0016J\u0018\u0010L\u001a\u00020=2\u0006\u0010A\u001a\u0002032\u0006\u0010M\u001a\u00020=H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010+\u001a\n -*\u0004\u0018\u00010,0,X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010.R\u000e\u0010/\u001a\u000200X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020302X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u000205X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u000209X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;\u00a8\u0006N"}, d2={"Lcom/embabel/agent/core/support/DefaultAgentPlatform;", "Lcom/embabel/agent/core/AgentPlatform;", "name", "", "description", "processType", "Lcom/embabel/agent/spi/config/spring/AgentPlatformProperties$ProcessType;", "llmOperations", "Lcom/embabel/agent/spi/LlmOperations;", "toolGroupResolver", "Lcom/embabel/agent/spi/ToolGroupResolver;", "eventListener", "Lcom/embabel/agent/event/AgenticEventListener;", "agentProcessIdGenerator", "Lcom/embabel/agent/spi/AgentProcessIdGenerator;", "contextRepository", "Lcom/embabel/agent/spi/ContextRepository;", "agentProcessRepository", "Lcom/embabel/agent/spi/AgentProcessRepository;", "operationScheduler", "Lcom/embabel/agent/spi/OperationScheduler;", "asyncer", "Lcom/embabel/agent/api/common/Asyncer;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "outputChannel", "Lcom/embabel/agent/channel/OutputChannel;", "templateRenderer", "Lcom/embabel/common/textio/template/TemplateRenderer;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/embabel/agent/spi/config/spring/AgentPlatformProperties$ProcessType;Lcom/embabel/agent/spi/LlmOperations;Lcom/embabel/agent/spi/ToolGroupResolver;Lcom/embabel/agent/event/AgenticEventListener;Lcom/embabel/agent/spi/AgentProcessIdGenerator;Lcom/embabel/agent/spi/ContextRepository;Lcom/embabel/agent/spi/AgentProcessRepository;Lcom/embabel/agent/spi/OperationScheduler;Lcom/embabel/agent/api/common/Asyncer;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/embabel/agent/channel/OutputChannel;Lcom/embabel/common/textio/template/TemplateRenderer;Lorg/springframework/context/ApplicationContext;)V", "getName", "()Ljava/lang/String;", "getDescription", "getProcessType", "()Lcom/embabel/agent/spi/config/spring/AgentPlatformProperties$ProcessType;", "getToolGroupResolver", "()Lcom/embabel/agent/spi/ToolGroupResolver;", "callbacks", "", "Lcom/embabel/agent/core/AgentProcessCallback;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "plannerFactory", "Lcom/embabel/agent/spi/PlannerFactory;", "agents", "", "Lcom/embabel/agent/core/Agent;", "platformServices", "Lcom/embabel/agent/spi/support/SpringContextPlatformServices;", "getPlatformServices", "()Lcom/embabel/agent/spi/support/SpringContextPlatformServices;", "opaque", "", "getOpaque", "()Z", "getAgentProcess", "Lcom/embabel/agent/core/AgentProcess;", "id", "killAgentProcess", "deploy", "agent", "createBlackboard", "Lcom/embabel/agent/core/Blackboard;", "processOptions", "Lcom/embabel/agent/core/ProcessOptions;", "processId", "runAgentFrom", "bindings", "", "", "createAgentProcess", "createChildProcess", "parentAgentProcess", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nDefaultAgentPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAgentPlatform.kt\ncom/embabel/agent/core/support/DefaultAgentPlatform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1053#2:227\n*S KotlinDebug\n*F\n+ 1 DefaultAgentPlatform.kt\ncom/embabel/agent/core/support/DefaultAgentPlatform\n*L\n111#1:227\n*E\n"})
public class DefaultAgentPlatform
implements AgentPlatform {
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final AgentPlatformProperties.ProcessType processType;
    @NotNull
    private final LlmOperations llmOperations;
    @NotNull
    private final ToolGroupResolver toolGroupResolver;
    @NotNull
    private final AgenticEventListener eventListener;
    @NotNull
    private final AgentProcessIdGenerator agentProcessIdGenerator;
    @NotNull
    private final ContextRepository contextRepository;
    @NotNull
    private final AgentProcessRepository agentProcessRepository;
    @NotNull
    private final OperationScheduler operationScheduler;
    @NotNull
    private final Asyncer asyncer;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final OutputChannel outputChannel;
    @NotNull
    private final TemplateRenderer templateRenderer;
    @Nullable
    private final ApplicationContext applicationContext;
    @Autowired(required=false)
    @NotNull
    private List<? extends AgentProcessCallback> callbacks;
    private final Logger logger;
    @NotNull
    private final PlannerFactory plannerFactory;
    @NotNull
    private final Map<String, Agent> agents;
    @NotNull
    private final SpringContextPlatformServices platformServices;
    private final boolean opaque;

    public DefaultAgentPlatform(@Value(value="${embabel.agent.platform.name:default-agent-platform}") @NotNull String name, @Value(value="${embabel.agent.platform.description:Default Agent Platform}") @NotNull String description, @Value(value="${embabel.agent.platform.process-type:SIMPLE}") @NotNull AgentPlatformProperties.ProcessType processType, @NotNull LlmOperations llmOperations, @NotNull ToolGroupResolver toolGroupResolver, @NotNull AgenticEventListener eventListener, @NotNull AgentProcessIdGenerator agentProcessIdGenerator, @NotNull ContextRepository contextRepository, @NotNull AgentProcessRepository agentProcessRepository, @NotNull OperationScheduler operationScheduler, @NotNull Asyncer asyncer, @Qualifier(value="embabelJacksonObjectMapper") @NotNull ObjectMapper objectMapper, @NotNull OutputChannel outputChannel, @NotNull TemplateRenderer templateRenderer, @Nullable ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)processType), (String)"processType");
        Intrinsics.checkNotNullParameter((Object)llmOperations, (String)"llmOperations");
        Intrinsics.checkNotNullParameter((Object)toolGroupResolver, (String)"toolGroupResolver");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        Intrinsics.checkNotNullParameter((Object)agentProcessIdGenerator, (String)"agentProcessIdGenerator");
        Intrinsics.checkNotNullParameter((Object)contextRepository, (String)"contextRepository");
        Intrinsics.checkNotNullParameter((Object)agentProcessRepository, (String)"agentProcessRepository");
        Intrinsics.checkNotNullParameter((Object)operationScheduler, (String)"operationScheduler");
        Intrinsics.checkNotNullParameter((Object)asyncer, (String)"asyncer");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)outputChannel, (String)"outputChannel");
        Intrinsics.checkNotNullParameter((Object)templateRenderer, (String)"templateRenderer");
        this.name = name;
        this.description = description;
        this.processType = processType;
        this.llmOperations = llmOperations;
        this.toolGroupResolver = toolGroupResolver;
        this.eventListener = eventListener;
        this.agentProcessIdGenerator = agentProcessIdGenerator;
        this.contextRepository = contextRepository;
        this.agentProcessRepository = agentProcessRepository;
        this.operationScheduler = operationScheduler;
        this.asyncer = asyncer;
        this.objectMapper = objectMapper;
        this.outputChannel = outputChannel;
        this.templateRenderer = templateRenderer;
        this.applicationContext = applicationContext;
        this.callbacks = CollectionsKt.emptyList();
        this.logger = LoggerFactory.getLogger(DefaultAgentPlatform.class);
        this.plannerFactory = GoapPlannerFactory.INSTANCE;
        this.agents = new ConcurrentHashMap();
        LlmOperations llmOperations2 = this.llmOperations;
        AgenticEventListener agenticEventListener = this.eventListener;
        OperationScheduler operationScheduler2 = this.operationScheduler;
        Asyncer asyncer2 = this.asyncer;
        ObjectMapper objectMapper2 = this.objectMapper;
        ApplicationContext applicationContext2 = this.applicationContext;
        OutputChannel outputChannel2 = this.outputChannel;
        TemplateRenderer templateRenderer2 = this.templateRenderer;
        this.platformServices = new SpringContextPlatformServices(this, llmOperations2, agenticEventListener, operationScheduler2, asyncer2, objectMapper2, outputChannel2, templateRenderer2, applicationContext2);
        this.logger.debug("{}: event listener: {}", (Object)this.getName(), (Object)this.eventListener);
    }

    public /* synthetic */ DefaultAgentPlatform(String string, String string2, AgentPlatformProperties.ProcessType processType, LlmOperations llmOperations, ToolGroupResolver toolGroupResolver, AgenticEventListener agenticEventListener, AgentProcessIdGenerator agentProcessIdGenerator, ContextRepository contextRepository, AgentProcessRepository agentProcessRepository, OperationScheduler operationScheduler, Asyncer asyncer, ObjectMapper objectMapper, OutputChannel outputChannel, TemplateRenderer templateRenderer, ApplicationContext applicationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            agentProcessIdGenerator = AgentProcessIdGenerator.Companion.getRANDOM();
        }
        if ((n & 0x80) != 0) {
            contextRepository = new InMemoryContextRepository(null, 1, null);
        }
        if ((n & 0x100) != 0) {
            agentProcessRepository = new InMemoryAgentProcessRepository(null, 1, null);
        }
        if ((n & 0x200) != 0) {
            operationScheduler = OperationScheduler.Companion.getPRONTO();
        }
        if ((n & 0x4000) != 0) {
            applicationContext = null;
        }
        this(string, string2, processType, llmOperations, toolGroupResolver, agenticEventListener, agentProcessIdGenerator, contextRepository, agentProcessRepository, operationScheduler, asyncer, objectMapper, outputChannel, templateRenderer, applicationContext);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public AgentPlatformProperties.ProcessType getProcessType() {
        return this.processType;
    }

    @Override
    @NotNull
    public ToolGroupResolver getToolGroupResolver() {
        return this.toolGroupResolver;
    }

    @Override
    @NotNull
    public SpringContextPlatformServices getPlatformServices() {
        return this.platformServices;
    }

    @Override
    public boolean getOpaque() {
        return this.opaque;
    }

    @Override
    @Nullable
    public AgentProcess getAgentProcess(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.agentProcessRepository.findById(id);
    }

    @Override
    @Nullable
    public AgentProcess killAgentProcess(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AgentProcess process = this.agentProcessRepository.findById(id);
        if (process == null) {
            this.logger.warn("Agent process {} not found", (Object)id);
            return null;
        }
        this.logger.info("Killing agent process {}", (Object)id);
        ProcessKilledEvent killEvent = process.kill();
        if (killEvent != null) {
            this.eventListener.onProcessEvent(killEvent);
        } else {
            this.logger.warn("Failed to kill agent process {}", (Object)id);
        }
        return process;
    }

    @Override
    @NotNull
    public List<Agent> agents() {
        Iterable $this$sortedBy$iv = this.agents.values();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Agent it = (Agent)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Agent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @Override
    @NotNull
    public DefaultAgentPlatform deploy(@NotNull Agent agent) {
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        this.agents.put(agent.getName(), agent);
        this.logger.debug("\u2705 Deployed agent {}\n\tdescription: {}", (Object)agent.getName(), (Object)agent.getDescription());
        this.eventListener.onPlatformEvent(new AgentDeploymentEvent(this, agent));
        return this;
    }

    private Blackboard createBlackboard(ProcessOptions processOptions, String processId) {
        Blackboard blackboard;
        if (processOptions.getBlackboard() != null) {
            this.logger.info("Using existing blackboard {} for agent process {}", (Object)processOptions.getBlackboard().getBlackboardId(), (Object)processId);
            v0 = processOptions.getBlackboard();
        } else {
            v0 = blackboard = (Blackboard)new InMemoryBlackboard(null, 1, null);
        }
        if (processOptions.getContextId--400sNA() != null) {
            Context context = this.contextRepository.findById(processOptions.getContextId--400sNA());
            if (context != null) {
                this.logger.info("Using existing context {} for agent process {}", (Object)context.getId(), (Object)processId);
                context.populate(blackboard);
            } else {
                String string = processOptions.getContextId--400sNA();
                this.logger.warn("Context {} not found for agent process {}", (Object)(string != null ? ContextId.box-impl(string) : null), (Object)processId);
            }
        }
        return blackboard;
    }

    @Override
    @NotNull
    public AgentProcess runAgentFrom(@NotNull Agent agent, @NotNull ProcessOptions processOptions, @NotNull Map<String, ? extends Object> bindings) {
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        AgentProcess agentProcess = this.createAgentProcess(agent, processOptions, bindings);
        return agentProcess.run();
    }

    @Override
    @NotNull
    public AgentProcess createAgentProcess(@NotNull Agent agent, @NotNull ProcessOptions processOptions, @NotNull Map<String, ? extends Object> bindings) {
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        String id = this.agentProcessIdGenerator.createProcessId(agent, processOptions);
        Blackboard blackboard = this.createBlackboard(processOptions, id);
        blackboard.bindAll(bindings);
        SimpleAgentProcess agentProcess = switch (WhenMappings.$EnumSwitchMapping$0[this.getProcessType().ordinal()]) {
            case 1 -> {
                SpringContextPlatformServices var7_6 = this.getPlatformServices();
                PlannerFactory var8_7 = this.plannerFactory;
                yield new SimpleAgentProcess(id, null, agent, processOptions, blackboard, var7_6, var8_7, null, 128, null);
            }
            case 2 -> {
                SpringContextPlatformServices var7_6 = this.getPlatformServices();
                PlannerFactory var8_7 = this.plannerFactory;
                List<? extends AgentProcessCallback> var9_8 = this.callbacks;
                yield new ConcurrentAgentProcess(id, null, agent, processOptions, blackboard, var7_6, var8_7, null, var9_8, 128, null);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        this.logger.debug("\ud83d\ude80 Creating process {}", (Object)agentProcess.getId());
        this.agentProcessRepository.save(agentProcess);
        this.eventListener.onProcessEvent(new AgentProcessCreationEvent(agentProcess));
        return agentProcess;
    }

    @Override
    @NotNull
    public AgentProcess createChildProcess(@NotNull Agent agent, @NotNull AgentProcess parentAgentProcess) {
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)parentAgentProcess, (String)"parentAgentProcess");
        Blackboard childBlackboard = parentAgentProcess.getProcessContext().getBlackboard().spawn();
        ProcessOptions processOptions = parentAgentProcess.getProcessContext().getProcessOptions();
        PlatformServices platformServices = parentAgentProcess.getProcessContext().getPlatformServices$embabel_agent_api();
        String string = parentAgentProcess.getAgent().getName() + " >> " + this.agentProcessIdGenerator.createProcessId(agent, processOptions);
        String string2 = parentAgentProcess.getId();
        PlannerFactory plannerFactory = this.plannerFactory;
        SimpleAgentProcess childAgentProcess = new SimpleAgentProcess(string, string2, agent, processOptions, childBlackboard, platformServices, plannerFactory, null, 128, null);
        this.logger.debug("\ud83d\udc76 Creating child process {} from {}", (Object)childAgentProcess.getId(), (Object)parentAgentProcess.getId());
        this.agentProcessRepository.save(childAgentProcess);
        this.eventListener.onProcessEvent(new AgentProcessCreationEvent(childAgentProcess));
        return childAgentProcess;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AgentPlatformProperties.ProcessType.values().length];
            try {
                nArray[AgentPlatformProperties.ProcessType.SIMPLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentPlatformProperties.ProcessType.CONCURRENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

