/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.anthropic;

import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.Thinking;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.ai.anthropic.AnthropicChatOptions;
import org.springframework.ai.anthropic.api.AnthropicApi;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/embabel/agent/config/models/anthropic/AnthropicOptionsConverter;", "Lcom/embabel/common/ai/model/OptionsConverter;", "Lorg/springframework/ai/anthropic/AnthropicChatOptions;", "<init>", "()V", "DEFAULT_MAX_TOKENS", "", "convertOptions", "options", "Lcom/embabel/common/ai/model/LlmOptions;", "embabel-agent-anthropic-autoconfigure"})
public final class AnthropicOptionsConverter
implements OptionsConverter<AnthropicChatOptions> {
    @NotNull
    public static final AnthropicOptionsConverter INSTANCE = new AnthropicOptionsConverter();
    public static final int DEFAULT_MAX_TOKENS = 8192;

    private AnthropicOptionsConverter() {
    }

    @NotNull
    public AnthropicChatOptions convertOptions(@NotNull LlmOptions options) {
        AnthropicApi.ChatCompletionRequest.ThinkingConfig thinkingConfig;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Integer n = options.getMaxTokens();
        AnthropicChatOptions.Builder builder = AnthropicChatOptions.builder().temperature(options.getTemperature()).topP(options.getTopP()).maxTokens(Integer.valueOf(n != null ? n : 8192));
        Thinking thinking = options.getThinking();
        boolean bl = thinking != null ? thinking.getEnabled() : false;
        if (bl) {
            Thinking thinking2 = options.getThinking();
            Intrinsics.checkNotNull((Object)thinking2);
            thinkingConfig = new AnthropicApi.ChatCompletionRequest.ThinkingConfig(AnthropicApi.ThinkingType.ENABLED, thinking2.getTokenBudget());
        } else {
            thinkingConfig = new AnthropicApi.ChatCompletionRequest.ThinkingConfig(AnthropicApi.ThinkingType.DISABLED, null);
        }
        AnthropicChatOptions anthropicChatOptions = builder.thinking(thinkingConfig).topK(options.getTopK()).build();
        Intrinsics.checkNotNullExpressionValue((Object)anthropicChatOptions, (String)"build(...)");
        return anthropicChatOptions;
    }
}

