/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.anthropic;

import com.embabel.agent.config.models.anthropic.AnthropicModelDefinition;
import com.embabel.agent.config.models.anthropic.AnthropicModelDefinitions;
import com.embabel.agent.config.models.anthropic.AnthropicModelLoader;
import com.embabel.agent.config.models.anthropic.AnthropicOptionsConverter;
import com.embabel.agent.config.models.anthropic.AnthropicProperties;
import com.embabel.agent.config.models.anthropic.ThinkingConfiguration;
import com.embabel.common.ai.autoconfig.LlmAutoConfigMetadataLoader;
import com.embabel.common.ai.autoconfig.ProviderInitialization;
import com.embabel.common.ai.autoconfig.RegisteredModel;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PerTokenPricingModel;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import io.micrometer.observation.ObservationRegistry;
import java.time.LocalDate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.anthropic.AnthropicChatModel;
import org.springframework.ai.anthropic.AnthropicChatOptions;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AnthropicProperties.class})
@ExcludeFromJacocoGeneratedReport(reason="Anthropic configuration can't be unit tested")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B]\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J\u001a\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010$H\u0012J\b\u0010%\u001a\u00020&H\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/embabel/agent/config/models/anthropic/AnthropicModelsConfig;", "", "envBaseUrl", "", "envApiKey", "properties", "Lcom/embabel/agent/config/models/anthropic/AnthropicProperties;", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "requestFactory", "Lorg/springframework/http/client/ClientHttpRequestFactory;", "configurableBeanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "modelLoader", "Lcom/embabel/common/ai/autoconfig/LlmAutoConfigMetadataLoader;", "Lcom/embabel/agent/config/models/anthropic/AnthropicModelDefinitions;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/embabel/agent/config/models/anthropic/AnthropicProperties;Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;Lcom/embabel/common/ai/autoconfig/LlmAutoConfigMetadataLoader;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "baseUrl", "apiKey", "anthropicModelsInitializer", "Lcom/embabel/common/ai/autoconfig/ProviderInitialization;", "createAnthropicLlm", "Lcom/embabel/common/ai/model/Llm;", "modelDef", "Lcom/embabel/agent/config/models/anthropic/AnthropicModelDefinition;", "createDefaultOptions", "Lorg/springframework/ai/anthropic/AnthropicChatOptions;", "anthropicLlmOf", "name", "knowledgeCutoffDate", "Ljava/time/LocalDate;", "createAnthropicApi", "Lorg/springframework/ai/anthropic/api/AnthropicApi;", "embabel-agent-anthropic-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nAnthropicModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnthropicModelsConfig.kt\ncom/embabel/agent/config/models/anthropic/AnthropicModelsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n1863#2,2:292\n1#3:294\n*S KotlinDebug\n*F\n+ 1 AnthropicModelsConfig.kt\ncom/embabel/agent/config/models/anthropic/AnthropicModelsConfig\n*L\n122#1:292,2\n*E\n"})
public class AnthropicModelsConfig {
    @Nullable
    private final String envBaseUrl;
    @Nullable
    private final String envApiKey;
    @NotNull
    private final AnthropicProperties properties;
    @NotNull
    private final ObjectProvider<ObservationRegistry> observationRegistry;
    @NotNull
    private final ObjectProvider<ClientHttpRequestFactory> requestFactory;
    @NotNull
    private final ConfigurableBeanFactory configurableBeanFactory;
    @NotNull
    private final LlmAutoConfigMetadataLoader<AnthropicModelDefinitions> modelLoader;
    private final Logger logger;
    @Nullable
    private final String baseUrl;
    @NotNull
    private final String apiKey;

    public AnthropicModelsConfig(@Value(value="${ANTHROPIC_BASE_URL:#{null}}") @Nullable String envBaseUrl, @Value(value="${ANTHROPIC_API_KEY:#{null}}") @Nullable String envApiKey, @NotNull AnthropicProperties properties, @NotNull ObjectProvider<ObservationRegistry> observationRegistry, @Qualifier(value="aiModelHttpRequestFactory") @NotNull ObjectProvider<ClientHttpRequestFactory> requestFactory, @NotNull ConfigurableBeanFactory configurableBeanFactory, @NotNull LlmAutoConfigMetadataLoader<AnthropicModelDefinitions> modelLoader) {
        String string;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        Intrinsics.checkNotNullParameter(requestFactory, (String)"requestFactory");
        Intrinsics.checkNotNullParameter((Object)configurableBeanFactory, (String)"configurableBeanFactory");
        Intrinsics.checkNotNullParameter(modelLoader, (String)"modelLoader");
        this.envBaseUrl = envBaseUrl;
        this.envApiKey = envApiKey;
        this.properties = properties;
        this.observationRegistry = observationRegistry;
        this.requestFactory = requestFactory;
        this.configurableBeanFactory = configurableBeanFactory;
        this.modelLoader = modelLoader;
        this.logger = LoggerFactory.getLogger(AnthropicModelsConfig.class);
        String string2 = this.envBaseUrl;
        if (string2 == null) {
            string2 = this.baseUrl = this.properties.getBaseUrl();
        }
        if ((string = this.envApiKey) == null && (string = this.properties.getApiKey()) == null) {
            throw new IllegalStateException("Anthropic API key required: set ANTHROPIC_API_KEY env var or embabel.agent.platform.models.anthropic.api-key".toString());
        }
        this.apiKey = string;
        this.logger.info("Anthropic models are available: {}", (Object)this.properties);
    }

    public /* synthetic */ AnthropicModelsConfig(String string, String string2, AnthropicProperties anthropicProperties, ObjectProvider objectProvider, ObjectProvider objectProvider2, ConfigurableBeanFactory configurableBeanFactory, LlmAutoConfigMetadataLoader llmAutoConfigMetadataLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            llmAutoConfigMetadataLoader = (LlmAutoConfigMetadataLoader)new AnthropicModelLoader(null, null, 3, null);
        }
        this(string, string2, anthropicProperties, (ObjectProvider<ObservationRegistry>)objectProvider, (ObjectProvider<ClientHttpRequestFactory>)objectProvider2, configurableBeanFactory, (LlmAutoConfigMetadataLoader<AnthropicModelDefinitions>)llmAutoConfigMetadataLoader);
    }

    @Bean
    @NotNull
    public ProviderInitialization anthropicModelsInitializer() {
        List list;
        List $this$anthropicModelsInitializer_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = ((AnthropicModelDefinitions)this.modelLoader.loadAutoConfigMetadata()).getModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnthropicModelDefinition modelDef = (AnthropicModelDefinition)element$iv;
            boolean bl2 = false;
            try {
                Llm llm = this.createAnthropicLlm(modelDef);
                this.configurableBeanFactory.registerSingleton(modelDef.getName(), (Object)llm);
                $this$anthropicModelsInitializer_u24lambda_u241.add(new RegisteredModel(modelDef.getName(), modelDef.getModelId()));
                this.logger.info("Registered Anthropic model bean: {} -> {}", (Object)modelDef.getName(), (Object)modelDef.getModelId());
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{modelDef.getName(), modelDef.getModelId(), e};
                this.logger.error("Failed to create model: {} ({})", objectArray);
                throw e;
            }
        }
        List registeredLlms = CollectionsKt.build((List)list);
        List it = list = new ProviderInitialization("Anthropic", registeredLlms, null, null, 12, null);
        boolean bl3 = false;
        this.logger.info(it.summary());
        return list;
    }

    private Llm createAnthropicLlm(AnthropicModelDefinition modelDef) {
        PerTokenPricingModel perTokenPricingModel;
        AnthropicChatModel chatModel = AnthropicChatModel.builder().defaultOptions(this.createDefaultOptions(modelDef)).anthropicApi(this.createAnthropicApi()).toolCallingManager((ToolCallingManager)ToolCallingManager.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(AnthropicModelsConfig::createAnthropicLlm$lambda$3)).build()).retryTemplate(this.properties.retryTemplate("anthropic-" + modelDef.getModelId())).observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(AnthropicModelsConfig::createAnthropicLlm$lambda$4)).build();
        String string = modelDef.getModelId();
        Intrinsics.checkNotNull((Object)chatModel);
        AnthropicChatModel anthropicChatModel = chatModel;
        AnthropicOptionsConverter anthropicOptionsConverter = AnthropicOptionsConverter.INSTANCE;
        LocalDate localDate = modelDef.getKnowledgeCutoffDate();
        PerTokenPricingModel perTokenPricingModel2 = modelDef.getPricingModel();
        if (perTokenPricingModel2 != null) {
            PerTokenPricingModel it = perTokenPricingModel2;
            boolean bl = false;
            perTokenPricingModel = new PerTokenPricingModel(it.getUsdPer1mInputTokens(), it.getUsdPer1mOutputTokens());
        } else {
            perTokenPricingModel = null;
        }
        PerTokenPricingModel perTokenPricingModel3 = perTokenPricingModel;
        return new Llm(string, "Anthropic", (ChatModel)anthropicChatModel, (OptionsConverter)anthropicOptionsConverter, localDate, null, (PricingModel)perTokenPricingModel3, 32, null);
    }

    private AnthropicChatOptions createDefaultOptions(AnthropicModelDefinition modelDef) {
        AnthropicChatOptions.Builder builder;
        block6: {
            ThinkingConfiguration thinkingConfiguration;
            AnthropicChatOptions.Builder $this$createDefaultOptions_u24lambda_u249;
            block5: {
                $this$createDefaultOptions_u24lambda_u249 = builder = AnthropicChatOptions.builder().model(modelDef.getModelId()).maxTokens(Integer.valueOf(modelDef.getMaxTokens())).temperature(Double.valueOf(modelDef.getTemperature()));
                boolean bl = false;
                Double d = modelDef.getTopP();
                if (d != null) {
                    double it = ((Number)d).doubleValue();
                    boolean bl2 = false;
                    $this$createDefaultOptions_u24lambda_u249.topP(Double.valueOf(it));
                }
                Integer n = modelDef.getTopK();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl3 = false;
                    $this$createDefaultOptions_u24lambda_u249.topK(Integer.valueOf(it));
                }
                if ((thinkingConfiguration = modelDef.getThinking()) == null) break block5;
                ThinkingConfiguration thinkingConfig = thinkingConfiguration;
                boolean bl4 = false;
                AnthropicChatOptions.Builder builder2 = $this$createDefaultOptions_u24lambda_u249.thinking(new AnthropicApi.ChatCompletionRequest.ThinkingConfig(AnthropicApi.ThinkingType.ENABLED, thinkingConfig.getTokenBudget()));
                thinkingConfiguration = builder2;
                if (builder2 != null) break block6;
            }
            thinkingConfiguration = $this$createDefaultOptions_u24lambda_u249.thinking(new AnthropicApi.ChatCompletionRequest.ThinkingConfig(AnthropicApi.ThinkingType.DISABLED, null));
        }
        AnthropicChatOptions anthropicChatOptions = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)anthropicChatOptions, (String)"build(...)");
        return anthropicChatOptions;
    }

    private Llm anthropicLlmOf(String name, LocalDate knowledgeCutoffDate) {
        AnthropicChatModel chatModel = AnthropicChatModel.builder().defaultOptions(AnthropicChatOptions.builder().model(name).build()).anthropicApi(this.createAnthropicApi()).toolCallingManager((ToolCallingManager)ToolCallingManager.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(AnthropicModelsConfig::anthropicLlmOf$lambda$10)).build()).retryTemplate(this.properties.retryTemplate("anthropic-" + name)).observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(AnthropicModelsConfig::anthropicLlmOf$lambda$11)).build();
        Intrinsics.checkNotNull((Object)chatModel);
        AnthropicChatModel anthropicChatModel = chatModel;
        AnthropicOptionsConverter anthropicOptionsConverter = AnthropicOptionsConverter.INSTANCE;
        return new Llm(name, "Anthropic", (ChatModel)anthropicChatModel, (OptionsConverter)anthropicOptionsConverter, knowledgeCutoffDate, null, null, 96, null);
    }

    /*
     * WARNING - void declaration
     */
    private AnthropicApi createAnthropicApi() {
        void b;
        AnthropicApi.Builder builder = AnthropicApi.builder().apiKey(this.apiKey);
        CharSequence charSequence = this.baseUrl;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.logger.info("Using custom Anthropic base URL: {}", (Object)this.baseUrl);
            builder.baseUrl(this.baseUrl);
        }
        CharSequence charSequence2 = charSequence = RestClient.builder();
        AnthropicApi.Builder builder2 = builder;
        boolean bl = false;
        this.requestFactory.ifAvailable(arg_0 -> AnthropicModelsConfig.createAnthropicApi$lambda$13$lambda$12((RestClient.Builder)b, arg_0));
        builder2.restClientBuilder(charSequence.observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(AnthropicModelsConfig::createAnthropicApi$lambda$14)));
        builder.webClientBuilder(WebClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(AnthropicModelsConfig::createAnthropicApi$lambda$15)));
        AnthropicApi anthropicApi = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)anthropicApi, (String)"build(...)");
        return anthropicApi;
    }

    private static final ObservationRegistry createAnthropicLlm$lambda$3() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry createAnthropicLlm$lambda$4() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry anthropicLlmOf$lambda$10() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry anthropicLlmOf$lambda$11() {
        return ObservationRegistry.NOOP;
    }

    private static final void createAnthropicApi$lambda$13$lambda$12(RestClient.Builder $b, ClientHttpRequestFactory it) {
        $b.requestFactory(it);
    }

    private static final ObservationRegistry createAnthropicApi$lambda$14() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry createAnthropicApi$lambda$15() {
        return ObservationRegistry.NOOP;
    }
}

