/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.a2a.server.support;

import com.embabel.agent.a2a.server.AgentCardHandler;
import com.embabel.agent.a2a.server.support.AutonomyA2ARequestHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.a2a.spec.AgentCard;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.JSONRPCErrorResponse;
import io.a2a.spec.NonStreamingJSONRPCRequest;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.StreamingJSONRPCRequest;
import jakarta.servlet.ServletRequest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001e\u0010\u0015\u001a\u00020\u00012\u0014\b\u0001\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u0017H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/a2a/server/support/AgentCardHandlerWebFacade;", "", "agentCardHandler", "Lcom/embabel/agent/a2a/server/AgentCardHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/embabel/agent/a2a/server/AgentCardHandler;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getAgentCardHandler", "()Lcom/embabel/agent/a2a/server/AgentCardHandler;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "agentCard", "Lorg/springframework/http/ResponseEntity;", "Lio/a2a/spec/AgentCard;", "servletRequest", "Ljakarta/servlet/ServletRequest;", "handleJsonRpc", "requestMap", "", "", "embabel-agent-a2a"})
final class AgentCardHandlerWebFacade {
    @NotNull
    private final AgentCardHandler agentCardHandler;
    @NotNull
    private final ObjectMapper objectMapper;
    private final Logger logger;

    public AgentCardHandlerWebFacade(@NotNull AgentCardHandler agentCardHandler, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)agentCardHandler, (String)"agentCardHandler");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.agentCardHandler = agentCardHandler;
        this.objectMapper = objectMapper;
        this.logger = LoggerFactory.getLogger(AgentCardHandlerWebFacade.class);
    }

    @NotNull
    public final AgentCardHandler getAgentCardHandler() {
        return this.agentCardHandler;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @ResponseBody
    @NotNull
    public final ResponseEntity<AgentCard> agentCard(@NotNull ServletRequest servletRequest) {
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        String string = servletRequest.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
        String string2 = servletRequest.getServerName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getServerName(...)");
        AgentCard agentCard = this.agentCardHandler.agentCard(string, string2, servletRequest.getServerPort());
        ResponseEntity responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)agentCard);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @ResponseBody
    @NotNull
    public final Object handleJsonRpc(@RequestBody @NotNull Map<String, ? extends Object> requestMap) {
        Intrinsics.checkNotNullParameter(requestMap, (String)"requestMap");
        try {
            block24: {
                block25: {
                    block26: {
                        block23: {
                            var4_2 = requestMap.get("method");
                            method = var4_2 instanceof String != false ? (String)var4_2 : null;
                            requestId = requestMap.get("id");
                            var5_5 /* !! */  = new Object[3];
                            var5_5 /* !! */ [0] = method;
                            var5_5 /* !! */ [1] = requestId;
                            var7_7 = requestMap.get("params");
                            v0 = var7_7 instanceof Map != false ? (Map)var7_7 : null;
                            var5_5 /* !! */ [2] = v0 != null ? v0.keySet() : null;
                            this.logger.info("Received JSON-RPC request: method='{}', id='{}', params keys={}", var5_5 /* !! */ );
                            this.logger.debug("Full JSON-RPC request: {}", requestMap);
                            var5_5 /* !! */  = method;
                            if (!Intrinsics.areEqual((Object)var5_5 /* !! */ , (Object)"message/stream")) break block23;
                            this.logger.debug("Processing streaming request for method: {}", (Object)method);
                            try {
                                request = (SendStreamingMessageRequest)this.objectMapper.convertValue(requestMap, SendStreamingMessageRequest.class);
                                this.logger.debug("Successfully deserialized SendStreamingMessageRequest");
                                Intrinsics.checkNotNull((Object)request);
                                request = this.agentCardHandler.handleJsonRpcStream((StreamingJSONRPCRequest)request);
                            }
                            catch (Exception e) {
                                this.logger.error("Failed to deserialize or handle streaming request", (Throwable)e);
                                throw e;
                            }
                            v1 = request;
                            break block24;
                        }
                        if (!Intrinsics.areEqual((Object)var5_5 /* !! */ , (Object)"tasks/resubscribe")) break block25;
                        this.logger.debug("Processing resubscribe request for method: {}", (Object)method);
                        if (!(this.agentCardHandler instanceof AutonomyA2ARequestHandler)) break block26;
                        v1 = ((AutonomyA2ARequestHandler)this.agentCardHandler).handleCustomStreamingRequest(method, requestMap, this.objectMapper);
                        break block24;
                    }
                    throw new UnsupportedOperationException("Method " + method + " is not supported by this handler");
                }
                this.logger.debug("Processing non-streaming request for method: {}", (Object)method);
                var8_13 = method;
                if (var8_13 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var8_13.hashCode()) {
                    case -1330443120: {
                        if (var8_13.equals("message/send")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 197325141: {
                        if (var8_13.equals("tasks/get")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case -1415243749: {
                        if (var8_13.equals("tasks/cancel")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        try {
                            var9_14 = (SendMessageRequest)this.objectMapper.convertValue(requestMap, SendMessageRequest.class);
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to deserialize SendMessageRequest", (Throwable)e);
                            throw e;
                        }
                        v2 = (NonStreamingJSONRPCRequest)var9_14;
                        break;
                    }
                    case 2: {
                        try {
                            var9_14 = (GetTaskRequest)this.objectMapper.convertValue(requestMap, GetTaskRequest.class);
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to deserialize GetTaskRequest", (Throwable)e);
                            throw e;
                        }
                        v2 = (NonStreamingJSONRPCRequest)var9_14;
                        break;
                    }
                    case 3: {
                        try {
                            var9_14 = (CancelTaskRequest)this.objectMapper.convertValue(requestMap, CancelTaskRequest.class);
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to deserialize CancelTaskRequest", (Throwable)e);
                            throw e;
                        }
                        v2 = (NonStreamingJSONRPCRequest)var9_14;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        this.logger.warn("Unsupported method: {}", (Object)method);
                        throw new UnsupportedOperationException("Method " + method + " is not supported");
                    }
                }
                request = v2;
                v3 = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON);
                Intrinsics.checkNotNull((Object)request);
                request = v3.body(this.agentCardHandler.handleJsonRpc(request));
                Intrinsics.checkNotNull((Object)request);
                v1 = request;
            }
            return v1;
        }
        catch (Exception e) {
            requestId = requestMap.getOrDefault("id", "unknown");
            method = requestMap.getOrDefault("method", "unknown");
            var7_9 = new Object[]{method, requestId, e.getMessage(), e};
            this.logger.error("Error handling JSON-RPC request: method='{}', id='{}', error={}", var7_9);
            var2_18 = ResponseEntity.status((int)500).contentType(MediaType.APPLICATION_JSON).body((Object)new JSONRPCErrorResponse(requestId, new JSONRPCError(Integer.valueOf(500), "Internal server error: " + e.getMessage(), null)));
            Intrinsics.checkNotNull((Object)var2_18);
            return var2_18;
        }
    }
}

