package com.emarsys.core.util;

import android.content.Context;
import android.webkit.URLUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;

public class FileUtils {

    private static final int BUFFER_SIZE = 4096;

    public static String download(Context context, String path) {
        String result = null;
        if (path != null && context != null && URLUtil.isHttpsUrl(path)) {
            try {
                File cacheFolder = context.getCacheDir();
                String fileName = UUID.randomUUID().toString();
                File resultFile = new File(cacheFolder, fileName);
                resultFile.createNewFile();
                InputStream inputStream = inputStreamFromUrl(path);
                FileOutputStream fos = new FileOutputStream(resultFile, false);
                int bytesRead;
                byte[] buffer = new byte[BUFFER_SIZE];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
                result = resultFile.toURI().toURL().getPath();
                fos.close();
                inputStream.close();
            } catch (IOException ignored) {
            }
        }
        return result;
    }

    public static void delete(String path) {
        Assert.notNull(path, "Path must not be null!");
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File %s does not exists.", path));
        }
        file.delete();
    }

    static InputStream inputStreamFromUrl(String path) throws IOException {
        URL url = new URL(path);
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setDoInput(true);
        connection.connect();
        return connection.getInputStream();
    }
}
