package com.emarsys.core.queue.sqlite;

public final class RequestContract {
    private RequestContract() {
    }

    public static final String TABLE_NAME = "request";
    public static final String COLUMN_NAME_REQUEST_ID = "request_id";
    public static final String COLUMN_NAME_METHOD = "method";
    public static final String COLUMN_NAME_URL = "url";
    public static final String COLUMN_NAME_HEADERS = "headers";
    public static final String COLUMN_NAME_PAYLOAD = "payload";
    public static final String COLUMN_NAME_TIMESTAMP = "timestamp";

    public static final String SQL_CREATE_TABLE = String.format(
            "CREATE TABLE IF NOT EXISTS %s (" +
                    "%s TEXT," +
                    "%s TEXT," +
                    "%s TEXT," +
                    "%s BLOB," +
                    "%s BLOB," +
                    "%s INTEGER" +
                    ");",
            TABLE_NAME,
            COLUMN_NAME_REQUEST_ID,
            COLUMN_NAME_METHOD,
            COLUMN_NAME_URL,
            COLUMN_NAME_HEADERS,
            COLUMN_NAME_PAYLOAD,
            COLUMN_NAME_TIMESTAMP
    );

    public static final String SQL_COUNT = String.format(
            "SELECT COUNT(*) FROM %s;",
            TABLE_NAME
    );

    public static final String SQL_CLEAR = String.format(
            "DELETE FROM %s;", TABLE_NAME
    );

    public static final String SQL_SELECTFIRST = String.format(
            "SELECT * FROM %s ORDER BY ROWID ASC LIMIT 1;", TABLE_NAME
    );

    public static final String SQL_DELETE_ITEM = "DELETE FROM " + TABLE_NAME +
            " WHERE " + COLUMN_NAME_REQUEST_ID + " LIKE '%s';";
}

