package com.emarsys.core.connection;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.emarsys.core.util.Assert;

public class ConnectionWatchDog {

    IntentFilter intentFilter = new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION);

    BroadcastReceiver receiver;

    ConnectivityManager connectivityManager;

    Context context;

    public ConnectionWatchDog(Context context) {
        Assert.notNull(context, "Context must not be null!");
        this.context = context.getApplicationContext();
        this.connectivityManager = (ConnectivityManager) this.context.getSystemService(Context.CONNECTIVITY_SERVICE);
    }

    public ConnectionState getConnectionState() {
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();

        if (activeNetwork == null || !activeNetwork.isConnected()) {
            return ConnectionState.DISCONNECTED;
        } else if (ConnectivityManager.TYPE_MOBILE == activeNetwork.getType()
                || ConnectivityManager.TYPE_MOBILE_DUN == activeNetwork.getType()) {
            return ConnectionState.CONNECTED_MOBILE_DATA;
        }

        return ConnectionState.CONNECTED;
    }

    public boolean isConnected() {
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public void registerReceiver(ConnectionChangeListener connectionChangeListener) {
        if (receiver == null) {
            receiver = new ConnectivityChangeReceiver(connectionChangeListener);
            context.registerReceiver(receiver, intentFilter);
        } else {
            throw new IllegalStateException("Register receiver cannot be called multiple times!");
        }
    }

    class ConnectivityChangeReceiver extends BroadcastReceiver {

        ConnectionChangeListener connectionChangeListener;

        public ConnectivityChangeReceiver(ConnectionChangeListener connectionChangeListener) {
            Assert.notNull(connectionChangeListener, "ConnectionChangeListener must not be null!");
            this.connectionChangeListener = connectionChangeListener;
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            connectionChangeListener.onConnectionChanged(
                    getConnectionState(),
                    isConnected());
        }

    }

}
