/*
 * Decompiled with CFR 0.152.
 */
package com.emailage.javawrapper.utilities;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class OAuth {
    private static final Random _Random = new Random();
    private static final String _UnreservedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.~";
    private static final String HMACSHA1 = "HMAC-SHA1";
    private static final String HMACSHA256 = "HMAC-SHA256";
    private static final String HMACSHA384 = "HMAC-SHA384";
    private static final String HMACSHA512 = "HMAC-SHA512";

    public static String getUrl(String method, String hashAlgorithm, String url, String consumerKey, String consumerSecret) {
        String querystring;
        if (method == null) {
            method = "GET";
        }
        if (hashAlgorithm == null) {
            hashAlgorithm = HMACSHA1;
        }
        double nowDates = new Date().getTime();
        String timestamp = String.valueOf(Math.floor(nowDates));
        String nonce = OAuth.GetRandomString(10);
        int index = url.indexOf(63);
        if (index == -1) {
            querystring = "";
        } else {
            querystring = url.substring(index + 1);
            url = url.substring(0, index);
        }
        String[] splString = querystring.split("&");
        HashMap<String, String> query = new HashMap<String, String>();
        for (String splString1 : splString) {
            int in = splString1.indexOf("=");
            if (in == -1) {
                query.put(splString1, null);
                continue;
            }
            String key = splString1.substring(0, in);
            String value = splString1.substring(in + 1);
            query.put(key, value);
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = query.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            sb.append(key.concat(query.get(key = (String)iterator.next()) == null ? "" : "=" + (String)query.get(key))).append("&");
        }
        sb.append("oauth_consumer_key=").append(consumerKey).append("&");
        sb.append("oauth_nonce=").append(nonce).append("&");
        sb.append("oauth_signature_method=").append(hashAlgorithm).append("&");
        sb.append("oauth_timestamp=").append(timestamp).append("&");
        sb.append("oauth_version=").append(1.0);
        querystring = sb.toString();
        String data = "";
        try {
            data = method.toUpperCase().concat("&").concat(URLEncoder.encode(url, "utf-8")).concat("&").concat(URLEncoder.encode(querystring, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        String sig = "";
        try {
            sig = URLEncoder.encode(new String(OAuth.toBase64(OAuth.HmacEncrypt(data, consumerSecret + "&", hashAlgorithm))), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url.concat("?").concat(querystring).concat("&oauth_signature=").concat(sig);
    }

    private static String GetRandomString(int length) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result.append(_UnreservedChars.charAt(_Random.nextInt(25)));
        }
        return result.toString();
    }

    public static byte[] HmacEncrypt(String encryptText, String encryptKey, String algorithm) throws Exception {
        Mac mac;
        byte[] keybytes = encryptKey.getBytes("UTF-8");
        switch (algorithm) {
            case "HMAC-SHA1": {
                mac = Mac.getInstance("HMACSHA1");
                SecretKeySpec key = new SecretKeySpec(keybytes, "HMACSHA1");
                mac.init(key);
                break;
            }
            case "HMAC-SHA256": {
                mac = Mac.getInstance("HMACSHA256");
                SecretKeySpec key = new SecretKeySpec(keybytes, "HMACSHA256");
                mac.init(key);
                break;
            }
            case "HMAC-SHA384": {
                mac = Mac.getInstance("HMACSHA384");
                SecretKeySpec key = new SecretKeySpec(keybytes, "HMACSHA384");
                mac.init(key);
                break;
            }
            case "HMAC-SHA512": {
                mac = Mac.getInstance("HMACSHA512");
                SecretKeySpec key = new SecretKeySpec(keybytes, "HMACSHA512");
                mac.init(key);
                break;
            }
            default: {
                mac = Mac.getInstance("HMACSHA1");
                SecretKeySpec key = new SecretKeySpec(keybytes, "HMACSHA1");
                mac.init(key);
            }
        }
        byte[] text = encryptText.getBytes("UTF-8");
        return mac.doFinal(text);
    }

    public static String toBase64(byte[] bs) {
        return Base64.encodeBase64String((byte[])bs);
    }
}

