/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.internal;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.elvishew.xlog.formatter.message.object.BundleFormatter;
import com.elvishew.xlog.formatter.message.object.IntentFormatter;
import com.elvishew.xlog.formatter.message.object.ObjectFormatter;
import com.elvishew.xlog.printer.AndroidPrinter;
import com.elvishew.xlog.printer.ConsolePrinter;
import com.elvishew.xlog.printer.Printer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    public static Platform get() {
        return PLATFORM;
    }

    @SuppressLint(value={"NewApi"})
    String lineSeparator() {
        return System.lineSeparator();
    }

    Printer defaultPrinter() {
        return new ConsolePrinter();
    }

    Map<Class<?>, ObjectFormatter<?>> builtinObjectFormatters() {
        return Collections.emptyMap();
    }

    public void warn(String msg) {
        System.out.println(msg);
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Platform();
    }

    static class Android
    extends Platform {
        private static final Map<Class<?>, ObjectFormatter<?>> BUILTIN_OBJECT_FORMATTERS;

        Android() {
        }

        @Override
        String lineSeparator() {
            if (Build.VERSION.SDK_INT < 19) {
                return "\n";
            }
            return System.lineSeparator();
        }

        @Override
        Printer defaultPrinter() {
            return new AndroidPrinter();
        }

        @Override
        Map<Class<?>, ObjectFormatter<?>> builtinObjectFormatters() {
            return BUILTIN_OBJECT_FORMATTERS;
        }

        @Override
        public void warn(String msg) {
            Log.w((String)"XLog", (String)msg);
        }

        static {
            HashMap<Class, ObjectFormatter<Bundle>> objectFormatters = new HashMap<Class, ObjectFormatter<Bundle>>();
            objectFormatters.put(Bundle.class, new BundleFormatter());
            objectFormatters.put(Intent.class, new IntentFormatter());
            BUILTIN_OBJECT_FORMATTERS = Collections.unmodifiableMap(objectFormatters);
        }
    }
}

