/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

public class LogLevel {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ALL = Integer.MIN_VALUE;
    public static final int NONE = Integer.MAX_VALUE;

    public static String getLevelName(int logLevel) {
        String levelName;
        switch (logLevel) {
            case 2: {
                levelName = "VERBOSE";
                break;
            }
            case 3: {
                levelName = "DEBUG";
                break;
            }
            case 4: {
                levelName = "INFO";
                break;
            }
            case 5: {
                levelName = "WARN";
                break;
            }
            case 6: {
                levelName = "ERROR";
                break;
            }
            default: {
                levelName = logLevel < 2 ? "VERBOSE-" + (2 - logLevel) : "ERROR+" + (logLevel - 6);
            }
        }
        return levelName;
    }

    public static String getShortLevelName(int logLevel) {
        String levelName;
        switch (logLevel) {
            case 2: {
                levelName = "V";
                break;
            }
            case 3: {
                levelName = "D";
                break;
            }
            case 4: {
                levelName = "I";
                break;
            }
            case 5: {
                levelName = "W";
                break;
            }
            case 6: {
                levelName = "E";
                break;
            }
            default: {
                levelName = logLevel < 2 ? "V-" + (2 - logLevel) : "E+" + (logLevel - 6);
            }
        }
        return levelName;
    }
}

