/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.yaml;

import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.concurrent.StampedConfig;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.core.io.WritingException;
import com.electronwill.nightconfig.core.utils.TransformingList;
import com.electronwill.nightconfig.core.utils.TransformingMap;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class YamlWriter
implements ConfigWriter {
    private final Yaml yaml;

    public YamlWriter() {
        this(new Yaml());
    }

    public YamlWriter(Yaml yaml) {
        this.yaml = yaml;
    }

    public YamlWriter(DumperOptions options) {
        this(new Yaml(options));
    }

    public void write(UnmodifiableConfig config, Writer writer) {
        if (config instanceof StampedConfig) {
            config = ((StampedConfig)config).newAccumulatorCopy();
        }
        try {
            Map<String, Object> unwrappedMap = YamlWriter.unwrap(config);
            this.yaml.dump(unwrappedMap, writer);
        }
        catch (Exception e) {
            throw new WritingException("YAML writing failed", (Throwable)e);
        }
    }

    private static Map<String, Object> unwrap(UnmodifiableConfig config) {
        return new TransformingMap(config.valueMap(), YamlWriter::unwrap, v -> v, v -> v);
    }

    private static List<Object> unwrapList(List<Object> list) {
        return new TransformingList(list, YamlWriter::unwrap, v -> v, v -> v);
    }

    private static Object unwrap(Object value) {
        if (value instanceof UnmodifiableConfig) {
            return YamlWriter.unwrap((UnmodifiableConfig)value);
        }
        if (value instanceof List) {
            return YamlWriter.unwrapList((List)value);
        }
        if (value == NullObject.NULL_OBJECT) {
            return null;
        }
        return value;
    }
}

