/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.yaml;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.core.utils.TransformingList;
import com.electronwill.nightconfig.core.utils.TransformingMap;
import com.electronwill.nightconfig.yaml.YamlFormat;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public final class YamlParser
implements ConfigParser<Config> {
    private final Yaml yaml;
    private final ConfigFormat<Config> configFormat;

    public YamlParser(YamlFormat configFormat) {
        this.yaml = configFormat.yaml;
        this.configFormat = configFormat;
    }

    public YamlParser(Yaml yaml) {
        this.yaml = yaml;
        this.configFormat = YamlFormat.configuredInstance(yaml);
    }

    public YamlParser(LoaderOptions options) {
        this(new Yaml(options));
    }

    public ConfigFormat<Config> getFormat() {
        return this.configFormat;
    }

    public Config parse(Reader reader) {
        Config config = this.configFormat.createConfig();
        this.parse(reader, config, ParsingMode.MERGE);
        return config;
    }

    public void parse(Reader reader, Config destination, ParsingMode parsingMode) {
        try {
            Map<String, Object> wrappedMap = this.wrap((Map)this.yaml.loadAs(reader, Map.class));
            parsingMode.prepareParsing(destination);
            if (parsingMode == ParsingMode.ADD) {
                for (Map.Entry<String, Object> entry : wrappedMap.entrySet()) {
                    destination.valueMap().putIfAbsent(entry.getKey(), entry.getValue());
                }
            } else {
                destination.valueMap().putAll(wrappedMap);
            }
        }
        catch (Exception e) {
            throw new ParsingException("YAML parsing failed", (Throwable)e);
        }
    }

    private Map<String, Object> wrap(Map<String, Object> map) {
        return new TransformingMap(map, this::wrap, v -> v, v -> v);
    }

    private List<Object> wrapList(List<Object> list) {
        return new TransformingList(list, this::wrap, v -> v, v -> v);
    }

    private Object wrap(Object value) {
        if (value instanceof Map) {
            Map<String, Object> map = this.wrap((Map)value);
            return Config.wrap(map, this.configFormat);
        }
        if (value instanceof List) {
            return this.wrapList((List)value);
        }
        if (value == null) {
            return NullObject.NULL_OBJECT;
        }
        return value;
    }
}

