/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.yaml;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FormatDetector;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.yaml.YamlParser;
import com.electronwill.nightconfig.yaml.YamlWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public final class YamlFormat
implements ConfigFormat<Config> {
    private static final ThreadLocal<YamlFormat> LOCAL_DEFAULT_FORMAT = ThreadLocal.withInitial(() -> new YamlFormat(new Yaml()));
    final Yaml yaml;

    public static YamlFormat defaultInstance() {
        return LOCAL_DEFAULT_FORMAT.get();
    }

    public static YamlFormat configuredInstance(Yaml yaml) {
        return new YamlFormat(yaml);
    }

    public static Config newConfig() {
        return YamlFormat.defaultInstance().createConfig();
    }

    public static Config newConcurrentConfig() {
        return YamlFormat.defaultInstance().createConcurrentConfig();
    }

    private YamlFormat(Yaml yaml) {
        this.yaml = yaml;
    }

    public ConfigWriter createWriter() {
        return new YamlWriter(this.yaml);
    }

    public ConfigParser<Config> createParser() {
        return new YamlParser(this);
    }

    public Config createConfig() {
        return Config.of((ConfigFormat)this);
    }

    public Config createConcurrentConfig() {
        return Config.ofConcurrent((ConfigFormat)this);
    }

    public boolean supportsComments() {
        return false;
    }

    public boolean supportsType(Class<?> type) {
        return type == null || type == Boolean.class || type == String.class || type == Date.class || type == java.sql.Date.class || type == Timestamp.class || type == byte[].class || type == Object[].class || Number.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || Config.class.isAssignableFrom(type);
    }

    static {
        FormatDetector.registerExtension((String)"yaml", YamlFormat::defaultInstance);
        FormatDetector.registerExtension((String)"yml", YamlFormat::defaultInstance);
    }
}

